/*
 * realloc.c
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<ctype.h>
#include<limits.h>
#include<stdlib.h>
#include"malloc.h"


void *realloc(void *ptr,size_t size)
{
	void *mem;
	size_t rsize = size + sizeof(MALLOC_HEAD);
	MALLOC_HEAD *head;


	if (ptr == NULL)
		return malloc(size);
	if (size == 0)
	{
		free(ptr);
		return NULL;
	}

	head = (MALLOC_HEAD*)ptr-1;
	if (head->head.magic != MAGIC_NUMBER)	/* ҡפ˲Ƥ롣 */
		return NULL;

	if (rsize > (1 << head->head.index))	/* (1 << head->head.index) = ߤͿ줿 */
	{
		if ((mem = malloc(size)) == NULL)
			return NULL;
		memcpy(mem,ptr,(1 << head->head.index) - sizeof(MALLOC_HEAD));
		free(ptr);
		return mem;
	}
	else
		return ptr;
}
