/*
 * malloc.c
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<ctype.h>
#include<limits.h>
#include"malloc.h"
#if DEBUG
#include<stdio.h>
#endif

MALLOC_HEAD *nextHead[HEADER_NUM];


static const char indexNumber[]={
	0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
};


void *malloc(size_t size)
{
	int index;
	size_t rsize = size + sizeof(MALLOC_HEAD);
	MALLOC_HEAD *head;


	if (size == 0)
		return  NULL;
	if (size > UINT_MAX - sizeof(MALLOC_HEAD))
		return  NULL;

	if (rsize < MIN_SIZE)
		rsize = MIN_SIZE;

	/* ǥå */
	if (rsize < 0x100)
		index = indexNumber[rsize];
	else if (rsize < 0x10000)
		index = indexNumber[rsize >> 8] + 8;
	else if (rsize < 0x1000000)
		index = indexNumber[rsize >> 16] + 16;
	else
	{
		index = indexNumber[rsize >> 24] + 24;
		if (index == 32)
			return NULL;
	}

	/* ꡼ */
	if (nextHead[index] != NULL)
	{
		head = nextHead[index];
#if DEBUG
	if (((void*)head < 0x40000000) || ((void*)0xfec00000 <= head))
		fprintf(stderr,"malloc() head is uncomplete! head=0x%x size=%d call from 0x%x",head,size,*((uint*)&size - 1));
#endif
		nextHead[index] = head->next;
	}
	else
	{
		head = sbrk(1 << index);
		if (head == NULL)
			return NULL;
	}
	head->head.magic = MAGIC_NUMBER;
	head->head.index = index;

	return (void*)(head + 1);
}
