/*
 * sys/wait.h
 */


#ifndef sys_wait_h
#define sys_wait_h


#include<sys/types.h>


#ifndef ASM_FILE


enum{
	/* Symbolic constants for use with waitpid() */
	WNOHANG=1<<0,		/* Do not hang if no status is available; return immediately. */
	WUNTRACED=1<<1,		/* Report status of stopped child process. */

	/*
	 * waitԒl̕]}Np̃rbgVtglB
	 * @@@@@1 | 1 1 1 1 1 1 1 1 | 1 | 1 1 1 1 1 1 1 1 | 1 | 1 1 1 1 1 1 1 1 | 1 1 1 1 1
	 * rbgl@0   1                 9   10                18  19
	 */
	WIFEXITED_SHIFT=0,
	WEXITSTATUS_SHIFT=1,
	WIFSIGNALED_SHIFT=9,
	WTERMSIG_SHIFT=10,
	WIFSTOPPED_SHIFT=18,
	WSTOPSI_SHIFT=19
};


#ifndef KERNEL

/*
 * Macros for analysis of process status values.
 */
/* True if child exited normally. */
#define	WIFEXITED(stat)		((int)((stat)&0xFF) == 0)
/* True if child exited due to uncaught signal. */
#define	WIFSIGNALED(stat)	((int)((stat)&0xFF) > 0 && (int)((stat)&0xFF00) == 0)
/* True if child is currently stopped. */
#define	WIFSTOPPED(stat)	((int)((stat)&0xFF) == 0x7F && (int)((stat)&0xFF00) != 0)
/* Return exit status. */
#define	WEXITSTATUS(stat)	((int)(((stat)>>8)&0xFF))
/* Return signal number that caused process to terminate. */
#define	WTERMSIG(stat)		((int)((stat)&0x7F))
/* Return signal number that caused process to stop. */
#define	WSTOPSIG(stat)		((int)(((stat)>>8)&0xFF))


extern pid_t  wait(int *);
extern pid_t  waitpid(pid_t, int *, int);

#endif


#endif


#endif
