/*
 * sys/time.h
 */


#ifndef sys_time_h
#define sys_time_h


#include<sys/cdefs.h>
#include<sys/select.h>


#ifndef ASM_FILE


/*
 * Names of the interval timers, and structure
 * defining a timer setting.
 *աΥǥåǻѤΤɬ0Ϣ֤ˤ
 */
#define	ITIMER_REAL		0
#define	ITIMER_VIRTUAL	1
#define	ITIMER_PROF		2

struct itimerval {
    struct  timeval it_interval;    /* timer interval */
    struct  timeval it_value;   	/* current value */
};


struct timezone {
    int tz_minuteswest; /* minutes west of Greenwich */
    int tz_dsttime; 	/* type of dst correction */
};

/*
 * Structure defined by POSIX.4 to be like a timeval.
 */
struct timespec {
	time_t	ts_sec;		/* seconds */
	long	ts_nsec;	/* and nanoseconds */
};


/* ץ */
#define	TIMEVAL_TO_TIMESPEC(tv, ts) {				\
	(ts)->ts_sec = (tv)->tv_sec;					\
	(ts)->ts_nsec = (tv)->tv_usec * 1000;			\
}
#define	TIMESPEC_TO_TIMEVAL(tv, ts) {				\
	(tv)->tv_sec = (ts)->ts_sec;					\
	(tv)->tv_usec = (ts)->ts_nsec / 1000;			\
}

#define	timerclear(tvp)		(tvp)->tv_sec = (tvp)->tv_usec = 0
#define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
#define	timercmp(tvp, uvp, cmp)						\
	(((tvp)->tv_sec == (uvp)->tv_sec) ?				\
	    ((tvp)->tv_usec cmp (uvp)->tv_usec) :		\
	    ((tvp)->tv_sec cmp (uvp)->tv_sec))
#define timersub(tvp, uvp, vvp)						\
	do {								\
		(vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;		\
		(vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;	\
		if ((vvp)->tv_usec < 0) {				\
			(vvp)->tv_sec--;				\
			(vvp)->tv_usec += 1000000;			\
		}							\
	} while (0)

#ifdef KERNEL

#define getmicrotime gettimeofday
extern void	getmicrouptime __P((struct timeval *tv));
extern void	microtime __P((struct timeval *tv));
extern void	timevaladd __P((struct timeval *, struct timeval *));
extern void	timevalsub __P((struct timeval *, struct timeval *));
extern time_t	time_second();


#else

extern int utimes(const char *path, const struct timeval *times);
extern int lutimes(const char *path, const struct timeval *times);
extern int gettimeofday(struct timeval *tv, struct timezone *tz);
extern int settimeofday(struct timeval *tp, const struct timezone *tzp);
extern int getitimer (int, struct itimerval *);
extern int setitimer (int, const struct itimerval *, struct itimerval *);

#endif


#endif


#endif
