/*
 * sys/signal.h
 */


#ifndef sys_signal_h
#define sys_signal_h


#ifndef ASM_FILE


typedef void(*SIG_ACTION)(int);
typedef	SIG_ACTION	sig_t;

/* signal actions. */
#define SIG_DFL (SIG_ACTION)1	/* default action. */
#define SIG_IGN (SIG_ACTION)2	/* ignore. */
#define	SIG_ERR (SIG_ACTION)-1	/* Return value from signal() in case of error. */

/*
 * signals.
 * default actions.
 *  A=abnormal termination,T=termination,C=continue process,S=stop process,I=ignore the signal
 */
#define SIGABRT		1		/* A	ܡȡ */
#define SIGALRM		2		/* T	顼ࡦå */
#define SIGBUS		3		/* A	Х顼ʥɥ쥹顼ˡ */
#define SIGCHLD		4		/* I	ҥץξѲ */
#define SIGCONT		5		/* C	ߥץμ¹Է³ʥץ򵯤) */
#define SIGFPE		6		/* A	㳰 */
#define SIGHUP		7		/* T	ϥ󥰥åס */
#define SIGILL		8		/* A	̿ᡣ */
#define SIGINT		9		/* T	󥿥ץȡctl+cˡ */
#define SIGKILL		10		/* T	ץζλ(̵Բ) */
#define SIGPIPE		11		/* T	ɤ߼Τʤѥפؤν񤭹ߡ */
#define SIGIO		12
#define SIGPOLL		SIGIO	/* T	input/output possible signal */
#define SIGPROF		13		/* T	ץե󥰡ޡλĶᡣ */
#define SIGQUIT		14		/* A	λ */
#define SIGSEGV		15		/* A	ơȿɥ쥹ȡ */
#define SIGSTOP		16		/* S	ץߡª̵Բǽˡ */
#define SIGSYS		17		/* A	ƥࡦ롣 */
#define SIGTERM		18		/* T	ץνλ */
#define SIGTRAP		19		/* A	ȥ졼⤷ϥ֥졼ݥȤ˴Ťȥåס */
#define SIGTSTP		20		/* S	ץߡCtrl-zʤɤΥˡ */
#define SIGTTIN		21		/* S	ϻΥץߡ */
#define SIGTTOU		22		/* S	ϻΥץߡ */
#define SIGURG		23		/* I	åȶ۵޾֡ */
#define SIGUSR1		24		/* T	桼ʥ뭡 */
#define SIGUSR2		25		/* T	桼ʥ뭢 */
#define SIGVTALRM	26		/* T	ۥޡλĶᡣ */
#define SIGXCPU		27		/* A	CPU¤Ķᡣ */
#define SIGXFSZ		28		/* A	ե롦¤Ķᡣ */
#define SIGWINCH	29		/* I	window size changes */
#define SIGINFO		30		/* I	information request */
#define SIGWAKE		31		/* I	ץƥ */
#define NSIG		32		/* ʥ륢 */

enum{
	SA_ONSTACK = 1,	/* Causes signal delivery to occur on an alternate stack. */
	SA_RESTART = 2,	/* Restart system on signal return. */
	SA_DISABLE = 4,	/* Disable taking signals on alternate stack. */

	SIG_BLOCK = 1,	/* The resulting set is the union of the current set and the signal set pointed to by the argument set. */
	SIG_UNBLOCK,	/* The resulting set is the intersection of the current set and the complement of the signal set pointed to by the argument set. */
	SIG_SETMASK,	/* The resulting set is the signal set pointed to by the argument set. */

	/* sig_pending()ѥե饰 */
	SIG_PENDING_SOTORE=0,
	SIG_PENDING_SET
};


typedef unsigned int sigset_t;


struct sigaction{
	void (*sa_handler)(int);	/* What to do on receipt of signal. */
	sigset_t sa_mask;			/* Set of signals to be blocked during execution of the signal handling function. */
	int      sa_flags;			/* Special flags. */
};


#endif


#endif
