/*
 * Copyright (c) 1987, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)malloc.h	8.5 (Berkeley) 5/3/95
 * $FreeBSD: src/sys/sys/malloc.h,v 1.48.2.3 2003/08/09 16:21:20 luoqi Exp $
 */

#ifndef _SYS_MALLOC_H_
#define	_SYS_MALLOC_H_


#ifdef KERNEL


#include <sys/cdefs.h>
#include <sys/param.h>
#include <kern/lib.h>
#include <kern/mm.h>


/*
 * flags to malloc.
 */
#define	M_WAITOK		0x0000
#define	M_NOWAIT		0x0001		/* do not block */
#define	M_USE_RESERVE	0x0002		/* can alloc out of reserve memory */
#define	M_ASLEEP		0x0004		/* async sleep on failure */
#define	M_ZERO			0x0008		/* bzero the allocation */
#define	M_MAGIC			877983977	/* time when first defined :-) */
#define	MINALLOCSIZE	(1 << MINBUCKET)


struct malloc_type {
	struct malloc_type	*ks_next;		/* next in list */
	long				ks_memuse;		/* total memory held in bytes */
	long				ks_limit;		/* most that are allowed to exist */
	long				ks_size;		/* sizes of this thing that are allocated */
	long				ks_inuse;		/* # of packets of this type currently in use */
	int64_t				ks_calls;		/* total packets of this type ever allocated */
	long				ks_maxused;		/* maximum number ever used */
	u_long				ks_magic;		/* if it's not magic, don't touch it */
	const char			*ks_shortdesc;	/* short description */
	u_short				ks_limblocks;	/* number of times blocked for hitting limit */
	u_short				ks_mapblocks;	/* number of times blocked for kernel map */
};


#define	MALLOC_DEFINE(type, shortdesc, longdesc)
/*#define	MALLOC_DEFINE(type, shortdesc, longdesc) \
	struct malloc_type type[1] = { \
		{ NULL, 0, 0, 0, 0, 0, 0, M_MAGIC, shortdesc, 0, 0 } \
	}; \
	SYSINIT(type##_init, SI_SUB_KMEM, SI_ORDER_ANY, malloc_init, type); \
	SYSUNINIT(type##_uninit, SI_SUB_KMEM, SI_ORDER_ANY, malloc_uninit, type)
*/
#define	MALLOC_DECLARE(type)
/*#define	MALLOC_DECLARE(type) \
	extern struct malloc_type type[1]
*/
#define	MALLOC(space, cast, size, type, flags) (space) = kmalloc(size)
/*#define	MALLOC(space, cast, size, type, flags) \
	(space) = (cast)malloc((u_long)(size), (type), (flags))
*/
#define	FREE(addr, type) kfree(addr)
//#define	FREE(addr, type) free((addr), (type))
#define malloc(a, b, c) kmalloc(a)
#define free(a, b) kfree(a)
#define contigmalloc(size, type, flags, low, high, alignment, boundary) kmalloc(size)
#define contigfree(addr, size, type) kfree(addr)


#endif /* KERNEL */


#endif /* !_SYS_MALLOC_H_ */
