/*
 * limits.h
 */

#ifndef SYS_LIMITS_H
#define	SYS_LIMITS_H


/* Posix minimam value. */
#define	_POSIX_ARG_MAX			4096	/* Maximum length of argument to the exec functions including environment data. */
#define	_POSIX_CHILD_MAX		6		/* Maximum number of simultaneous processes per real user ID. */
#define	_POSIX_STREAM_MAX		8		/* The number of streams that one process can have open at one time. */
#define	_POSIX_TZNAME_MAX		6		/* Maximum number of bytes supported for the name of a timezone. */
#define	_POSIX_OPEN_MAX			20		/* Maximum number of files that one process can have open at any one time. */
#define	_POSIX_LINK_MAX			8		/* Maximum number of links to a single file. */
#define	_POSIX_MAX_CANON		255		/* Maximum number of bytes in a terminal canonical input queue. */
#define	_POSIX_MAX_INPUT		255		/* Maximum number of bytes allowed in a terminal input queue. */
#define	_POSIX_NAME_MAX			14		/* Maximum number of bytes in a filename (not including terminating null). */
#define	_POSIX_PATH_MAX			256		/* Maximum number of bytes in a pathname. */
#define	_POSIX_PIPE_BUF			512		/* Maximum number of bytes that is guaranteed to be atomic when writing to a pipe. */
#define	_POSIX_TTY_NAME_MAX		9		/* The size of the storage required for a terminal device name, including the terminating null. */
#define	_POSIX_HOST_NAME_MAX	255		/* Maximum length of a host name (not including the terminating null) as returned from the gethostname() function. */
#define	_POSIX_LOGIN_NAME_MAX	9		/* The size of the storage required for a login name, in bytes, including the terminating null. */
#define	_POSIX_NGROUPS_MAX		8		/* Maximum number of simultaneous supplementary group IDs per process. */
#define	_POSIX2_RE_DUP_MAX		255
#define	_POSIX2_LINE_MAX		2048

#define	PATH_MAX	_POSIX_PATH_MAX


#endif
