/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)errno.h	8.5 (Berkeley) 1/21/94
 * $Id: errno.h,v 1.5 1996/08/18 16:16:18 peter Exp $
 */


#ifndef _SYS_ERRNO_H_
#define _SYS_ERRNO_H_


#ifndef KERNEL
#ifdef	_THREAD_SAFE
#include <sys/cdefs.h>
__BEGIN_DECLS
int *	__error __P((void));
__END_DECLS
#define errno (* __error())
#else
extern int errno;			/* global error number */
#endif
#endif


/* FREEBSDhCo[̓G[ԍlKeBuɕύX */
#ifdef FREEBSD_DRIVER
#define NEGATIVE -1
#else
#define NEGATIVE 1
#endif


#define	EPERM			(1 * NEGATIVE)		/* Operation not permitted */
#define	ENOENT			(2 * NEGATIVE)		/* No such file or directory */
#define	ESRCH			(3 * NEGATIVE)		/* No such process */
#define	EINTR			(4 * NEGATIVE)		/* Interrupted system call */
#define	EIO				(5 * NEGATIVE)		/* Input/output error */
#define	ENXIO			(6 * NEGATIVE)		/* Device not configured */
#define	E2BIG			(7 * NEGATIVE)		/* Argument list too long */
#define	ENOEXEC			(8 * NEGATIVE)		/* Exec format error */
#define	EBADF			(9 * NEGATIVE)		/* Bad file descriptor */
#define	ECHILD			(10 * NEGATIVE)		/* No child processes */
#define	EDEADLK			(11 * NEGATIVE)		/* Resource deadlock avoided */
											/* 11 was EAGAIN */
#define	ENOMEM			(12 * NEGATIVE)		/* Cannot allocate memory */
#define	EACCES			(13 * NEGATIVE)		/* Permission denied */
#define	EFAULT			(14 * NEGATIVE)		/* Bad address */
/*#ifndef _POSIX_SOURCE*/
#define	ENOTBLK			(15 * NEGATIVE)		/* Block device required */
/*#endif*/
#define	EBUSY			(16 * NEGATIVE)		/* Device busy */
#define	EEXIST			(17 * NEGATIVE)		/* File exists */
#define	EXDEV			(18 * NEGATIVE)		/* Cross-device link */
#define	ENODEV			(19 * NEGATIVE)		/* Operation not supported by device */
#define	ENOTDIR			(20 * NEGATIVE)		/* Not a directory */
#define	EISDIR			(21 * NEGATIVE)		/* Is a directory */
#define	EINVAL			(22 * NEGATIVE)		/* Invalid argument */
#define	ENFILE			(23 * NEGATIVE)		/* Too many open files in system */
#define	EMFILE			(24 * NEGATIVE)		/* Too many open files */
#define	ENOTTY			(25 * NEGATIVE)		/* Inappropriate ioctl for device */
/*#ifndef _POSIX_SOURCE*/
#define	ETXTBSY			(26 * NEGATIVE)		/* Text file busy */
/*#endif*/
#define	EFBIG			(27 * NEGATIVE)		/* File too large */
#define	ENOSPC			(28 * NEGATIVE)		/* No space left on device */
#define	ESPIPE			(29 * NEGATIVE)		/* Illegal seek */
#define	EROFS			(30 * NEGATIVE)		/* Read-only file system */
#define	EMLINK			(31 * NEGATIVE)		/* Too many links */
#define	EPIPE			(32 * NEGATIVE)		/* Broken pipe */

/* math software */
#define	EDOM			(33 * NEGATIVE)		/* Numerical argument out of domain */
#define	ERANGE			(34 * NEGATIVE)		/* Result too large */

/* non-blocking and interrupt i/o */
#define	EAGAIN			(35 * NEGATIVE)		/* Resource temporarily unavailable */
/*#ifndef _POSIX_SOURCE*/
#define	EWOULDBLOCK	EAGAIN					/* Operation would block */
#define	EINPROGRESS		(36 * NEGATIVE)		/* Operation now in progress */
#define	EALREADY		(37 * NEGATIVE)		/* Operation already in progress */

/* ipc/network software -- argument errors */
#define	ENOTSOCK		(38 * NEGATIVE)		/* Socket operation on non-socket */
#define	EDESTADDRREQ	(39 * NEGATIVE)		/* Destination address required */
#define	EMSGSIZE		(40 * NEGATIVE)		/* Message too long */
#define	EPROTOTYPE		(41 * NEGATIVE)		/* Protocol wrong type for socket */
#define	ENOPROTOOPT		(42 * NEGATIVE)		/* Protocol not available */
#define	EPROTONOSUPPORT	(43 * NEGATIVE)		/* Protocol not supported */
#define	ESOCKTNOSUPPORT	(44 * NEGATIVE)		/* Socket type not supported */
#define	EOPNOTSUPP		(45 * NEGATIVE)		/* Operation not supported */
#define	EPFNOSUPPORT	(46 * NEGATIVE)		/* Protocol family not supported */
#define	EAFNOSUPPORT	(47 * NEGATIVE)		/* Address family not supported by protocol family */
#define	EADDRINUSE		(48 * NEGATIVE)		/* Address already in use */
#define	EADDRNOTAVAIL	(49 * NEGATIVE)		/* Can't assign requested address */
                          
/* ipc/network software -- operational errors */
#define	ENETDOWN		(50 * NEGATIVE)		/* Network is down */
#define	ENETUNREACH		(51 * NEGATIVE)		/* Network is unreachable */
#define	ENETRESET		(52 * NEGATIVE)		/* Network dropped connection on reset */
#define	ECONNABORTED	(53 * NEGATIVE)		/* Software caused connection abort */
#define	ECONNRESET		(54 * NEGATIVE)		/* Connection reset by peer */
#define	ENOBUFS			(55 * NEGATIVE)		/* No buffer space available */
#define	EISCONN			(56 * NEGATIVE)		/* Socket is already connected */
#define	ENOTCONN		(57 * NEGATIVE)		/* Socket is not connected */
#define	ESHUTDOWN		(58 * NEGATIVE)		/* Can't send after socket shutdown */
#define	ETOOMANYREFS	(59 * NEGATIVE)		/* Too many references: can't splice */
#define	ETIMEDOUT		(60 * NEGATIVE)		/* Operation timed out */
#define	ECONNREFUSED	(61 * NEGATIVE)		/* Connection refused */
                          
#define	ELOOP			(62 * NEGATIVE)		/* Too many levels of symbolic links */
/*#endif*/ /* _POSIX_SOURCE */
#define	ENAMETOOLONG	(63 * NEGATIVE)		/* File name too long */

/* should be rearranged */
/*#ifndef _POSIX_SOURCE*/
#define	EHOSTDOWN		(64 * NEGATIVE)		/* Host is down */
#define	EHOSTUNREACH	(65 * NEGATIVE)		/* No route to host */
/*#endif*/ /* _POSIX_SOURCE */
#define	ENOTEMPTY		(66 * NEGATIVE)		/* Directory not empty */

/* quotas & mush */
/*#ifndef _POSIX_SOURCE*/
#define	EPROCLIM		(67 * NEGATIVE)		/* Too many processes */
#define	EUSERS			(68 * NEGATIVE)		/* Too many users */
#define	EDQUOT			(69 * NEGATIVE)		/* Disc quota exceeded */

/* Network File System */
#define	ESTALE			(70 * NEGATIVE)		/* Stale NFS file handle */
#define	EREMOTE			(71 * NEGATIVE)		/* Too many levels of remote in path */
#define	EBADRPC			(72 * NEGATIVE)		/* RPC struct is bad */
#define	ERPCMISMATCH	(73 * NEGATIVE)		/* RPC version wrong */
#define	EPROGUNAVAIL	(74 * NEGATIVE)		/* RPC prog. not avail */
#define	EPROGMISMATCH	(75 * NEGATIVE)		/* Program version wrong */
#define	EPROCUNAVAIL	(76 * NEGATIVE)		/* Bad procedure for program */
/*#endif*/ /* _POSIX_SOURCE */

#define	ENOLCK			(77 * NEGATIVE)		/* No locks available */
#define	ENOSYS			(78 * NEGATIVE)		/* Function not implemented */

/*#ifndef _POSIX_SOURCE*/
#define	EFTYPE			(79 * NEGATIVE)		/* Inappropriate file type or format */
#define	EAUTH			(80 * NEGATIVE)		/* Authentication error */
#define	ENEEDAUTH		(81 * NEGATIVE)		/* Need authenticator */
#define	ELAST			(81 * NEGATIVE)		/* Must be equal largest errno */
/*#endif*/ /* _POSIX_SOURCE */

#define	EDBUSY			(82 * NEGATIVE)
#define	EDERRE			(83 * NEGATIVE)
#define	EDINVAL			(84 * NEGATIVE)
#define	EDNODEV			(85 * NEGATIVE)
#define	EDNOFUNC		(86 * NEGATIVE)
#define	EDNOMEM			(87 * NEGATIVE)
#define	ENOMEDIUM		(89 * NEGATIVE)
#define	ENOTSUP			(90 * NEGATIVE)
#define	EOVERFLOW		(91 * NEGATIVE)

#ifdef KERNEL
#define	ERESTART		(92 * NEGATIVE)		/* restart syscall */
#define	EJUSTRETURN		(93 * NEGATIVE)		/* don't modify regs, just return */
#define	ENOIOCTL		(94 * NEGATIVE)		/* ioctl not handled by this layer */
#define	ESYMBOLIC		(95 * NEGATIVE)		/* symbolic file */
#endif


#endif
