/*
 * sys/config.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef sys_config_h
#define sys_config_h


#include <sys/limits.h>


#ifdef KERNEL

#define START_ADDRESS		0x1000						/* setup.SΥɤ˥ɥ쥹 */
#define ROOT_DEVICE				"/dev/hdb5"				/* root file system device */
#define PAGING_BACKUP_DEVICE	"/dev/hdb6"				/* Paging back store device */

/* ƥ */
#define UTSNAME_SYSNAME   "UNDEFINE"
#define UTSNAME_NODENAME  "UNDEFINE"
#define UTSNAME_RELEASE   "UNDEFINE"
#define UTSNAME_VERSION   "UNDEFINE"

#define IP_ADDR(a,b,c,d) (a+(b<<8)+(c<<16)+(d<<24))
#define TIMEZOME_NAME "tokyo"

#endif	// KERNEL


#define IOMAP_BEG			0xe0000000					/* ꡼ޥåIO˥ɥ쥹κǽ */
#define KERNEL_END			0x40000000					/* ͥɥ쥹κǸ */
#define KERNEL_DATA_BEG		0x100000					/* ͥǡɥ쥹κǽ */
#define KERNEL_DATA_END		(KERNEL_END - 0x400000)		/* ͥǡɥ쥹κǸ */
#define KERNEL_STACK_BEG	KERNEL_DATA_END				/* ͥ륹åɥ쥹κǽ */
#define KERNEL_ESP_BEG		KERNEL_END					/* ͥ륹åݥ󥿤κǽ */
#define USER_BEG			KERNEL_END					/* 桼ɥ쥹κǽ */
#define USER_END			IOMAP_BEG					/* 桼ɥ쥹κǸ */
#define USER_ESP_BEG		USER_END					/* 桼åݥ󥿤κǽ顢user/include/system.h˱ƶ롣 */

#define MAX_CPU 8							/* бcpu */


#ifndef ASM_FILE


#ifdef KERNEL

enum{
	TASK_TIME = 10,					// 1Ư(ms)
	MAX_DEVICE_OPEN = 20,			// ǥХץǽ
	MAX_REGIST_FS = 16,				// ե륷ƥϿ
	TTY = 1,						// ͥå 1=console,2=com1,3=com2
	LOCAL_TIME_TOKYO = 32400,		// Ĵ 9

	/* Network. */
	IP_ADDRESS0=       IP_ADDR(172,25,0,3),		/* eth0 IPɥ쥹 */
	IP_SUBNETMASK0=    IP_ADDR(255,255,0,0),	/* eth0 IP֥ͥåȥޥ */
	IP_ADDRESS1=       IP_ADDR(172,25,0,4),		/* eth1 IPɥ쥹 */
	IP_SUBNETMASK1=    IP_ADDR(255,255,0,0),	/* eth1 IP֥ͥåȥޥ */
	IP_DEFAULT_GATEWAY=IP_ADDR(172,25,0,224),	/* ǥեȥȥ */
};

#endif	// KERNEL


/* exec()Ϳ륷ƥ */
typedef struct{
	unsigned int lastAddr;
}SYS_INFO;


#ifndef KERNEL

extern SYS_INFO *sys_info;

#endif	// !KERNEL


#endif	// ASM_FILE


#endif
