/*
 * setup2.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ᥤץ
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/module.h>
#include <sys/mbuf.h>
#include <machine/except_i386.h>
#include <machine/pcibus.h>
#include <machine/bios.h>
#include <machine/apm/apm.h>
#include <isa/isavar.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <kern/ata.h>
#include <kern/lib.h>
#include <kern/sp.h>
#include <kern/mp.h>
#include <kern/mm.h>
#include <kern/interrupt.h>
#include <kern/fs.h>
#include <kern/proc.h>
#include <kern/device.h>
#include <kern/serial.h>
#include <kern/time.h>
#include <kern/ext2.h>
#include <kern/miscdev.h>
#include <kern/errno.h>
#include <kern/lock.h>
#include <kern/term.h>
#include <kern/test.h>
#include <dev/console/console.h>
#include <dev/console/keyboard.h>
#include <dev/MC146818.h>
#include <dev/8254.h>


/*************************************************************************************************
 *
 * ͥν
 *
 *************************************************************************************************/


enum{
	CPU_FAMILY_OTHER=0,			/* ¾cpuեߥ꡼ */
	CPU_FAMILY_386=3,			/* 386ߴ */
	CPU_FAMILY_486=4,			/* 486ߴ */
	CPU_FAMILY_PENTIUM=5,		/* pentiumߴ */
	CPU_FAMILY_PENTIUMPRO=6,	/* pentiumproߴ */
	CPU_FAMILY_PENTIUM4=0xf		/* pentium4ߴ */
};


// ɥ쥹饤20ӥåܤBIOS̵ˤƤΤͭˤ롣
// return : error number
static int enable_a20()
{
	volatile int *test1, *test2;
	int i;

	/* Enable A20. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_COMMAND_REG, 0xad);		/* Disable keyboard. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_COMMAND_REG, 0xd1);		/* Write to output. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_OUTPUT_REG, 0xdf);		/* A20 enable. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_COMMAND_REG, 0xae);		/* Enable keyboard. */
	while (inb(KEYBOARD_STAT_REG) & 2);

	/* A20ͭˤʤäå */
	test1 = (int*)0x00007c;
	test2 = (int*)0x10007c;
	for (i = 1; i <= 2; ++i){
		*test1 = i;
		if (*test2 != i){
			return NOERR;
		}
	}

	return ERR;
}


/*
 * int cpuid()
 * return : С
 */
int cpuid();
asm(
"cpuid:"
	"movl	$1,%eax\n"
	"cpuid\n"
	"ret"
);


/*
 * 󥰤򳫻Ϥ롣
 * espĴƥɥ롣
 */
void start_tasking()
{
	asm volatile(
		"movl	%0,%%esp\n"
		"sti\n"
		"jmp	idle"
		::"i"(KERNEL_ESP_BEG)
	);
}


void main()
{
	/* 㳰ϥɥꤹ롣 */
	init_except();

	// 󥽡ν
	initConsole();

	/* TSSǥץɤ롣 */
	set_tss(TSS_DES);

	/* Init cputask struct. */
	init_cputask(0);

	// cpuϥڥƥߴʾɬ
	if (((cpuid() >> 8) & 0xf) < CPU_FAMILY_PENTIUM){
		PRINT_ERR("This cpu is not supported!");
	}

	// ɥ쥹饤20ӥåܤͭˤ롣
	if (enable_a20() == ERR){
		PRINT_ERR("A20 can't be enable. Boot stop!");
	}

	/* APMν */
	InitApm();

	/* fpuν */
	asm("fninit");

	/* ꡼ƥν */
	initMm();

	// ޡν
	initTimer();

	/* cpuåͤ¬ꡣ */
	printk("cpu0 clock = %d HZ\n", getCpuClock());

	// ʥν
	initSignal();

	/* ɥץ롣 */
	if (set_idle_proc(0) < 0){
		PRINT_ERR("set_idle_proc error!");
	}

	/* ߤSMP롣 */
	if (MFPS_addres){
		if (init_mp() != NOERR){
			PRINT_ERR("init_mp() Failed!");
		}
	}
	else{
		if (init_sp() != NOERR){
			PRINT_ERR("init_sp() Failed!");
		}
	}

	// 󥰥ץåѥޡν
	if (MFPS_addres == 0){
		if (setTasking(TASK_TIME) != NOERR){
			PRINT_ERR("setTasking() Failed!");
		}
	}

	// 󥿡Х륿ޡν
	initIntervalTimer();

	// ꥢ륯åޡν
	initRealTimer();
	
	/* Init system call. */
	init_syscall();
}


/* ǽΥ桼ץ¹ */
extern int startExec(const char*,void*,void*);


void init()
{
	int rest;

	/* ߳ϡ */
	sti();

	/* ǽΥץ process0 롣 */
	rest = sys_fork();
	if (rest < 0){
		PRINT_ERR("Process0 fork() error!");
	}
	else if (0 < rest){
		/* ɥץ򥹥꡼פ롣 */
		start_tasking();
	}

	// BIOSطν
	bios32_init();

	// mbufν
	initMbuf();

	/* Init file system. */
	init_fs();

	/* ǥХե륷ƥν */
	initDeviceFs();

	// ISAХν
	if (initIsa() != NOERR){
		printk("Failed initialize isa!\n");
	}

	// PCIХν
	// ȤꤢĤPCIɥ饤С롢FreeBSDΥɥ饤С줹
	initPci();
	if (initPciNew() != NOERR){
		printk("Failed initialize pci!\n");
	}

	/* init serial. */
	init_com();

	/* ֥ååν */
	initBlockCache();

	/* ǥХե륷ƥΥޥ */
	if (mountDeviceFs() < 0){
		PRINT_ERR("mountDeviceFs() error!");
	}

	/* Set COM interrupt. */
	set_com_intr();

	// եåԡɥ饤СȤ߹
	{
		extern int fdc_isaInitDevice();
		extern int fd_fdcInitDevice();
		
		rest = fdc_isaInitDevice();
		if (rest < 0){
			printk("Failed initialize fdc driver!\n");
		}
		else{
			rest = fd_fdcInitDevice();
		}
		if (rest < 0){
			printk("Failed initialize fd driver!\n");
		}
	}

	/* Init ATA drive. */
	initAta();

	/* 󥽡ΥǥХϿ */
	if((rest=registConsole())<0){
		PRINT_ERR("registConsole error!");
	}

	/* NULLǥХϿ */
	if((rest=registNullDev())<0){
		PRINT_ERR("registNullDev error!");
	}

	/* EXT2ե륷ƥν */
	if((rest=initExt2tFs())<0){
		PRINT_ERR("initExt2tFs error!");
	}

	/* ڡѵΰν */
	if ((rest = initBackupDev(PAGING_BACKUP_DEVICE)) < 0){
		PRINT_ERR("initBackupDev error!");
	}
	printk("Page backup device : %s\n",PAGING_BACKUP_DEVICE);

	/* mount root filesystem. */
	if((rest = mountRoot(ROOT_DEVICE,"ext2")) < 0){
		PRINT_ERR("mountRoot error!");
	}
	printk("Root device : %s\nRoot file system : ext2\n",ROOT_DEVICE);

	/* Init keyboard driver. */
	initKeyboard();

	/* ͥåȥν  */
	initNet();

	/* ͥåȥɥ饤Сν */
	rest = initEther();
	if(rest != NOERR){
		PRINT_ERR("initEther error!");
	}

//************************************************************************************
	// ץɥ饤СȤ߹
	{
		extern int echoInitDevice(struct module *, int);
		rest = echoInitDevice(NULL, MOD_LOAD);
		if (rest < 0){
			printk("Failed initialize echo driver!\n");
		}
	}
//************************************************************************************
	
	if ((rest = initProc1()) < 0){
		PRINT_ERR("initProc0 error!");
	}

	/* ǽΥ桼ץư롣 */
	rest = sys_fork();
   	if (rest < 0){
   		PRINT_ERR("Fork of first user process error!");
   	}
   	else if (rest == 0)
   	{
   		/* 桼ץ¹Ԥ롣 */
// 		rest = startExec("/shell",NULL,NULL);
   		rest = startExec("/sbin/init",NULL,NULL);
		if (rest < 0){
			PRINT_ERR("startExec error!");
		}
	}

	/* ҥץexitԤ */
	waitProc1();
}


/****************************************************************************************************/
void test_setup()
{
	printk("ok\n");
}
