/*
 * netlib.c
 *
 * Copyright 2005, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/config.h>
#include<sys/types.h>
#include<sys/param.h>
#include<sys/limits.h>
#include<sys/errno.h>
#include<net/net.h>
#include<net/netlib.h>
#include<kern/mm.h>
#include<kern/lock.h>
#include<kern/time.h>
#include<kern/lib.h>
#include<kern/debug.h>


//#define DEBUG_NETLIB 1
#ifdef DEBUG_NETLIB
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE	inline
#endif


/***********************************************************************************
 *
 * å
 *
 ***********************************************************************************/


/*
 * åη׻
 * parameters : data1 address,data2 address,byte size1,byte size2
 * return : פ
 */
ushort calcSum(uint *data,int size)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	}sum;
	uint tmp;


	sum.u64=0;
	for(;size>=sizeof(uint);size-=sizeof(uint))
		sum.u64+=*data++;
	if(size>0)sum.u64+=*data&((1<<(size*8))-1);

	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u64+=tmp;
	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u32[0]+=tmp;

	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u32[0]+=tmp;
	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u16[0]+=tmp;

	return ~sum.u16[0];
}

/*
 * Note!
 *  size1uintǳڤˤƤ롣
 */
ushort calcSumM(uint *data1,uint *data2,int size1,int size2)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	}sum;
	uint tmp;


	sum.u64=0;
	for(;size1>=sizeof(uint);size1-=sizeof(uint))
		sum.u64+=*data1++;
	for(;size2>=sizeof(uint);size2-=sizeof(uint))
		sum.u64+=*data2++;
	if(size2>0)sum.u64+=*data2&((1<<(size2*8))-1);

	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u64+=tmp;
	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u32[0]+=tmp;

	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u32[0]+=tmp;
	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u16[0]+=tmp;

	return ~sum.u16[0];
}


/***********************************************************************************
 *
 * 󥰥Хåե
 * 	Хåեǽ۴Ĥɤ߽񤭤롣
 *
 ***********************************************************************************/


enum{
	RING_BUF_SIZE_MAX = 0x10000,	// Хåե祵
};

// 󥰥Хåե
typedef struct{
	size_t size;		// Хåե
	size_t start;		// ХåեǡϤ
	size_t last;		// ߤΥХåեǡǸ
	char *buf;			// Хåե
}RING_BUF;


//================================== PUBLIC =============================================


// 󥰥ХåեγȽ
// return : 0 or error number
int allocRingBuf(const size_t size, const size_t start, void **o_ringBuf)
{
	RING_BUF *ringBuf;
	
	// Хåեκ祵RING_BUF_SIZE_MAX
	ASSERT(size <= RING_BUF_SIZE_MAX);

	ringBuf = kmalloc(sizeof(*ringBuf));
	if (ringBuf == NULL){
		return -ENOMEM;
	}
	
	ringBuf->buf = kmalloc(size);
	if (ringBuf->buf == NULL){
		return -ENOMEM;
	}
	
	ringBuf->size = size;
	ringBuf->start = ringBuf->last = start;
	
	*o_ringBuf = ringBuf;
	
	return 0;
}


// 󥰥Хåեγ
void freeRingBuf(void *i_ringBuf)
{
	RING_BUF *ringBuf = i_ringBuf;
	
	kfree(ringBuf->buf);
	kfree(ringBuf);
}


// 󥰥Хåե"start"ͤ
size_t getStartRingBuf(void *i_ringBuf)
{
	RING_BUF *ringBuf = i_ringBuf;

	return ringBuf->start;
}


// 󥰥Хåե"last"ͤ
size_t getLastRingBuf(void *i_ringBuf)
{
	RING_BUF *ringBuf = i_ringBuf;

	return ringBuf->last;
}


// 󥰥Хåե"start"ͤ
void setStartRingBuf(void *i_ringBuf, size_t start)
{
	RING_BUF *ringBuf = i_ringBuf;

	if ((ringBuf->start < start) && (start <= ringBuf->last)){
		ringBuf->start = start;
	}
}


// 󥰥ХåեΥХåե
// return : Хåե
int getSizeRingBuf(void *i_ringBuf)
{
	RING_BUF *ringBuf = i_ringBuf;

	return ringBuf->size;
}


// 󥰥ХåեλĤХåե
// return : ĤΥХåե
int getAvailableSizeRingBuf(void *i_ringBuf)
{
	RING_BUF *ringBuf = i_ringBuf;

	return ringBuf->size - (ringBuf->last - ringBuf->start);
}


// 󥰥Хåեǡɤ߽Ф
void readRingBuf(void *i_ringBuf, const size_t i_start, const size_t len, void *o_readBuf)
{
	RING_BUF *ringBuf = i_ringBuf;
	int start = i_start % ringBuf->size;
	char *readBuf = o_readBuf;
	
	ASSERT((ringBuf->start <= i_start) && (i_start < ringBuf->last));
	ASSERT(i_start + len <= ringBuf->last);
	
	if (ringBuf->size < start + len){
		int firstSize = ringBuf->size - start;
		memcpy(readBuf, ringBuf->buf + start, firstSize);
		memcpy(readBuf + firstSize, ringBuf->buf, len - firstSize);
	}
	else{
		memcpy(readBuf, ringBuf->buf + start, len);
	}
}


// 񤭹ߤ"last"ͤ񤭹
void writeRingBuf(void *i_ringBuf, const size_t len, void *i_writeBuf)
{
	RING_BUF *ringBuf = i_ringBuf;
	int start = ringBuf->last % ringBuf->size;
	char *writeBuf = i_writeBuf;
	
	ASSERT(ringBuf->last + len <= ringBuf->start + ringBuf->size);
	
	if (ringBuf->size < start + len){
		int firstSize = ringBuf->size - start;
		memcpy(ringBuf->buf + start, writeBuf, firstSize);
		memcpy(ringBuf->buf, writeBuf + firstSize, len - firstSize);
	}
	else{
		memcpy(ringBuf->buf + start, writeBuf, len);
	}
	ringBuf->last += len;
}


/************************************************************************************
 *
 * åȥץ
 *
 ************************************************************************************/


//================================== PRIVATE ============================================


/*
 * åȥ٥륪ץ
 * return : 0 or error number
 */
static int setSockOpt(SOCKET *sock, int optName, const int *optVal, int optLen)
{
	switch (optName){
		case SO_TIMESTAMP:
			// 
		case SO_REUSEADDR:
			if (optLen < sizeof(int)){
				return -EINVAL;
			}
			switch (*optVal){
				case 1:
					sock->sockOpt.name |= optName;
					break;
				case 0:
					sock->sockOpt.name &= ~optName;
					break;
				default:
					return -EINVAL;
			}
			break;
		default:
			return -ENOPROTOOPT;
	}

	return 0;
}


/*
 * IP٥륪ץ
 * return : 0 or error number
 */
static int setIpOpt(SOCKET *sock, int optName, const int *optVal, int optLen)
{
	switch (optName){
		case IP_TOS:
			if (optLen < sizeof(int)){
				return -EINVAL;
			}
			sock->ipOpt.name = optName;
			sock->ipOpt.value = *optVal;
			break;
		default:
			return -ENOPROTOOPT;
	}

	return 0;
}


//================================== PUBLIC =============================================


/*
 * åȥץμ
 */
int getOpt(SOCKET *sock, int level, int optName, int *optVal, int *optLen)
{
/****************************************************************************************************************/
printk("%s getOpt() : getsockopt() is not suport!",__FILE__);
/****************************************************************************************************************/

	return -ENOPROTOOPT;
}


/*
 * åȥץ
 */
int setOpt(SOCKET *sock, int level, int optName, const int *optVal, int optLen)
{
	switch (level){
		case SOL_SOCKET:
			return setSockOpt(sock, optName, optVal, optLen);
		case IPPROTO_IP:
			return setIpOpt(sock, optName, optVal, optLen);
		default:
			return -ENOPROTOOPT;
	}
	
	return 0;
}


/*
 * åȥץμ¹
 * return : 0
 */
void doSockOpt(SOCKET *sock, caddr_t cmsghdr, u_int cmsgLen)
{
	struct timeval timeval;
	struct cmsghdr *cmsg = (struct cmsghdr*)cmsghdr;
	
	if (sock->sockOpt.name & SO_TIMESTAMP){
		/* åĹγǧ */
		if (cmsgLen < sizeof(struct cmsghdr) + sizeof(struct timeval)){
			cmsg->cmsg_len = 0;
			return;
		}

		/* μ */
		gettimeofday(&timeval);
		cmsg->cmsg_level = SOL_SOCKET;
		cmsg->cmsg_type = SCM_TIMESTAMP;
		cmsg->cmsg_len = sizeof(struct cmsghdr) + sizeof(struct timeval);
		memcpy(CMSG_DATA(cmsg), &timeval, sizeof(struct timeval));
	}
}
