/*
 * Copyright (c) 1982, 1986, 1988, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)uipc_mbuf.c	8.2 (Berkeley) 1/4/94
 * $FreeBSD: src/sys/kern/uipc_mbuf.c,v 1.51.2.37 2004/06/17 00:08:22 fjoe Exp $
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/mbuf.h>
#include <machine/param.h>
#include <net/if_var.h>
#include <net/ethernet.h>
#include <net/tcp.h>
#include <kern/mm.h>
#include <kern/buf.h>
#include <kern/lib.h>
#include <dev/console/console.h>
#include <kern/test.h>


//#define DEBUG_MBUF 1
#ifdef DEBUG_MBUF
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================


enum{
	TRANS_MBUF_MAX	= 0x40000,		// Mobt@TCY
	RECV_MBUF_MAX	= 0x40000,		// Mobt@TCY
};

static ALLOC_BUF AllocBufTrans;
static ALLOC_BUF AllocBufRecv;


// mbuf蓖Ă
// return : struct mbuf or NULLiG[j
struct mbuf *m_alloc(const uint size, ALLOC_BUF *AllocBuf)
{
	struct mbuf *mbuf;

/****************************************************************************************************************
if (AllocBuf == &AllocBufTrans){
	printDebug(80 * 3 + 60, "TransBuf  0x%x  ", AllocBufTrans.sizeTotal);
}
else{
	printDebug(80 * 4 + 60, "RecvBuf   0x%x  ", AllocBufRecv.sizeTotal);
}
****************************************************************************************************************/
	if (allocBuf(size + sizeof(*mbuf), AllocBuf, (void**)&mbuf) != NOERR){
		return NULL;
	}
	memset(mbuf, 0, sizeof(*mbuf));
	mbuf->mh_len = size;
	mbuf->mh_data = (caddr_t)mbuf + sizeof(*mbuf);
	mbuf->allocBuf = AllocBuf;

	return mbuf;
}


STATIC INLINE int getRecvSize()
{
	return getRestSizeBuf(&AllocBufRecv) - sizeof(struct mbuf);
}


// M҂obt@Nؒf
STATIC INLINE void detacheRecv(
	struct mbuf *mbuf,		// N폜struct mbuf
	void **m_recvBuf)		// Mobt@wb_
{
	if (*m_recvBuf == mbuf){
		struct mbuf *nextMbuf = getNextList(OFFSETOF(struct mbuf, list), &mbuf->list);

		if (nextMbuf == mbuf){
			*m_recvBuf = NULL;
		}
		else{
			*m_recvBuf = nextMbuf;
		}
	}
	removeList(&mbuf->list);
}


//================================== PUBLIC =============================================


// Mobt@蓖Ă
struct mbuf *mallocTrans(const uint size)
{
	return m_alloc(size, &AllocBufTrans);
}


// Mobt@蓖Ă
struct mbuf *mallocRecv(const uint size)
{
	return m_alloc(size, &AllocBufRecv);
}


//st
// Mobt@蓖Ă
// return : mbuf or NULL
struct mbuf *m_devget(
	char *fromBuf,			// Rs[
	int size, 				// Rs[TCY
	int off,
	struct ifnet *ifp,
	void (*copy)(char *from, caddr_t to, u_int len))
{
	struct mbuf *mbuf;

	mbuf = m_alloc(size, &AllocBufRecv);
	if (mbuf == NULL){
		return NULL;
	}
	memcpy(mbuf->mh_data + off, fromBuf, size);

	return mbuf;
}


// MCLBYTES̃obt@蓖Ă
// return : struct mbuf or NULL
struct mbuf *m_getcl(int how, short type, int flags)
{
	return m_alloc(MCLBYTES, &AllocBufRecv);
}


// ڑSobt@J
void m_freem(struct mbuf *i_mbuf)
{
	struct mbuf *mbuf;

	for (mbuf = i_mbuf; mbuf != NULL;){
		struct mbuf *next = mbuf->mh_next;
		ASSERT(mbuf->allocBuf != NULL);
		freeBuf(mbuf, mbuf->allocBuf);
		mbuf = next;
	}
}


// obt@|C^̈ړ
void m_adj(
	struct mbuf *mbuf,		// Ώۃobt@
	int off)				// |C^ړItZbg
{
	ASSERT(0 <= mbuf->mh_off + off);

	mbuf->mh_off += off;
}


/*
 * Copy data from a buffer back into the indicated mbuf chain,
 * starting "off" bytes from the beginning, extending the mbuf
 * chain if necessary.
 */
void m_copyback(
	struct	mbuf *mbuf,		// Rs[
	int off,				// Rs[ItZbg
	int len,				// Rs[TCY
	caddr_t cp)				// Rs[
{
	ASSERT(off + len <= mbuf->mh_len);
	memcpy(mbuf->mh_data + mbuf->mh_off + off, cp, len);
}


// mbuff[^|C^擾
void *getMbufDataPointer(struct mbuf *mbuf)
{
	return mbuf->mh_data + mbuf->mh_off;
}


// obt@ėp
void m_recycle(
	struct mbuf *mbuf)		// Ώۃobt@
{
	ASSERT(mbuf != NULL);

	mbuf->mh_off = 0;
}


// M҂obt@̐擪QƂ
// return : struct mbuf ro NULL
struct mbuf *refRecvBuf(
	void *recvBuf)			// Mobt@wb_
{
	return recvBuf;
}


// M҂obt@̍ŌQƂ
// return : struct mbuf ro NULL
struct mbuf *refRecvEndBuf(
	void *recvBuf)			// Mobt@wb_
{
	struct mbuf *mbuf = recvBuf;

	if (mbuf == NULL){
		return NULL;
	}
	return getPrevList(OFFSETOF(struct mbuf, list), &mbuf->list);
}


// M҂obt@IPʔԍŐڑ
//sӁtM荞ݎ݂̂Ɏgp邱
void attachRecvBuf(struct mbuf *m_mbuf, void **m_recvBuf, int *m_lock)
{
	IP_HEADER *i_ip = getMbufDataPointer(m_mbuf);
	int eflag;

	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		if (*m_recvBuf == NULL){
			initCirculList(&m_mbuf->list);
			*m_recvBuf = m_mbuf;
		}
		else{
			struct mbuf *mbuf;
	
			for (mbuf = getPrevList(OFFSETOF(struct mbuf, list), &((struct mbuf*) *m_recvBuf)->list);; 
				mbuf = getPrevList(OFFSETOF(struct mbuf, list), &mbuf->list)){
				IP_HEADER *ip = getMbufDataPointer(mbuf);

				if (swapWord(ip->id) < swapWord(i_ip->id)){
					addNextList(&mbuf->list, &m_mbuf->list);
					break;
				}
				if (mbuf == *m_recvBuf){
					addPrevList(&mbuf->list, &m_mbuf->list);
					*m_recvBuf = m_mbuf;
					break;
				}
			}
		}
	}
	exit_spinlock(m_lock);
	exitCli(eflag);
}


//sӁtM荞ݎ݂̂Ɏgp邱
// M҂obt@TCP̃V[PXԍɐڑ
// parameters : \Pbg,Mobt@
void attachRecvBufTcp(struct mbuf *m_mbuf, void **m_recvBuf, int *m_lock)
{
	IP_HEADER *i_ip = getMbufDataPointer(m_mbuf);
	TCP_HEADER *i_tcp = (TCP_HEADER*)&i_ip->data;
	int eflag;

	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		if (*m_recvBuf == NULL){
			initCirculList(&m_mbuf->list);
			*m_recvBuf = m_mbuf;
		}
		else{
			struct mbuf *mbuf = *m_recvBuf;
			for (mbuf = getPrevList(OFFSETOF(struct mbuf, list), &mbuf->list);; 
				mbuf = getPrevList(OFFSETOF(struct mbuf, list), &mbuf->list)){
				IP_HEADER *ip = getMbufDataPointer(mbuf);
				TCP_HEADER *tcp = (TCP_HEADER*)&ip->data;

				if ((swapInt32(tcp->seqnum) < swapInt32(i_tcp->seqnum)                                          ) || 
					(swapInt32(tcp->seqnum) == swapInt32(i_tcp->seqnum) && swapWord(ip->id) < swapWord(i_ip->id))    ){
					addNextList(&mbuf->list, &m_mbuf->list);
					break;
				}
				if (mbuf == *m_recvBuf){
					addPrevList(&mbuf->list, &m_mbuf->list);
					*m_recvBuf = m_mbuf;
					break;
				}
			}
		}
		
		// obt@؂炳Ȃ悤ɊmFĕKvȂJ
		if (getRecvSize() < MCLBYTES){
			struct mbuf *end = refRecvEndBuf(*m_recvBuf);
			if (end != NULL){
				detacheRecv(end, m_recvBuf);
				m_freem(end);
			}
		}
	}
	exit_spinlock(m_lock);
	exitCli(eflag);
}


// M҂obt@N폜
void detachRecvBuf(
	struct mbuf *mbuf,		// N폜struct mbuf
	void **m_recvBuf,		// Mobt@wb_
	int *m_lock)			// rbNQ[g
{
	int eflag;

	ASSERT(mbuf != NULL);

	// 鏈"attachRecvBuf()"荞ݎɎgp̂Ŋ荞݋֎~B
	eflag = enterCli();
	enter_spinlock(m_lock);
	{
		detacheRecv(mbuf, m_recvBuf);
	}
	exit_spinlock(m_lock);
	exitCli(eflag);
}


// M҂obt@Xg؂藣Ďo
// return : struct mbuf or NULL
struct mbuf *getDetachRecvBuf(void **m_recvBuf, int *m_lock)
{
	struct mbuf *mbuf = refRecvBuf(*m_recvBuf);

	if (mbuf != NULL){
		detachRecvBuf(mbuf, m_recvBuf, m_lock);
	}

	return mbuf;
}


// obt@SXg̊J
void releaseRecvBuf(struct mbuf *i_mbuf)
{
	struct mbuf *mbuf;

	if (i_mbuf == NULL){
		return;
	}
	mbuf = i_mbuf;
	do{
		struct mbuf *next = getNextList(OFFSETOF(struct mbuf, list), &mbuf->list);
		m_freem(mbuf);
		mbuf = next;
	}while (mbuf != i_mbuf);
}


// \M҂obt@͖
// return : YES or NO
int isNoRecvBuf()
{
	return (getRecvSize() <= 0)? YES : NO;
}


void initMbuf()
{
	initAllocBuf(RECV_MBUF_MAX, &AllocBufRecv);
	initAllocBuf(TRANS_MBUF_MAX, &AllocBufTrans);
}
