/*
 * time.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * time.cѥإåե
 */


#ifndef time_h
#define time_h


#include <kern/list.h>
#include <sys/time.h>


#ifndef ASM_FILE


enum{
	SYS_TIMER_MAX = 5,	// ץȤΥƥॿޡ
	ITIMER_MAX = 2,		/* itimer */

	/* itimerʬ */
	ITIME_SYS = 0,		/* itimer󥷥ƥ */
	ITIME_PRC = 1,		/* itimer桼 */
};

typedef struct ITIMER{
	OBJ_LIST	list;
	int64		init;		/* ޡ͡rdtsc͡ */
	int64		cur;		/* Ĥ֡rdtsc͡ */
	void		*proc;		// ץ
}ITIMER;


extern int timer_num;

extern int setTasking(const uint);
extern int setDevWakeTimer(const uint, void**);
extern void delWakeTimer(void*);
extern void execIntervalTimer(const uint, uint *);
extern void execRealTimer(const uint);
extern uint getNextIntervalTime(void);
extern void initTimer();
extern void initProcTimer(void*);
extern uint getCpuClock(void);
extern void releaseProcTimer();
extern void calcUserTime();
extern void calcSysTime();
extern void doRealItimer();
extern void doSystemItimer(int64, ITIMER *);
extern void doUserItimer(int64, ITIMER *);
extern uint getUnixTime(void);
extern void setUnixTime(uint);
extern void gettimeofday(struct timeval*);
extern void micro_timer(uint);
extern void mili_timer(uint);
extern uint getTimeFromClock(uint64);
extern uint calcTimeFromClock(uint64);
extern int sys_time();
extern int sys_sleep();
extern void sys_wake(void*);
extern int sys_alarm();
extern int sys_settime(uint);
extern int sys_gettimeofday();
extern int sys_getitimer(int which, struct itimerval *value);
extern int sys_setitimer(int which, struct itimerval *value, struct itimerval *ovalue);
extern void initIntervalTimer();


#endif


#endif
