/*
 * system2.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 + ƥ
 */


#include <sys/utsname.h>
#include <sys/param.h>
#include <machine/apm/apm.h>
#include "proc.h"
#include "device.h"
#include "fs.h"
#include "signal.h"
#include "interrupt.h"
#include "errno.h"
#include "mm.h"
#include "system.h"


/*************************************************************************************
 *
 * reboot
 *
 *************************************************************************************/


//================================== PROTECTED ==========================================


static void shutdownAll()
{
/*******************************************/
printk("1 ");
/*******************************************/
	/* ץtermʥ롣 */
	sendSignalAllProc(SIGTERM);

	/* 󥹥塼Ԥ */
	wait_task();
	wait_task();
	wait_task();
	wait_task();
/*******************************************/
printk("2 ");
/*******************************************/
	/* ץkill롣 */
	sendSignalAllProc(SIGKILL);

	/* 󥹥塼Ԥ */
	wait_task();
	wait_task();
/*******************************************/
printk("3 ");
/*******************************************/
	/* ե륷ƥ򥢥ޥȤ롣 */
	sys_umount_root();
/*******************************************/
printk("4 ");
/*******************************************/
	sys_sync();
/*******************************************/
printk("end");
/*******************************************/
}


/*************************************************************************************************
 *
 * ƥॳ
 *
 *************************************************************************************************/


int sys_reboot(int flag)
{
	/* uidǧ롣 */
	if (get_current_task()->uid != 0)
		return -EACCES;

	switch(flag)
	{
		case REBOOT_REBOOT:
			shutdownAll();
			/* Ƶư */
			reboot();
			break;
		case REBOOT_POWEROFF:
			shutdownAll();
			setPowerOff();
			break;
		default:
			return -EINVAL;
	}

	return 0;
}


static struct SYSUTS{
	char *sysname;
	char *nodename;
	char *release;
	char *version;
}sysuts = {
	UTSNAME_SYSNAME,
	UTSNAME_NODENAME,
	UTSNAME_RELEASE,
	UTSNAME_VERSION
};

int sys_uname(struct utsname *buf)
{
	if (checkMem(buf, sizeof(struct utsname)) == ERR){
		return -EFAULT;
	}

	memcpy(buf->sysname, sysuts.sysname, strlen(sysuts.sysname) + 1);
	memcpy(buf->nodename, sysuts.nodename, strlen(sysuts.nodename) + 1);
	memcpy(buf->release, sysuts.release, strlen(sysuts.release) + 1);
	memcpy(buf->version, sysuts.version, strlen(sysuts.version) + 1);
	memcpy(buf->machine, "UNDEFINE", strlen("UNDEFINE") + 1);

	return 0;
}

