/*
 * sp.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 󥰥ץåƥν
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/lib.h>
#include <kern/interrupt.h>
#include <kern/time.h>
#include <kern/time.h>
#include <kern/sp.h>
#include <dev/console/console.h>


//#define DEBUG_SP 1

#ifdef DEBUG_SP
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE inline
#endif


//================================== PRIVATE ============================================


enum{
	BEGIN_VECT = 0x20		// ߥ٥γֹ
};


// ϡɳEOIؿ
STATIC void sp_eoi(uchar irq)
{
	if (irq < 8){
//		outb(OCW2M, irq | 0x20);
		outb(OCW2M, 0x20);
	}
	else{
//		outb(OCW3S, 0xa);	/* Read ISR */
//		if (inb(0xa0)){
//			outb(OCW2S, (irq - 8) | 0x20);
//		}
//		else{
//			outb(OCW2S, (irq - 8) | 0x20);
//			outb(OCW2M, 2 | 0x20);
			outb(OCW2S, 0x20);
			outb(OCW2M, 0x20);
//		}
	}
}


// Set interrupt mask
STATIC void set_pic_mask(
	const uchar irq)	// IRQ number
{
	if (irq < 8){
		outb(OCW1M, inb(OCW1M) | (1 << irq));
	}
	else{
		outb(OCW1S, inb(OCW1S) | (1 << (irq - 8)));
	}
}


// Release interrupt mask
STATIC void release_pic_mask(
	const uchar irq)	// IRQ number
{
	if(irq<8){
		outb(OCW1M, inb(OCW1M) & ~(1 << irq));
	}
	else{
		outb(OCW1S, inb(OCW1S) & ~(1 << (irq - 8)));
	}
}


/*
 * PIC
 */
STATIC void init_pic()
{
	/* picν */
	outb(ICW1M, 0x11);				/* cascade mode */
	outb(ICW1S, 0x11);				/* ICW1 slave */
	outb(ICW2M, BEGIN_VECT);		/* begin master interrupt from 0x20 */
	outb(ICW2S, BEGIN_VECT + 8);	/* begin slave interrupt from 0x28 */
	outb(ICW3M, 0x04);				/* IR2(2bit) slave connect */
	outb(ICW3S, 0x02);				/* slave connect IR-number */
	outb(ICW4M, 0x01);				/* 80x86 mode,Normal EOI */
	outb(ICW4S, 0x01);				/* 80x86 mode,Normal EOI */
	outb(OCW1M, 0xfb);				/* Mask of all IRQ except IRQ2 */
	outb(OCW1S, 0xff);				/* Mask of all IRQ */

	/* idtꤹ */
	set_idt(BEGIN_VECT,		irq0,	IDT_TRAP);
	set_idt(BEGIN_VECT+1,	irq1,	IDT_TRAP);
	set_idt(BEGIN_VECT+3,	irq3,	IDT_TRAP);
	set_idt(BEGIN_VECT+4,	irq4,	IDT_TRAP);
	set_idt(BEGIN_VECT+5,	irq5,	IDT_TRAP);
	set_idt(BEGIN_VECT+6,	irq6,	IDT_TRAP);
	set_idt(BEGIN_VECT+7,	irq7,	IDT_TRAP);
	set_idt(BEGIN_VECT+8,	irq8,	IDT_TRAP);
	set_idt(BEGIN_VECT+9,	irq9,	IDT_TRAP);
	set_idt(BEGIN_VECT+10,	irq10,	IDT_TRAP);
	set_idt(BEGIN_VECT+11,	irq11,	IDT_TRAP);
	set_idt(BEGIN_VECT+12,	irq12,	IDT_TRAP);
	set_idt(BEGIN_VECT+13,	irq13,	IDT_TRAP);
	set_idt(BEGIN_VECT+14,	irq14,	IDT_TRAP);
	set_idt(BEGIN_VECT+15,	irq15,	IDT_TRAP);
}


//================================== PUBLIC =============================================


// SPƥν
// return : error number
int init_sp()
{
	// PICν
	init_pic();

	/* ϡɳߤEOIؿꤹ */
	irq_eoi = sp_eoi;

	/* ϡɳߥޥؿ,ޥؿꤹ */
	release_irq_mask = release_pic_mask;
	set_irq_mask = set_pic_mask;

	return 0;
}
