/*
 * signal.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef signal_h
#define signal_h


#include"proc.h"
#include<sys/signal.h>


#ifndef ASM_FILE


/* ʥ빽¤Ρ */
typedef struct{
	SIG_ACTION	 action[NSIG];		/* sigunal actions. */
	sigset_t	 actMask[NSIG];		/* ϥɥ顼¹Υޥ */
	int			 actFlag[NSIG];		/* ϥɥ顼¹ԥե饰 */
	uint		 signal;			/* signal bitmap. */
	uint		 reserve;			/* reserve signal bitmap. */
	uint		 mask;				/* signal mask. */
	int			 lock;				/* ʥԤƱå */
}SIGNAL;


extern void doSignal();
extern void doSignalRestart();
extern int sendSignal(PROC*,int);
extern void forceSendSignal(PROC*, const int, const int);
extern void sigWait();
extern void sigWakeSoon(PROC *);
extern SIGNAL *setSignal(SIGNAL*);
extern void releaseSignal(SIGNAL*);
extern void resetSignal(SIGNAL*);
extern int isSigint();
extern void setSigAllMask();
extern SIGNAL *setFirstSignal();
extern int sys_sigaction();
extern int sys_sigprocmask();
extern int sys_kill();
extern int sys_sigpending();
extern int sys_sigsuspend();
extern void initSignal();


#endif


#endif
