/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include <sys/types.h>
#include <sys/wait.h>
#include <machine/except_i386.h>
#include <machine/segment.h>
#include <kern/list.h>
#include <kern/time.h>


#ifndef ASM_FILE


enum{
	MAX_CHILD=8,		/* Max number of child processes */

	/* ץξ֡ */
	TASK_RUNNING			= 1 << 0,
	TASK_WAIT				= 1 << 1,
	TASK_DEVICE_WAIT		= 1 << 2,	/* ǥХԤ */
	TASK_SIGNAL_WAIT		= 1 << 3,	/* ʥԤ */
	TASK_SEND_SIGNAL_WAIT	= 1 << 4,	/* 줿ʥˤԤ */
	TASK_TRACE				= 1 << 5,	/* ȥ졼档 */
	TASK_EXIT				= 1 << 6,	/* Exit. */
	TASK_CHILD_WAIT			= 1 << 7,	/* wait callԤ */
};


/* ץ¤ */
struct proc{
	struct proc		*next;				// 塼
	struct proc		*prev;				// 塼
	OBJ_LIST		waitList;			// ץѥꥹ
	struct proc		*proc_next;			// ץꥹ
	struct proc		*proc_prev;			// ץꥹ
	uint			esp;				// ֤ƥȤΥåȥåesp
	struct proc		*parent;			// Parent process.
	struct proc		*brother;			// Brother process
#define PROC_ZERO_TOP child				// 0λϤǡ
	struct proc		*child;				// Child process
	char			nestCount;			// ߥͥȥȡ
	uchar		 	count_child;		// Number of child processes
	uchar		 	exit_state;			// Exit state.
	uchar		 	signum;				// Exit signal number.
	FPU_SAVE	 	fpu;				// FPUֹ¤
	uint64		 	sysTime;			// CPUƥв᥿rdtsc͡
	uint64		 	userTime;			// CPU桼в᥿rdtsc͡
	uint		 	ctime[2];			// Children clock tick,0:system 1:user.
#define PROC_ZERO_END cpu				// 0κǸμǡ
	uchar			cpu;				// running cpu number ƯƤʤ-1ʲ
	uchar			state;				// ץξ֡
	pid_t			pid;				// process ID.
	pid_t			pgid;				// process groupe ID.
	uid_t			uid;				// user ID.
	gid_t			gid;				// user groupe ID.
	pid_t			sid;				// session ID.
	uint			espBack;			// ¸桼ϥɥ¹ԻθΥͥESP͡
	OBJ_LIST		*procTimerHead;		// ץݻޡإå
	struct ITIMER	itimer[ITIMER_MAX];	// itimer
	void			*ctlterm;			// ߥʥ湽¤Ρ
	void			*signal_struct;		// ʥ¤Ρ
	void			*mm_struct;			// ꡼¤Υɥ쥹
	void			*file_struct;		// ե빽¤Υɥ쥹
	int				gate;				// ԥå
};

typedef struct proc PROC;

/* ץꥹȹ¤Ρ */
typedef struct PROC_LIST{
	struct PROC_LIST *next;
	struct PROC_LIST *prev;
	int lockGate;
}PROC_LIST;

/* cpuȤΥ¤ */
typedef struct CPU{
	int cpu;				/* number of cpu */
	PROC *current_task;		/* ߤβƯprocess */
	uint proc_num;			/* ưץ */
	int gate;				/* Lock gate */
}CPU;


extern CPU cputask[];
extern PROC_LIST PROCHash[];


#define getProcAddr(address,member) (PROC*)((uint)address-(uint)&((PROC*)0)->member)


/*
 * Get current cpu number
 * returns : current cpu number
 */
extern inline int get_current_cpu()
{
	int result;


	asm volatile(
		"xorl	%%eax,%%eax\n"\
		"str	%%ax\n"\
		"subl	%1,%%eax\n"\
		"shrl	$3,%%eax"
		:"=a"(result):"i"(TSS_DES)
	);

	return result;
}

/*
 * Get current task
 * return : Current process
 */
extern inline PROC *get_current_task()
{
	return cputask[get_current_cpu()].current_task;
}


extern void addToSchedule(PROC*, const int);
extern void addToScheduleSoon(PROC *, const int);
extern void delFromSchedule(const int);
extern void initAddScheduleFlag(int *);
extern int addToScheduleSet(PROC *, const int, int *);
extern int delFromScheduleRef(const int, int *);
extern void waitProcSignal(void **waitHead);
extern void runProcSignal(void **waitHead);
extern PROC *searchProcList(int);
extern void waitProc1();
extern void incrementNest();
extern void decrementNest();
extern int isNest();
extern int isSingleNest();
extern int forkKernelThread();
extern int initProc1();
extern int init_cputask(int);
extern int set_idle_proc(int);
extern void set_tss(int);
extern void start_tasking();
extern PROC *getNextProc(PROC*,int);
extern void sendSignalAllProc(int);
extern void exit(int,int);
extern int sys_fork();
extern int sys_exit();
extern int sys_exec();
extern int sys_wait();
extern int sys_getpid();
extern int sys_getgid();
extern int sys_getpgid();
extern int sys_getppid();
extern int sys_getuid();
extern int sys_getsid();
extern int sys_setgid();
extern int sys_setpgid();
extern int sys_setuid();
extern int sys_setsid();

extern int sys_times();


#endif


#endif
