/*
 * mp.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ޥץåѥ롼
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/config.h>
#include <machine/pcibus.h>
#include <kern/errno.h>
#include <kern/lib.h>
#include <kern/proc.h>
#include <kern/interrupt.h>
#include <kern/mm.h>
#include <kern/time.h>
#include <kern/lock.h>
#include <kern/time.h>
#include <kern/pci.h>
#include <kern/sp.h>
#include <kern/mp.h>
#include <dev/console/console.h>
#include <dev/MC146818.h>
#include <dev/8254.h>
#include <kern/debug.h>


enum{
	/* MPơ֥ط */
	FLOAT_HEADER_ADDRES=4,			/* MP configuration table address */
	FLOAT_CONFIG_TYPE=11,			/* MP System Configuration Type(8Х) */
	FLOAT_IMCR_FLAG=12,				/* IMCR presence bit(7ӥå) */

	HEADER_LENGTH=44,				/* Header table length(Х) */
	HEADER_TABLE_LENGTH=4,			/* Base configuration length(16Х) */
	HEADER_ENTRY_COUNT=34,			/* Base configuration table count(16Х) */
	HEADER_LOCAL_APIC_ADDRES=36,	/* Local APIC address */

	TABLE_ENTRY_TYPE=0,				/* Configuration table entry type(8Х) */

	TYPE_PROCESSOR=0,				/* CPUץ */
	TYPE_BUS=1,						/* BUSץ */
	TYPE_IO_APIC=2,					/* IO_APICץ */
	TYPE_IO_INTERRUPT=3,			/* IO_INTERRUPTץ */
	TYPE_LOCAL_INTERRUPT=4,			/* LOCAL_INTERRUPTץ */

	TABLE_PROCESSOR_LENGTH=20,		/* PROCESSOR table length(Х) */
	TABLE_PROCESSOR_FLAG=3,			/* CPU enable flag(0ӥå) */
	TABLE_PROCESSOR_FAMILY=5,		/* CPU Family (8Х)*/

	TABLE_IO_APIC_ID=1,				/* IO_APIC ID */
	TABLE_IO_APIC_FLAG=3,			/* IO_APIC enable flag(0ӥå) */
	TABLE_IO_APIC_ADDRESS=4,		/* IO_APIC address */

	/* ߥ٥ */
	APIC_TIMER_VECT=	0x30,
	IRQ0_VECT=			0x2f,
	IRQ1_VECT=			0x2e,
	IRQ3_VECT=			0x2c,
	IRQ4_VECT=			0x2b,
	IRQ5_VECT=			0x2a,
	IRQ6_VECT=			0x29,
	IRQ7_VECT=			0x28,
	IRQ8_VECT=			0x27,
	IRQ9_VECT=			0x26,
	IRQ10_VECT=			0x25,
	IRQ11_VECT=			0x24,
	IRQ12_VECT=			0x23,
	IRQ13_VECT=			0x22,
	IRQ14_VECT=			0x21,
	IRQ15_VECT=			0x20,
};


uint MFPS_addres;			/* MFPSɥ쥹setup.S */
extern int *active_cpu;		/* ưCPU */
extern void start_tasking();


/*****************************************************************************
 *
 * LOCAL APIC
 *
 *****************************************************************************/


enum{
	/* LOCAL_APIC١ɥ쥹 */
	LOCAL_APIC_BASE=0xfee00000,

	/* LOCAL APIC register */
	LOCAL_APIC_ID=	0x20/sizeof(int),
	LOCAL_APIC_TPR=	0x80/sizeof(int),
	LOCAL_APIC_EOI=	0xb0/sizeof(int),
	LOCAL_APIC_LDR=	0xd0/sizeof(int),
	LOCAL_APIC_DFR=	0xe0/sizeof(int),
	LOCAL_APIC_SVR=	0xf0/sizeof(int),
	LOCAL_APIC_ISR1=0x100/sizeof(int),
	LOCAL_APIC_ISR2=0x110/sizeof(int),
	LOCAL_APIC_TMR1=0x180/sizeof(int),
	LOCAL_APIC_TMR2=0x190/sizeof(int),
	LOCAL_APIC_IRR1=0x200/sizeof(int),
	LOCAL_APIC_IRR2=0x200/sizeof(int),
	LOCAL_APIC_ICR1=0x300/sizeof(int),
	LOCAL_APIC_ICR2=0x310/sizeof(int),
	LOCAL_APIC_TIME=0x320/sizeof(int),
	LOCAL_APIC_LNT0=0x350/sizeof(int),
	LOCAL_APIC_LNT1=0x360/sizeof(int),
	LOCAL_APIC_ICNT=0x380/sizeof(int),
	LOCAL_APIC_CCNT=0x390/sizeof(int),
	LOCAL_APIC_TDVC=0x3e0/sizeof(int),
};


static uint volatile *local_apic = (uint*)LOCAL_APIC_BASE;	/* LOCAL APIC base address */
static uint task_count;										/* 1ư֤APICޡ */


/*
 * APIC TIMER handler
 * smpƥΥ󥰤Ԥ
 * returns : Task switch on
 */
static int apictimer_handler(int irq)
{
/*****************************************************************************/
	{
		static char value[MAX_CPU] = {'0','0','0','0','0','0','0','0'};
		int cpu = get_current_cpu();

		if ('9' < value[cpu]){
			value[cpu] = '0';
		}
		displayTop(60 + cpu, &value[cpu],1);
		++value[cpu];
	}
/****************************************************************************/
	local_apic[LOCAL_APIC_ICNT]=task_count;	/* restart APIC TIMER */

	return 1;
}


/*
 * APIC_BASE_MSR˽񤭹
 *  : 񤭹
 */
static void wr_apic_msr(uint base)
{
	enum{APICBASE=27};


	asm volatile(
		"xorl	%%edx,%%edx\n"
		"wrmsr"
		::"a"(base|0x800),"c"(APICBASE)
	);
}


/*
 * APIC TIMERΣsΥȿ¬ꤹ
 * return : sΥȿ
 */
static uint count_apictimer()
{
	int apictimer_count;
	double time;

	setClockSecond();

	local_apic[LOCAL_APIC_ICNT]=0xffffffff;								/* APIC TIMERư */
	for(;;)if(0xffffffff-local_apic[LOCAL_APIC_CCNT]>0x200000)break;	/* ٱ */
	apictimer_count=local_apic[LOCAL_APIC_CCNT];

	time = getClockSecond();

	apictimer_count = (0xffffffff - apictimer_count) / time;

	return apictimer_count;  /* 1sΥȲ */
}


/*
 * PUBLIC
 * Virtual Wire⡼ɤ̵ˤ 
 */
static void ignoreVirtualWireMode()
{
	local_apic[LOCAL_APIC_LNT0] = 0x10000;		/* LINT0ޥ */
	local_apic[LOCAL_APIC_LNT1] = 0x10000;		/* LINT1ޥ */
}


/*
 * Init LOCAL APIC
 * Require atomic handlig
 * parameters : Cpu number
 */
static void init_localapic(int volatile cpu)
{
	uint value;


	/* LOCAL_APIC١ɥ쥹 */
	wr_apic_msr(LOCAL_APIC_BASE);		/* LOCAL_APICϡɥ֥͡ */

	/* LOCAL_APICեȥ֥͡ */
	local_apic[LOCAL_APIC_SVR]=0x12f;

	/* LOCAL_APIC_IDꤹ */
	local_apic[LOCAL_APIC_ID]=cpu<<24;

	/* ⡼ɤեåȥǥ(8cpu)ꤹ */
	local_apic[LOCAL_APIC_LDR]=0x1000000<<cpu;
	local_apic[LOCAL_APIC_DFR]=0xffffffff;

	/* ץ饤ƥ */
	local_apic[LOCAL_APIC_TPR]=0;

	/* ޡߤ */
	local_apic[LOCAL_APIC_TDVC]=0xb;					/* ʬ1 */
	local_apic[LOCAL_APIC_TIME]=APIC_TIMER_VECT;		/* 󥷥åȥ⡼|ޥ */
	if (cpu == 0)
	{
		set_idt(APIC_TIMER_VECT,apictimer,IDT_TRAP);	/* idt */
		value=count_apictimer();						/* APICޡHZ¬ */
		printk("APIC TIMER = %d HZ\n",value);
		task_count=value/(1000/TASK_TIME);				/* ư */
		irq_entry[APIC_TIMER]=apictimer_handler;		/* APICޡInterrupt tableꤹ */
	}
	local_apic[LOCAL_APIC_ICNT] = task_count;			/* ޡư */
}


/*
 * Issue interrupt to cpu
 * parameters : Cpu number,Interrupt vecter
 */
void issue_interrupt_to_cpu(int cpu,int vecter)
{
	local_apic[LOCAL_APIC_ICR2]=cpu<<24;
	local_apic[LOCAL_APIC_ICR1]=0x00004000|vecter;	/* ǥƥ͡⡼ʪ */
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);		/* ãơγǧ */
}


/*
 * Page directory flash handler
 * returns : Task switch on
 */
int flash_pagedir_handler(int irq)
{
	updateVm();
	local_apic[LOCAL_APIC_EOI]=0;		/* issue EOI */

	return 1;
}


/*****************************************************************************
 *
 * IO APIC
 *
 *****************************************************************************/


//================================== PRIVATE ============================================


//================================== PRIVATE ============================================


enum{
	/* IOAPIC register */
	IO_APIC_ID=		0x0,
	IO_APIC_VER=	0x1,
	IO_APIC_ARBT=	0x2,
	IO_APIC_LRT0=	0x10,
	IO_APIC_HRT0=	0x11,
	IO_APIC_LRT1=	0x12,
	IO_APIC_HRT1=	0x13,
	IO_APIC_LRT2=	0x14,
	IO_APIC_HRT2=	0x15,
	IO_APIC_LRT3=	0x16,
	IO_APIC_HRT3=	0x17,
	IO_APIC_LRT4=	0x18,
	IO_APIC_HRT4=	0x19,
	IO_APIC_LRT5=	0x1a,
	IO_APIC_HRT5=	0x1b,
	IO_APIC_LRT6=	0x1c,
	IO_APIC_HRT6=	0x1d,
	IO_APIC_LRT7=	0x1e,
	IO_APIC_HRT7=	0x1f,
	IO_APIC_LRT8=	0x20,
	IO_APIC_HRT8=	0x21,
	IO_APIC_LRT9=	0x22,
	IO_APIC_HRT9=	0x23,
	IO_APIC_LRT10=	0x24,
	IO_APIC_HRT10=	0x25,
	IO_APIC_LRT11=	0x26,
	IO_APIC_HRT11=	0x27,
	IO_APIC_LRT12=	0x28,
	IO_APIC_HRT12=	0x29,
	IO_APIC_LRT13=	0x2a,
	IO_APIC_HRT13=	0x2b,
	IO_APIC_LRT14=	0x2c,
	IO_APIC_HRT14=	0x2d,
	IO_APIC_LRT15=	0x2e,
	IO_APIC_HRT15=	0x2f,
	IO_APIC_LRT16=	0x30,
	IO_APIC_HRT16=	0x31,
	IO_APIC_LRT17=	0x32,
	IO_APIC_HRT17=	0x33,
	IO_APIC_LRT18=	0x34,
	IO_APIC_HRT18=	0x35,
	IO_APIC_LRT19=	0x36,
	IO_APIC_HRT19=	0x37,

	/* IO APIC register */
	IO_APIC_REGSEL=	0xfec00000,
	IO_APIC_WIN=	0xfec00010,

	/* IO APIC redirection table. */
	IOREDTBL_MASK=	0x10000,
	IOREDTBL_POLLOW=1<<13,
	IOREDTBL_MODE_PHYS=0,
	IOREDTBL_MODE_LOGIC=1<<11,
	IOREDTBL_DELIV_FIX=0,
	IOREDTBL_DELIV_LOWPRT=1<<8,
	IOREDTBL_DELIV_EXTINT=7<<8,

	IO_APIC_PCIIRQ=16,		/* Begin of PCI IRQ number. */
};


/* IRQȤIOAPIC LRTɥ쥹 */
uint ioapic_lrt[]=
{
	IO_APIC_LRT2 ,
	IO_APIC_LRT1 ,
	0            ,
	IO_APIC_LRT3 ,
	IO_APIC_LRT4 ,
	IO_APIC_LRT5,
	IO_APIC_LRT6 ,
	IO_APIC_LRT7 ,
	IO_APIC_LRT8 ,
	IO_APIC_LRT9 ,
	IO_APIC_LRT10,
	IO_APIC_LRT11,
	IO_APIC_LRT12,
	IO_APIC_LRT13,
	IO_APIC_LRT14,
	IO_APIC_LRT15,
	IO_APIC_LRT16,
	IO_APIC_LRT17,
	IO_APIC_LRT18,
	IO_APIC_LRT19,
};

/* IRQȤIOAPIC HRTɥ쥹 */
static uint ioapic_hrt[]=
{
	IO_APIC_HRT2 ,
	IO_APIC_HRT1 ,
	0            ,
	IO_APIC_HRT3 ,
	IO_APIC_HRT4 ,
	IO_APIC_HRT5,
	IO_APIC_HRT6 ,
	IO_APIC_HRT7 ,
	IO_APIC_HRT8 ,
	IO_APIC_HRT9 ,
	IO_APIC_HRT10,
	IO_APIC_HRT11,
	IO_APIC_HRT12,
	IO_APIC_HRT13,
	IO_APIC_HRT14,
	IO_APIC_HRT15,
	IO_APIC_HRT16,
	IO_APIC_HRT17,
	IO_APIC_HRT18,
	IO_APIC_HRT19,
};
static uchar ioapic_intr_vect[]=
{
	IRQ0_VECT ,
	IRQ1_VECT ,
	0         ,
	IRQ3_VECT ,
	IRQ4_VECT ,
	IRQ5_VECT ,
	IRQ6_VECT ,
	IRQ7_VECT ,
	IRQ8_VECT ,
	IRQ9_VECT ,
	IRQ10_VECT,
	IRQ11_VECT,
	IRQ12_VECT,
	IRQ13_VECT,
	IRQ14_VECT,
	IRQ15_VECT,
};
static uint volatile *io_apic_regsel=(uint*)IO_APIC_REGSEL;	/* IOAPIC REGSEL address */
static uint volatile *io_apic_win=(uint*)IO_APIC_WIN;		/* IOAPIC WIN address */


/*
 * Read IOAPIC
 *  : ɥ쥹
 * ֤ : ɤ߹
 */
static inline uint read_ioapic(uint addr)
{
	*io_apic_regsel=addr;
	return *io_apic_win;
}

/*
 * Write IOAPIC
 *  : ɥ쥹񤭹
 */
static inline void write_ioapic(uint addr,uint value)
{
	*io_apic_regsel=addr;
	*io_apic_win=value;
}


//================================== PUBLIC =============================================


/*
 * Release interrupt mask
 * prameters : IRQ number
 */
void release_ioapic_mask(uchar irq)
{
	write_ioapic(ioapic_lrt[irq],read_ioapic(ioapic_lrt[irq])&~IOREDTBL_MASK);
}


/*
 * Set interrupt mask
 * prameters : IRQ number
 */
void set_ioapic_mask(uchar irq)
{
	write_ioapic(ioapic_lrt[irq],read_ioapic(ioapic_lrt[irq])|IOREDTBL_MASK);
}


// PCIߥ٥IOAPICꤹ
void SetPciIrqInIoapic(const int bus, const int device, const int intpin, const int irq)
{
	int pciIrq;

	ASSERT(irq < ARRAY_LENGTH(ioapic_intr_vect));

	pciIrq = pci_cfgintr(bus, device, intpin);
	if (pciIrq == 255){
		printk("SetPciIrqInIoapic() PCI irq get error!\n");
		return;
	}
	pciIrq += IO_APIC_PCIIRQ;

	write_ioapic(ioapic_lrt[pciIrq], read_ioapic(ioapic_lrt[pciIrq]) | ioapic_intr_vect[irq]);
	// ߥޥ
	write_ioapic(ioapic_lrt[pciIrq], read_ioapic(ioapic_lrt[pciIrq]) & ~IOREDTBL_MASK);
}


/*
 * Init IO APIC
 * param : cpu number
 */
void init_ioapic(int cpu)
{
	enum{
		IMCR_SEL=0x22,		/* IMCR쥯ȥݡȥɥ쥹 */
		IMCR_WRI=0x23		/* IMCR񤭹ߥݡȥɥ쥹 */
	};

	char *mp_floating;


	/* ߤSymmetric⡼ɤڤؤ */
	outb(OCW1S,0xff);				/* pic졼ֳߤޥ */
	outb(OCW1M,0xff);				/* picޥߤޥ */
	mp_floating=(char*)MFPS_addres;
	if(mp_floating[FLOAT_IMCR_FLAG]&(1<<7))
	{
		/*PIC⡼ɤ̵ˤ */
		outb(IMCR_SEL,0x70);		/* IMCR쥯 */
		outb(IMCR_WRI,1);			/* PIC⡼̵ */
	}
	else
		/* Virtual Wire⡼ɤ̵ˤ */
		ignoreVirtualWireMode();

	/* IO_APIC_ID */
	write_ioapic(IO_APIC_ID,cpu<<24);

	/* idt */
	set_idt(IRQ0_VECT,irq0,IDT_TRAP);
	set_idt(IRQ1_VECT,irq1,IDT_TRAP);
	set_idt(IRQ3_VECT,irq3,IDT_TRAP);
	set_idt(IRQ4_VECT,irq4,IDT_TRAP);
	set_idt(IRQ5_VECT,irq5,IDT_TRAP);
	set_idt(IRQ6_VECT,irq6,IDT_TRAP);
	set_idt(IRQ7_VECT,irq7,IDT_TRAP);
	set_idt(IRQ8_VECT,irq8,IDT_TRAP);
	set_idt(IRQ9_VECT,irq9,IDT_TRAP);
	set_idt(IRQ10_VECT,irq10,IDT_TRAP);
	set_idt(IRQ11_VECT,irq11,IDT_TRAP);
	set_idt(IRQ12_VECT,irq12,IDT_TRAP);
	set_idt(IRQ13_VECT,irq13,IDT_TRAP);
	set_idt(IRQ14_VECT,irq14,IDT_TRAP);
	set_idt(IRQ15_VECT,irq15,IDT_TRAP);

	/* IOơ֥,All maske */
	write_ioapic(IO_APIC_LRT0 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ0_VECT);
	write_ioapic(IO_APIC_HRT0 ,0xff000000);
	write_ioapic(IO_APIC_LRT1 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ1_VECT);
	write_ioapic(IO_APIC_HRT1 ,0xff000000);
	write_ioapic(IO_APIC_LRT2 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ0_VECT);
	write_ioapic(IO_APIC_HRT2 ,0xff000000);
	write_ioapic(IO_APIC_LRT3 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ3_VECT);
	write_ioapic(IO_APIC_HRT3 ,0xff000000);
	write_ioapic(IO_APIC_LRT4 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ4_VECT);
	write_ioapic(IO_APIC_HRT4 ,0xff000000);
	write_ioapic(IO_APIC_LRT5 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ5_VECT);
	write_ioapic(IO_APIC_HRT5 ,0xff000000);
	write_ioapic(IO_APIC_LRT6 ,IOREDTBL_MASK|IOREDTBL_MODE_PHYS |IOREDTBL_DELIV_FIX   |IRQ6_VECT);
	write_ioapic(IO_APIC_HRT6 ,0x00000000);
	write_ioapic(IO_APIC_LRT7 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ7_VECT);
	write_ioapic(IO_APIC_HRT7 ,0xff000000);
	write_ioapic(IO_APIC_LRT8 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ8_VECT);
	write_ioapic(IO_APIC_HRT8 ,0xff000000);
	write_ioapic(IO_APIC_LRT9 ,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ9_VECT);
	write_ioapic(IO_APIC_HRT9 ,0xff000000);
	write_ioapic(IO_APIC_LRT10,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ10_VECT);
	write_ioapic(IO_APIC_HRT10,0xff000000);
	write_ioapic(IO_APIC_LRT11,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ11_VECT);
	write_ioapic(IO_APIC_HRT11,0xff000000);
	write_ioapic(IO_APIC_LRT12,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ12_VECT);
	write_ioapic(IO_APIC_HRT12,0xff000000);
	write_ioapic(IO_APIC_LRT13,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IRQ13_VECT);
	write_ioapic(IO_APIC_HRT13,0xff000000);
	write_ioapic(IO_APIC_LRT14,IOREDTBL_MASK|IOREDTBL_MODE_PHYS |IOREDTBL_DELIV_FIX   |IRQ14_VECT);
	write_ioapic(IO_APIC_HRT14,0x00000000);
	write_ioapic(IO_APIC_LRT15,IOREDTBL_MASK|IOREDTBL_MODE_PHYS |IOREDTBL_DELIV_FIX   |IRQ15_VECT);
	write_ioapic(IO_APIC_HRT15,0x00000000);
	write_ioapic(IO_APIC_LRT16,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IOREDTBL_POLLOW);
	write_ioapic(IO_APIC_HRT16,0xff000000);
	write_ioapic(IO_APIC_LRT17,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IOREDTBL_POLLOW);
	write_ioapic(IO_APIC_HRT17,0xff000000);
	write_ioapic(IO_APIC_LRT18,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IOREDTBL_POLLOW);
	write_ioapic(IO_APIC_HRT18,0xff000000);
	write_ioapic(IO_APIC_LRT19,IOREDTBL_MASK|IOREDTBL_MODE_LOGIC|IOREDTBL_DELIV_LOWPRT|IOREDTBL_POLLOW);
	write_ioapic(IO_APIC_HRT19,0xff000000);
}


/*
 * ϡɳEOIؿ
 */
void mp_eoi(uchar i)
{
	local_apic[LOCAL_APIC_EOI]=0;		/* issue EOI */
}


/*
 * IOAPICγߤʪ⡼ɤˤ롣
 * parameters : IRQ
 */
void set_physical_intr(int irq)
{
	write_ioapic(ioapic_hrt[irq],0|ioapic_intr_vect[irq]);
}


/*
 * IOAPICγߤ⡼ɤˤ롣
 * parameters : IRQ
 */
void set_logical_intr(int irq)
{
	write_ioapic(ioapic_hrt[irq],0x900|ioapic_intr_vect[irq]);
}


/*
 * IOAPICγcpuꤹ롣
 * parameters : IRQ,cpu number
 */
void set_intr_cpu(int irq,int cpu)
{
	write_ioapic(ioapic_hrt[irq],cpu<<24);
}


/*
 * IOAPICγcpuǤդˤ롣
 * parameters : IRQ,cpu number
 */
void set_intr_anony(int irq)
{
	write_ioapic(ioapic_hrt[irq],0xff000000);
}


/********************************************************************************************************
 *
 * Boot Application prosseser
 *
 *********************************************************************************************************/


/*
 * Boot Application prosseser
 */
static void boot_acpu()
{
	enum{
		WARMBOOT_IP=0x467,	/* Warm bootɥݥɥ쥹 */
		WARMBOOT_CS=0x469	/* Warm bootCSɥ쥹 */
	};

	extern void mpstart();				/* setup.Sν */
	extern void switch_protect_mode();	/* setup.Sץƥȥ⡼ɰܹԥ */

	ushort *p;
	uint value;


	/*
	 * ץꥱץåεư
	 * ޤ2ĤINIT_IPIäSTARTUP_IPIդ褦ˤ롣STARTUP_IPIäBIOSưɤ˥פ롣
	 * BIOSɤ̤뤳Ȥˤäơץååԡɤư褦ˤʤ褦ơWarmBootꤷ
	 * ɤ˥פ롣
	 */
	/* Warm boot */
	write_cmos(0xf,0xa);
	p=(ushort*)WARMBOOT_IP;
	*p=(ushort)switch_protect_mode&0xf;
	p=(ushort*)WARMBOOT_CS;
	*p=(ushort)switch_protect_mode>>4;

	/* ޤINIT_IPI Assert mode */
	local_apic[LOCAL_APIC_ICR2]=0xf000000;
	value=local_apic[LOCAL_APIC_ICR1];
	value=(value&0xfff32000)|0xcc500;
	local_apic[LOCAL_APIC_ICR1]=value;
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);

	/* INIT_IPI DeASSERT mode */
	value=local_apic[LOCAL_APIC_ICR1];
	value=(value&0xfff32000)|0xc8500;
	local_apic[LOCAL_APIC_ICR1]=value;
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);

	/* 10msԤ */
	mili_timer(10);

	/*
	 * ǸSTARTUP_IPI
	 * 2뤳ȤˤʤäƤ뤬1ǵư褦
	 */
	value=local_apic[LOCAL_APIC_ICR1];
	value=(value&0xfff32000)|((uint)mpstart>>12)|0xc0600;
	local_apic[LOCAL_APIC_ICR1]=value;
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);
}


//================================== PUBLIC =============================================


// ޥCPU
// return : YES or NO
int isMp()
{
	return (MFPS_addres != 0)? YES : NO;
}


/********************************************************************************************************
 *
 * 
 *
 *********************************************************************************************************/


// SMPƥν
// return : error number
int init_mp()
{
	enum {
		WAIT_ACTIVE_CPU = 1000,		// CPUưԤ(ms)
	};
	char *mp_floating,*mp_header,*mp_table;
	char *p;
	int cpu_num;
	uint64 beginClock;

	mp_floating = (char*)MFPS_addres;
	mp_header = (char*)*(char**)(mp_floating + FLOAT_HEADER_ADDRES);
	mp_table = mp_header + HEADER_LENGTH;

	/* cpu򥫥Ȥ */
	for (p = mp_table,cpu_num = 0; *p == TYPE_PROCESSOR; p += TABLE_PROCESSOR_LENGTH){
		if (*(p + TABLE_PROCESSOR_FLAG) & 1){
			++cpu_num;
		}
		if (MAX_CPU < cpu_num){
			return ERR;
		}
	}

	++*active_cpu;	/* ƯcpuΥ */

	/* Init local apic */
	init_localapic(0);

	/* ϡɳߤEOIؿꤹ롣(ץꥱcpuư) */
	irq_eoi = mp_eoi;

	// ץꥱcpuư
	boot_acpu();

	/* pagingǻȤpage directoryߤ */
	set_idt(FLASH_PAGEDIR_VECT, flash_pagedir, IDT_TRAP);
	irq_entry[FLASH_PAGEDIR] = flash_pagedir_handler;

	/* Init IO apic٤Ƥcpuεưȯ */
	beginClock = rdtsc();
	while (*active_cpu != cpu_num) {
		if (WAIT_ACTIVE_CPU < getTimeFromClock(beginClock)) {
			printk("Booting application cpu isn't complete!\n");
			break;
		}
	}
	init_ioapic(cpu_num);

	/* ϡɳߥޥؿ,ޥؿꤹ */
	release_irq_mask = release_ioapic_mask;
	set_irq_mask = set_ioapic_mask;

	return NOERR;
}


/*
 * Application cpuꤹ
 */
void init_application_cpu()
{
	static int spingate = 0;
	int cpu;


	/* fpuν */
	asm("fninit");

	enter_spinlock(&spingate);
	{
		cpu = *active_cpu;

		/* TSSǥץɤ */
		set_tss(TSS_DES+cpu*8);

		/* Init parameters relatibe to task */
		init_cputask(cpu);

		/* cpu clockη¬ */
		printk("cpu%d clock = %d HZ\n", cpu, getCpuClock());

		++*active_cpu;
	}
	exit_spinlock(&spingate);

	/* LOCAL_APICν */
	init_localapic(cpu);

	/* ɥץ롣 */
	if (set_idle_proc(cpu) == -1)
	{
		printk("Fail set_idle_proc! cpu=%d.\n",cpu);
		idle();
	}

	/* 󥰳 */
	start_tasking();
}

/*********************************************************************************/
void test_mp()
{
	printk("IRQ14REG LOW=%x HIGH=%x\n",read_ioapic(IO_APIC_LRT14),read_ioapic(IO_APIC_HRT14));
}
/**********************************************************************************/
