/*
 * mm.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * mm.c ѥإåե
 */


#ifndef mm_h
#define mm_h


#include<sys/types.h>
#include"proc.h"
#include"fs.h"


#ifndef ASM_FILE


enum{
	/* loadBinary() flag. */
	LB_R=1,
	LB_WR=2,
};


typedef struct{
	uint *pageDir;
	int pageDirGate;		/* ڡǥ쥯ȥåȡ */
	uint lastPageAddr;		/* ƺѤߥڡ饹ȥɥ쥹 */
	uint firstStackAddr;	/* ѤߥåƬɥ쥹 */
}MM_STRUCT;

/*
 * ꡼¤
 */
typedef struct{
	const int dummy;
}MEM_ARRAY;


extern void *kmallocSize(const uint, uint *);
extern void *kmalloc(size_t);
extern uint kfree(void*);
extern MEM_ARRAY *allocArray(size_t);
extern void freeArray(MEM_ARRAY *);
extern MEM_ARRAY *reallocArray(MEM_ARRAY *,size_t);
extern int writeArray(MEM_ARRAY *,const int,const size_t,const void *);
extern void copyArray(MEM_ARRAY *,const int,const size_t,void *);
extern int initBackupDev(const char*);
extern void updateVm();
extern uint getLastLinearAddr();
extern int checkMem(const void*,size_t);
extern void initMm();
extern void *initPaging();
extern int forkPage(MM_STRUCT*, int, void**, void**);
extern int loadBinary(EXEC_FD*,size_t,size_t,uint,int);
extern uint setUserStack(char**, char**);
extern void releaseUserPage();
extern uint *getPageDir();
extern uint getPhysicalFromLogicalAddr(PROC*, uint);
extern uint addUserStack(int);
extern void delAddedUserStack();
extern int sys_brk(void*);
extern int doUserHandler(int,void(*)(int));
extern void returnUserHandler();
extern uint getMaxMemory();

#endif


#endif
