/*
 * mm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꡼ץ
 *
 * ǡΡ
 *		phis_linkξ֤ǥڡ꡼¾ץ鲣ꤵΤǡڡơ֥륨ȥ꡼ѹ
 * 		phis_linkäPHYS_MEM_TABLǤpage_tbl_addƱɬפ롣
 *
 * 
 *  ڡβǶ礬ʤ褦ˤ롣
 */


#include <sys/config.h>
#include <sys/param.h>
#include <sys/types.h>
#include <machine/segment.h>
#include "lib.h"
#include "lock.h"
#include "interrupt.h"
#include "proc.h"
#include "mp.h"
#include "errno.h"
#include "fs.h"
#include "device.h"
#include "signal.h"
#include "mm.h"
#include "debug.h"
#include "test.h"


//#define DEBUG_MM 1

#ifdef DEBUG_MM
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE	inline
#endif


static int backupPage(uint,PROC*,uint*);
static int restorePage(uint *pentry,void *buf);


/***********************************************************************************
 *
 *ʪ꡼ڡ
 *
 ***********************************************************************************/


/*
 * ꡼ڡơ֥
 */
typedef struct PHYS_MEM_TABL{
	short ref_count;			/* reference count */
	ushort heap_num;			/* Heap number */
	PROC *proc;					/* ƤƤץ */
	uint *pentry;				/* ƤƤڡȥ꡼ɥ쥹 */
	struct PHYS_MEM_TABL *next;
	struct PHYS_MEM_TABL *prev;
}PHYS_MEM_TABL;


/*============================ ץ饤١ ===================================*/


enum{
	PHYSICAL_PAGE_TABLE_ADD = KERNEL_DATA_BEG,	/* ʪ꡼ơ֥륢ɥ쥹 */
};

/*
 * ꡼ڡơ֥󥯥إå
 */
static PHYS_MEM_TABL *freeKrnMem;	// ꥹȡͥʪ꡼󥯥ȥå
static PHYS_MEM_TABL *freeUsrMem;	// ꥹȡ桼ʪ꡼󥯥
static PHYS_MEM_TABL usedKrnMem;	// ξꥹȡʲġ˥ͥʪ꡼󥯥ȥå
static PHYS_MEM_TABL usedUsrMem;	// ξꥹȡʲġ˥桼ʪ꡼󥯥ȥå
static int physMemLock;				// PHYS_MEM_TABLѥå


/*
 * ꡼
 * setup.S
 */
static uint all_memory_size;


/*
 * ꡼ɥ쥹꡼ڡơ֥륢ɥ쥹֤
 * parameters : Physical address
 * return : PHYS_MEM_TABL address
 */
STATIC INLINE PHYS_MEM_TABL *getPhysTableFromAddr(void *addr)
{
	return (PHYS_MEM_TABL*)((uint)addr / PAGE_SIZE * sizeof(PHYS_MEM_TABL) + PHYSICAL_PAGE_TABLE_ADD);
}


/*
 * ꡼ڡơ֥륢ɥ쥹꡼ɥ쥹֤
 * parameters : PHYS_MEM_TABL address
 * return : Physical address
 */
STATIC INLINE void *getAddrFromPhysTable(PHYS_MEM_TABL *memtable)
{
	return (void*)(((uint)memtable-PHYSICAL_PAGE_TABLE_ADD)/sizeof(PHYS_MEM_TABL)*PAGE_SIZE);
}


/*
 * "physMemLock"ǥå줿椫ƤӽФ뤳
 * ꡼ơ֥ե꡼󥯤Ф
 * parameters : ե꡼ȥåץɥ쥹ݥ
 * return : ꡼ơ֥륢ɥ쥹
 */
STATIC INLINE PHYS_MEM_TABL *getFreeMem(PHYS_MEM_TABL **freeTop)
{
	PHYS_MEM_TABL *mtbl = *freeTop;

	mtbl->ref_count = 1;
	*freeTop = mtbl->next;
	mtbl->prev = mtbl->next = mtbl;

	return mtbl;
}


/*
 * "physMemLock"ǥå줿椫ƤӽФ뤳
 * ꡼ơ֥ե꡼󥯤˲ä롣
 * parameters : ɲå꡼ơ֥,ե꡼󥯥ȥå
 */
STATIC INLINE void addFreeMem(PHYS_MEM_TABL *mtbl,PHYS_MEM_TABL **freeTop)
{
	mtbl->ref_count = 0;
	mtbl->proc = NULL;
	mtbl->pentry = NULL;
	mtbl->next = *freeTop;
	*freeTop = mtbl;
}


/*
 * "physMemLock"ǥå줿椫ƤӽФ뤳
 * ɬФ꡼ơ֥뤬¸ߤΤǧƸƤӽФ뤳
 * parameters : 󥯥
 * return : ꡼ơ֥륢ɥ쥹
 */
STATIC INLINE PHYS_MEM_TABL *getUsedMem(PHYS_MEM_TABL *usedTop)
{
	PHYS_MEM_TABL *mtbl = usedTop->prev;

	mtbl->next->prev = mtbl->prev;
	mtbl->prev->next = mtbl->next;
	mtbl->next = mtbl->prev = mtbl;

	return mtbl;
}


/*
 * "physMemLock"ǥå줿椫ƤӽФ뤳
 * parameters : ɲå꡼ơ֥,󥯥ȥå,ץơ֥,ƥڡȥ꡼
 */
STATIC INLINE void addUsedMem(PHYS_MEM_TABL *mtbl,PHYS_MEM_TABL *usedTop)
{
	mtbl->next = usedTop->next;
	mtbl->prev = usedTop;
	usedTop->next->prev = mtbl;
	usedTop->next = mtbl;
}


/*
 * "physMemLock"ǥå줿椫ƤӽФ뤳
 * parameters : ɲå꡼ơ֥,󥯥ȥå,ץơ֥,ƥڡȥ꡼
 */
STATIC INLINE void rmoveUsedMem(PHYS_MEM_TABL *mtbl)
{
	mtbl->prev->next = mtbl->next;
	mtbl->next->prev = mtbl->prev;
	mtbl->next = mtbl->prev = mtbl;
}


/*
 * allocMultiKernelPage()ѡ
 * ե꡼ͥ꡼󥯤ƳƤ롣
 * parameters : ʪ꡼ơ֥륢ɥ쥹
 */
STATIC INLINE void delFreeKrnLink(PHYS_MEM_TABL *mtbl)
{
	PHYS_MEM_TABL *p;


	if (mtbl == freeKrnMem)
		freeKrnMem = mtbl->next;
	else
	{
		for (p = freeKrnMem; p->next != mtbl; p = p->next);
		p->next = mtbl->next;
	}

	mtbl->ref_count = 1;
	mtbl->next = mtbl;
}


/*============================ ѥ֥å ===================================*/


/*
 * ꡼ڡλȥȤ䤹
 * parameters : ʪɥ쥹
 */
STATIC void linkPhysTable(void *addr)
{
	PHYS_MEM_TABL *mtbl;


	mtbl = getPhysTableFromAddr(addr);

	enter_spinlock(&physMemLock);
	{
		++mtbl->ref_count;

		mtbl->proc = NULL;
		mtbl->pentry = NULL;

		// Used link
		rmoveUsedMem(mtbl);
	}
	exit_spinlock(&physMemLock);
}


/*
 * ꡼ڡλȥȤ򸺤餹
 * parameters : ʪɥ쥹
 */
STATIC void unlinkPhysTable(void *addr)
{
	PHYS_MEM_TABL *mtbl;
	int eflag;


	mtbl = getPhysTableFromAddr(addr);

#ifdef DEBUG
	if (mtbl->ref_count <= 0)
		printk("Warning! A No reference PhysTable is unlinked : addr=0x%x function=0x%x\n",addr,*((uint*)&addr-1));
#endif

	eflag = enterCli();
	enter_spinlock(&physMemLock);
	{
		--mtbl->ref_count;
		if (mtbl->ref_count <= 0)
		{
			// Used link
			rmoveUsedMem(mtbl);
			
			/* ȥإåֹ򥯥ꥢ */
			mtbl->heap_num = 0;

			if ((uint)addr < KERNEL_END)
				addFreeMem(mtbl,&freeKrnMem);
			else
				addFreeMem(mtbl,&freeUsrMem);
		}
	}
	exit_spinlock(&physMemLock);
	exitCli(eflag);
}


/*
 * ꡼ڡλȥȤʾʤ鸺餷ƸλȥȤ֤
 * parameters : ʪɥ쥹
 */
STATIC int delAndGetPhysRefCount(void *addr)
{
	int rest;
	PHYS_MEM_TABL *mtbl = getPhysTableFromAddr(addr);


	enter_spinlock(&physMemLock);
	{
		if(mtbl->ref_count > 1)
		{
			rest = mtbl->ref_count;
			--mtbl->ref_count;
		}
		else
			rest = mtbl->ref_count;
	}
	exit_spinlock(&physMemLock);

	return rest;
}


/*
 * ֤ͥإ꡼ڡƤ
 * ƤڡϲԲ
 * return : Allocate addres or NULL
 */
STATIC void *allocKernelPage()
{
	PHYS_MEM_TABL *mtbl;


	enter_spinlock(&physMemLock);

	if (freeKrnMem != NULL){
		mtbl = getFreeMem(&freeKrnMem);
		exit_spinlock(&physMemLock);
	}
	else if (usedKrnMem.next != &usedKrnMem){
		mtbl = getUsedMem(&usedKrnMem);
		exit_spinlock(&physMemLock);

		/* ꡼ƤХååפ롣 */
		if(backupPage((uint)getAddrFromPhysTable(mtbl),mtbl->proc,mtbl->pentry) == -1){
			return NULL;
		}
	}
	else{
		exit_spinlock(&physMemLock);
		return NULL;
	}

	return getAddrFromPhysTable(mtbl);
}


/*
 * 桼֤إ꡼ڡƤ
 * Ƥڡϲ
 * parameters : Ƥڡȥ꡼ɥ쥹
 * return : Allocate addres or error=NULL
 */
STATIC void *allocUserPage(uint *pentry)
{
	uint *old_pentry;
	PROC *old_proc;
	PHYS_MEM_TABL *mtbl;


	enter_spinlock(&physMemLock);

	if(freeUsrMem != NULL){
		mtbl = getFreeMem(&freeUsrMem);
		mtbl->pentry = pentry;
		mtbl->proc = get_current_task();
		addUsedMem(mtbl,&usedUsrMem);
		exit_spinlock(&physMemLock);
	}
	else if(freeKrnMem != NULL){
		mtbl = getFreeMem(&freeKrnMem);
		mtbl->pentry = pentry;
		mtbl->proc = get_current_task();
		addUsedMem(mtbl,&usedKrnMem);
		exit_spinlock(&physMemLock);
	}
	else if(usedUsrMem.next != &usedUsrMem){
		mtbl = getUsedMem(&usedUsrMem);
		old_proc = mtbl->proc;
		old_pentry = mtbl->pentry;
		mtbl->pentry = pentry;
		mtbl->proc = get_current_task();
		addUsedMem(mtbl,&usedUsrMem);
		exit_spinlock(&physMemLock);

		if(backupPage((uint)getAddrFromPhysTable(mtbl),old_proc,old_pentry) == -1){
			return NULL;
		}
	}
	else if(usedKrnMem.next != &usedKrnMem){
		mtbl = getUsedMem(&usedKrnMem);
		old_proc = mtbl->proc;
		old_pentry = mtbl->pentry;
		mtbl->pentry = pentry;
		mtbl->proc = get_current_task();
		addUsedMem(mtbl,&usedKrnMem);
		exit_spinlock(&physMemLock);

		if(backupPage((uint)getAddrFromPhysTable(mtbl),old_proc,old_pentry) == -1){
			return NULL;
		}
	}
	else{
		exit_spinlock(&physMemLock);
		return NULL;
	}

	return getAddrFromPhysTable(mtbl);
}


/*
 * ֤ͥϢ³꡼ڡƤ
 * parameters : ڡ
 * return : ƥɥ쥹 or failed=NULL
 */
STATIC void *allocMultiKernelPage(int num)
{
	void *rest;
	int cnt;
	uint maxmem;
	PHYS_MEM_TABL *p;
	int eflag;


	maxmem=(all_memory_size<KERNEL_DATA_END)?all_memory_size:KERNEL_DATA_END;
	p=(PHYS_MEM_TABL*)(PHYSICAL_PAGE_TABLE_ADD+maxmem/PAGE_SIZE*sizeof(PHYS_MEM_TABL))-1;
	rest=NULL;
	cnt=0;
	eflag = enterCli();
	enter_spinlock(&physMemLock);
	{
		for(;p>=(PHYS_MEM_TABL*)PHYSICAL_PAGE_TABLE_ADD;--p)
		{
			if(p->ref_count==0)
			{
				if(++cnt==num)
				{
					while(--cnt>=0)delFreeKrnLink(p+cnt);
					rest=getAddrFromPhysTable(p);
					break;
				}
			}
			else cnt=0;
		}
	}
	exit_spinlock(&physMemLock);
	exitCli(eflag);

	return rest;
}


/*
 * ꡼ڡơ֥
 */
STATIC void initPhysMemTable()
{
	PHYS_MEM_TABL *p = (PHYS_MEM_TABL*)PHYSICAL_PAGE_TABLE_ADD;
	int c_mtbl, last;


	// ǽ1Mbyteʬ꡼Ƥ롣
	for (c_mtbl = 0; c_mtbl < 0x100000 / PAGE_SIZE; ++c_mtbl){
		p[c_mtbl].ref_count = 1;
	}

	// Ĥե꡼ꤹ롣
	freeKrnMem = &p[c_mtbl];
	for (last = all_memory_size / PAGE_SIZE; c_mtbl < last; ++c_mtbl){
		p[c_mtbl].ref_count = 0;
		p[c_mtbl].heap_num = 0;
		p[c_mtbl].proc = NULL;
		p[c_mtbl].pentry = NULL;
		p[c_mtbl].next = &p[c_mtbl + 1];
	}
	p[--c_mtbl].next = NULL;

	// 桼ΰե꡼ꡣ
	if (getAddrFromPhysTable(&p[c_mtbl]) >= (void*)USER_BEG){
		freeUsrMem = getPhysTableFromAddr((void*)USER_BEG);
		(freeUsrMem-1)->next = NULL;
	}
	else{
		freeUsrMem = NULL;
	}

	/* ꡼ơ֥ʬ꡼ƤʲԲġˡ */
	last = ROUNDUP(PHYSICAL_PAGE_TABLE_ADD + all_memory_size / PAGE_SIZE * sizeof(PHYS_MEM_TABL), PAGE_SIZE) / PAGE_SIZE;
	for (c_mtbl = PHYSICAL_PAGE_TABLE_ADD / PAGE_SIZE; c_mtbl < last; ++c_mtbl){
		p[c_mtbl].ref_count = 1;
	}
	if (&p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE] == freeKrnMem){
		freeKrnMem=&p[last];
	}
	else{
		p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE-1].next = &p[last];
	}

	// Used link
	usedKrnMem.next = usedKrnMem.prev = &usedKrnMem;
	usedUsrMem.next = usedUsrMem.prev = &usedUsrMem;
}


/*
 * ʪ꡼¬ꤹ
 */
STATIC uint findAllMemsize()
{
	enum{EXIST_MEM_SIZE = 0x800000};		/* ꡼¬ñ */
	uint volatile *point;

	/* ꡼ñ̤Ȥ¬ꤹ*/
	for (point = (uint*)EXIST_MEM_SIZE-1; ; point += EXIST_MEM_SIZE / sizeof(uint)){
		*point = 0x5a5a5a5a;
		if (*point != 0x5a5a5a5a){
			break;
		}
		else{
			*point = 0xf0f0f0f0;
			if(*point != 0xf0f0f0f0){
				break;
			}
		}
	}

	return (all_memory_size = (uint)point - EXIST_MEM_SIZE + sizeof(uint));
}


/*
 *꡼ȥإåֹꤹ
 * parameters : ʪ꡼ɥ쥹,ȥإåֹ
 */
STATIC void setAllocNum(void *addr,int num)
{
	getPhysTableFromAddr(addr)->heap_num = num;
}


/*
 *꡼ȥإåֹ
 * parameters : ʪ꡼ɥ쥹
 * return : ȥإåֹ
 */
STATIC int getAllocNum(void *addr)
{
	return getPhysTableFromAddr(addr)->heap_num;
}


//================================== PUBLIC =============================================


// ʪ꡼
uint getMaxMemory()
{
	return all_memory_size;
}


/***********************************************************************************
 *
 * ꡼
 *
 ***********************************************************************************/


#define HEAP_NUM() (sizeof(heapHead) / sizeof(HEAP_HEAD))

/* ʬ꡼إå */
typedef struct MEM_HEAD{
	struct MEM_HEAD	*next;		/* ζ꡼Ƭ */
	int				size;		/* ƥ */
}MEM_HEAD;

/*
 * ҡץإå
 * Note! : "memTop"ΰ֤ɬ"MEM_HEAD""next"Ʊˤ뤳
 */
typedef struct{
	MEM_HEAD	*memTop;	/* ꡼Ƭ */
	uint		size;		/* ƥ */
	int			gate;		/* ԥåѥ */
}HEAP_HEAD;


//================================== PRIVATE ============================================


/*
 * ҡץإå
 */
static HEAP_HEAD heapHead[]={
	{NULL,0,     0},
	{NULL,0x10,  0},
	{NULL,0x20,  0},
	{NULL,0x40,  0},
	{NULL,0x80,  0},
	{NULL,0x100, 0},
	{NULL,0x200, 0},
	{NULL,0x400, 0},
	{NULL,0x800, 0},
	{NULL,0x1000,0},
};

/*
 * Хͤҡ׹¤ΥʥС
 */
static uchar heapNum1[]={
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
};
static uchar heapNum2[]={
	0,5,6,7,7,8,8,8,8,9,9,9,9,9,9,9,
	9,
};


/*
 * ҡץ롣
 * parameters : ׵᥵
 * return : ҡ׹¤ΥʥС
 */
STATIC INLINE int getHeapSize(size_t size)
{
	if(size>=0x100)
		return heapNum2[ROUNDUP(size,0x100)>>8];
	return heapNum1[size];
}


//================================== PUBLIC =============================================


/*
 * ׵᥵꡼ơ³֤
 * return : allocate memory or NULL
 */
void *kmallocSize(const uint i_size, uint *o_size)
{
	union{
		MEM_HEAD *head;
		uint ui;
	}mem, alloc;
	uint size;
	int eflag;
	int i;

	ASSERT(o_size != NULL);

	if (i_size == 0){
		*o_size = 0;
		return NULL;
	}

	if (i_size <= PAGE_SIZE){
		i = getHeapSize(i_size);

		eflag = enterCli();
		enter_spinlock(&heapHead[i].gate);
		{
			if (heapHead[i].memTop == NULL){
				/* 1ڡ꡼ݡ */
				mem.head = allocKernelPage();
				if (mem.head == NULL){
					exit_spinlock(&heapHead[i].gate);
					exitCli(eflag);
					
					return NULL;
				}

				/*
				 * Ȥaddress狼褦ˤ롣
				 */
				setAllocNum(mem.head, i);

				mem.head->next = NULL;
				mem.head->size = PAGE_SIZE;
				heapHead[i].memTop = mem.head;
			}

			mem.head = heapHead[i].memTop;
			mem.head->size -= heapHead[i].size;
			if (mem.head->size == 0)
				heapHead[i].memTop = mem.head->next;
		}
		exit_spinlock(&heapHead[i].gate);
		exitCli(eflag);

		alloc.ui = mem.ui + mem.head->size;
		
		*o_size = heapHead[i].size;
	}
	else{
		size = ROUNDUP(i_size,PAGE_SIZE);
		if ((alloc.head = allocMultiKernelPage(size / PAGE_SIZE)) == NULL){
			return NULL;
		}
		setAllocNum(alloc.head, HEAP_NUM() + size / PAGE_SIZE);

		*o_size = size;
	}

	return alloc.head;
}


/*
 * ׵᥵꡼Ƥ
 * parameters : Size by byte
 * return : allocate address or NULL
 */
void *kmalloc(size_t size)
{
	int realSize;
	return kmallocSize(size, &realSize);
}


// ꡼
// return : ꡼
uint kfree(void *ptr)
{
	union{
		MEM_HEAD *head;
		uint ui;
	}mem, free, prev, next;
	int eflag;
	uint i;

	if (ptr == NULL){
		return 0;
	}

	i = getAllocNum(ptr);
	if (i == 0){
#ifdef DEBUG
		printk("kfree() 0x%x did not allocated : call function=0x%x\n",ptr,*((uint*)&ptr - 1));
#endif
		return 0;
	}

	if (i < HEAP_NUM()){
		free.head = ptr;
#ifdef DEBUG
		/* Υå */
		mem.head = free.head;
		mem.ui &= heapHead[i].size - 1;
		if (mem.ui != 0)
		{
			printk("kfree() : 0x%x is no complete : call function=0x%x\n",free.head, *((uint*)&ptr - 1));
			return 0;
		}	
		// ȤȥڡեȤ򵯤ͤƤ
		memset(ptr, 0xf5, heapHead[i].size);
#endif
		eflag = enterCli();
		enter_spinlock(&heapHead[i].gate);
		{
			/* ꡼³󥯰֤򸡺 */
			mem.head = (MEM_HEAD*)&heapHead[i];
			for (;mem.head->next != NULL; mem.head = mem.head->next){
				if (free.head < mem.head->next){
					break;
				}
			}
			prev = mem;
#ifdef DEBUG
			if ((mem.head != (MEM_HEAD*)&heapHead[i]) && (free.ui < (mem.ui + mem.head->size)) ){
				printk("kfree() : 0x%x is already free,call from : 0x%x\n",free.head,*((uint*)&ptr - 1));
				test_mmFlag = 1;
				goto EXIT;
			}
#endif
			/* Υ꡼ȷҤ */
			next.head = prev.head->next;
			if ((next.ui == (free.ui + heapHead[i].size)) && ((next.ui / PAGE_SIZE) == (free.ui / PAGE_SIZE)) ){
				free.head->next = next.head->next;
				free.head->size = next.head->size + heapHead[i].size;
			}
			else{
				free.head->next = next.head;
				free.head->size = heapHead[i].size;
			}

			/* Ĥʤ꡼ڡˤʤäڡ */
			if (free.head->size == PAGE_SIZE){
				prev.head->next = free.head->next;
				unlinkPhysTable(free.head);
				goto EXIT;
			}

			/* Υ꡼ȷҤ */
			if (((prev.ui + prev.head->size) == free.ui) && ((prev.ui / PAGE_SIZE) == (free.ui / PAGE_SIZE)) ){
				prev.head->next = free.head->next;
				prev.head->size += free.head->size;
				
			}
			else{
				prev.head->next = free.head;
			}

			/* Ĥʤ꡼ڡˤʤäڡ */
			if (prev.head->size == PAGE_SIZE){
				for (mem.head = (MEM_HEAD*)&heapHead[i]; mem.head->next != prev.head; mem.head = mem.head->next);
				mem.head->next = free.head->next;
				unlinkPhysTable(prev.head);
			}
		}
EXIT:	exit_spinlock(&heapHead[i].gate);
		exitCli(eflag);
		
		return heapHead[i].size;
	}
	else{
		uint size = (i - HEAP_NUM()) * PAGE_SIZE;
		uint mem = (uint)ptr;

		for (i -= HEAP_NUM(); 0 < i ; --i){
			unlinkPhysTable((void*)mem);
			mem += PAGE_SIZE;
		}
		
		return size;
	}
}


/***********************************************************************************
 *
 * ꡼
 * ڡ礭Ȥ˻Ѥ
 *
 ***********************************************************************************/


/*
 * ꡼إå
 */
typedef struct{
	int len;
	char *mem[0];
}MEM_ARRAY_HEAD;


/*================================= Х ======================================*/


/*
 * 
 * إåΤߤƤ
 * return : ꡼إåݥ or NULL
 */
MEM_ARRAY *allocArray(size_t size)
{
	int len;
	MEM_ARRAY_HEAD *memArray;
	
	/* ꡼ݥڡñ̤ǳƤ */
	len = ROUNDUP_DIV(size,PAGE_SIZE);
	memArray = kmalloc(sizeof(MEM_ARRAY_HEAD) + len * sizeof(char*));
	if (memArray == NULL)
		return NULL;

	memArray->len = len;
	memset(memArray->mem,0,len * sizeof(char*));
	
	return (MEM_ARRAY*)memArray;
}


/*
 * 
 */
void freeArray(MEM_ARRAY *i_memArray)
{
	MEM_ARRAY_HEAD *memArray = (MEM_ARRAY_HEAD*)i_memArray;
	int i;
	
	/* ꡼γ */
	for (i = 0; i < memArray->len; ++i)
		if (memArray->mem[i] != NULL)
			unlinkPhysTable(memArray->mem[i]);
	kfree(memArray);
}


/*
 * Ƴ
 * return : ꡼إåݥ or NULL
 */
MEM_ARRAY *reallocArray(MEM_ARRAY *i_memArray,size_t size)
{
	MEM_ARRAY_HEAD *memArray = (MEM_ARRAY_HEAD*)i_memArray;
	MEM_ARRAY_HEAD *newMemArray;

	if (memArray->len * PAGE_SIZE < size)
	{
		newMemArray = (MEM_ARRAY_HEAD*)allocArray(size);
		if (newMemArray == NULL)
			return NULL;
		
		newMemArray->len = ROUNDUP_DIV(size,PAGE_SIZE);
		memcpy(newMemArray->mem,memArray->mem,memArray->len * sizeof(char*));
		memset(&newMemArray->mem[memArray->len],0,(newMemArray->len - memArray->len) * sizeof(char*));
		kfree(memArray);
		
		return (MEM_ARRAY*)newMemArray;
	}
	else
		return (MEM_ARRAY*)memArray;
}


/*
 * 񤭹
 * return : NOERR or error number
 */
int writeArray(MEM_ARRAY *i_memArray,const int i_offset,const size_t size,const void *i_buf)
{
	MEM_ARRAY_HEAD *memArray = (MEM_ARRAY_HEAD*)i_memArray;
	const char *srcBuf = i_buf;
	int offset,cpSize,restSize;
	int i;

#ifdef DEBUG
	/* 񤭹ߥγǧ */
	if (memArray->len * PAGE_SIZE < i_offset * size)
		return -EFBIG;
#endif

	restSize = size;
	offset = i_offset % PAGE_SIZE;
	for (i = i_offset / PAGE_SIZE;; ++i)
	{
		/* ꡼̤ʬƤ */
		if (memArray->mem[i] == NULL)
		{
			memArray->mem[i] = kmalloc(PAGE_SIZE);
			if (memArray->mem[i] == NULL)
				return -ENOMEM;
		}
		
		cpSize = (restSize <= PAGE_SIZE - offset)? restSize : PAGE_SIZE - offset;
		memcpy(memArray->mem[i] + offset,srcBuf,cpSize);
		restSize -= cpSize;
		if (restSize == 0)
			break;
		srcBuf += cpSize;
		offset = 0;
	}
	
	return NOERR;
}


/*
 * ԡ
 * return : NOERR or error number
 */
void copyArray(MEM_ARRAY *i_memArray,const int i_offset,const size_t size,void *o_buf)
{
	MEM_ARRAY_HEAD *memArray = (MEM_ARRAY_HEAD*)i_memArray;
	char *dstBuf = o_buf;
	int offset,cpSize,restSize;
	int i;

#ifdef DEBUG
	/* 񤭹ߥγǧ */
	if (memArray->len * PAGE_SIZE < i_offset * size)
	{
		printk("%s copyArray() Copy size is bigger!:offset=%d size=%d",__FILE__,i_offset,size);
		return;
	}
#endif

	restSize = size;
	offset = i_offset % PAGE_SIZE;
	for (i = i_offset / PAGE_SIZE;; ++i)
	{
		
		cpSize = (PAGE_SIZE - offset < restSize)? PAGE_SIZE - offset : restSize;
		if (memArray->mem[i] == NULL)
			/* ꡼̤ʬ0 */
			memset(dstBuf,0,cpSize);
		else
			memcpy(dstBuf,memArray->mem[i] + offset,cpSize);
		restSize -= cpSize;
		if (restSize == 0)
			break;
		dstBuf += cpSize;
		offset = 0;
	}
}


/***********************************************************************************
 *
 *ۥ꡼
 * ̵§
 *  ȤƤʤڡȥ꡼ɬꥢ롣
 *
 ***********************************************************************************/


enum{
	PAGE_DIR_SIZE=0x400000,		/* Page directory size */

	/* Page entry flag */
	PAGE_PRESEN=		0x1,	/* Is presence */
	PAGE_RW=			0x2,	/* Is read and write,not read only */
	PAGE_USER=			0x4,	/* Privilege is user,not supervisor */
	PAGE_CASH_DISABLE=	0x10,	/* Disable cash,not able cash */
	PAGE_4M=			0x80,	/* Page size is 4M,not 4K */

	/* ڡȥ꡼ΰѥե饰 */
	PT_COPY_ON_WRITE=0x200,		/* ԡ饤ȥե饰 */
};


/*============================ ѥ֥å᥽å ======================================*/


/*
 * ۥɥ쥹ڡǥ쥯ȥꥨȥ꡼ɥ쥹
 * parameters : ۥɥ쥹,ڡǥ쥯ȥꥢɥ쥹
 * return : ڡǥ쥯ȥꥨȥ꡼ɥ쥹
 */
STATIC INLINE uint *getPageDirEntryAddr(uint addr,uint *page_dir)
{
	return &page_dir[addr>>22];
}


/*
 * ۥɥ쥹ڡơ֥륨ȥ꡼ɥ쥹
 * parameters : ۥɥ쥹,ڡơ֥륢ɥ쥹
 * return : ڡơ֥륨ȥ꡼ɥ쥹
 */
STATIC INLINE uint *getPageEntryAddr(uint addr,uint *ptbl)
{
	return &ptbl[(addr>>12)&0x3ff];
}


/*
 * ڡǥ쥯ȥɤ߹ߤ
 * parameters : page directory address
 */
STATIC INLINE void flashPageDir(uint *pdir)
{
	asm volatile(
		"movl	%%eax,%%cr3"
		::"a"(pdir)
	);
}


/*
 * Ժߥڡɤ
 * parameters : 1 = ¸,0 = Ժ
 */
STATIC INLINE int isPagePresen(uint entry)
{
	return (entry & PAGE_PRESEN) != 0;
}

/*
 * ڡȥ꡼򥳥ԡ饤Ȥꤹ
 * parameters : page entry address
 */
STATIC INLINE void setCopyOnWrite(uint *pentry)
{
	*pentry |= PT_COPY_ON_WRITE;			/* ԡ饤ȥե饰ꤹ롣 */
	*pentry &= ~PAGE_RW;					/* ߶ػߤˤ롣 */
}

STATIC INLINE void setCopyOnWritePageTable(uint *pentry)
{
	*pentry |= PT_COPY_ON_WRITE;			/* ԡ饤ȥե饰ꤹ롣 */
}

/*
 * return : ꤵ줤 0 ʳ
 */
STATIC INLINE int isSetCopyOnWrite(uint pageTbl)
{
	return pageTbl & PT_COPY_ON_WRITE;
}

/*
 * ڡȥ꡼˥ڡ꡼Ƥ
 * return : 0 or error number
 */
STATIC int setPageMemory(uint fault_addr,MM_STRUCT *mm_struct)
{
	void *alloc_page;
	uint *dentry = getPageDirEntryAddr(fault_addr,mm_struct->pageDir);
	uint *pentry,entry;
	int rest;


	/* ڡơ֥γ */
	if(*dentry == 0){
		*dentry = (uint)allocKernelPage();
		if (*dentry == 0){
			return -ENOMEM;
		}
		memset ((void*)*dentry,0,PAGE_SIZE);
		*dentry |= PAGE_PRESEN | PAGE_RW | PAGE_USER;
	}

	pentry = getPageEntryAddr(fault_addr,(uint*)(*dentry & ~(PAGE_SIZE - 1)));
	
	/* ڡ꡼γ */
	alloc_page = allocUserPage(pentry);
	if (alloc_page == NULL){
		return -ENOMEM;
	}
	enter_spinlock(&mm_struct->pageDirGate);
	{
		/* Хååפ */
		entry = *pentry;
		if (entry != 0){
			rest = restorePage(pentry,alloc_page);
			if (rest != 0){
				exit_spinlock(&mm_struct->pageDirGate);
				unlinkPhysTable(alloc_page);
				return rest;
			}
		}

		*pentry = (uint)alloc_page | PAGE_PRESEN | PAGE_RW | PAGE_USER;
	}
	exit_spinlock(&mm_struct->pageDirGate);
	
	return 0;
}


/*
 * ԡ饤ȤΥڡȥ꡼˥ڡ꡼Ƥ
 * return : 0 or error number
 */
STATIC int setPageMemoryCopyOnWriteEntry(uint fault_addr,MM_STRUCT *mm_struct)
{
	void *alloc_page;
	uint *dentry = getPageDirEntryAddr(fault_addr,mm_struct->pageDir);
	uint *pentry = getPageEntryAddr(fault_addr,(uint*)(*dentry & ~(PAGE_SIZE - 1)));


	/* ʪ꡼ȥȤǧ */
	if(delAndGetPhysRefCount((void*)*pentry) > 1)
	{
		/*
		 * ڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤵƤϡڡơ֥Ƥ롣
		 */
		if((*dentry & PT_COPY_ON_WRITE) != 0)
		{
			if(delAndGetPhysRefCount((void*)*dentry) > 1)
			{
				alloc_page = allocKernelPage();
				if (alloc_page == NULL)
					return -ENOMEM;
				memcpy(alloc_page,(void*)(*dentry & ~(PAGE_SIZE - 1)),PAGE_SIZE);
				*dentry = ((*dentry & (PAGE_SIZE - 1)) | (uint)alloc_page) & ~PT_COPY_ON_WRITE;
				pentry = getPageEntryAddr(fault_addr,alloc_page);
			}
			else *dentry &= ~PT_COPY_ON_WRITE;
		}

		/* ʪڡơڡƤ򥳥ԡ롣 */
		alloc_page = allocUserPage(pentry);
		if (alloc_page == NULL)
			return -ENOMEM;
		memcpy(alloc_page,(void*)(*pentry&~(PAGE_SIZE-1)),PAGE_SIZE);
		*pentry = (uint)alloc_page | PAGE_PRESEN | PAGE_RW | PAGE_USER;
	}
	else
		*pentry = (*pentry & ~PT_COPY_ON_WRITE) | PAGE_RW;
	
	return 0;
}


/*
 * ڡȥ꡼ԡ饤Ȥɤ
 * return : 1 = yes or 0 = no
 */
STATIC int isCopyOnWrite(uint fault_addr,MM_STRUCT *mm_struct)
{
	uint *dentry = getPageDirEntryAddr(fault_addr,mm_struct->pageDir);
	uint *pentry = getPageEntryAddr(fault_addr,(uint*)(*dentry & ~(PAGE_SIZE - 1)));


	return (*pentry & PT_COPY_ON_WRITE) != 0;
}


//================================== PUBLIC =============================================


/*
 * Ƥɥ쥹κǸ
 * return : last allocate addrress
 */
uint getLastLinearAddr()
{
	return ((MM_STRUCT*)get_current_task()->mm_struct)->lastPageAddr;
}


/***********************************************************************************
 *
 *ڡХåå
 * ڡȥ꡼ΥХåå׻Υ쥤ȡ
 *  0bit=0,123bit=¸֥åֹ,2431bit=֥åȥ
 *
 ***********************************************************************************/


enum{
	PT_TYPE_PAGING = 0x9a,	/* ڡХååץǥХѡƥֹʲˡ */
	PB_START_SECTER = 2,	/* Хåå׳ϥ */
};


//================================== PRIVATE ============================================


/* ӥåȥޥåפǥХ֥ͤåΰ֤롣 */
static uchar emptyBlock[]={
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,0,
};
static uchar *pbBitMap;			/* PRIVATE,֥åӥåȥޥåס */
static int pbBitMapCurrent;		/* PRIVATE,ӥåȥޥåθߤΥХȰ֡ */
static int pbBitMapSize;		/* PRIVATE,ӥåȥޥåץ */
static int pbDin;				/* PRIVATE,ХååץǥХ inode */
static int pbSectors;			/* PRIVATE,ڡ/ */


/*
 * ڡХååפ롣
 * return : ֥å or failed=-1
 */
STATIC int getEmptyBackup()
{
	int bit;
	int i;


	i=pbBitMapCurrent;

	do
	{
		if(pbBitMap[i]!=0xff)
		{
			bit=emptyBlock[pbBitMap[i]];
			pbBitMap[i]|=1<<bit;
			pbBitMapCurrent=i;

			return (i * BYTE_BIT + bit) * pbSectors + PB_START_SECTER;
		}

		if(++i==pbBitMapSize)i=0;
	}while(i!=pbBitMapCurrent);

	return -1;
}


/*
 * ڡȥ꡼֥åֹ롣
 * parameters : page entry
 * return : block number
 */
STATIC INLINE uint getBlock(uint pentry)
{
	return (pentry&0xffffff)>>1;
}


/*
 * ڡȥ꡼˥֥åֹꤹ롣
 * parameters : page entry address,block number
 */
STATIC INLINE void setBlock(uint *pentry,uint block)
{
	*pentry&=0xff000000;
	*pentry|=block<<1;
}


/*
 * ֥å˥åȤ롣
 * parameters : block number
 */
STATIC INLINE void setBlockEmpty(uint pentry)
{
	int i;


	i=(getBlock(pentry)-PB_START_SECTER)/pbSectors;
	pbBitMap[i / BYTE_BIT] &= (uchar)~(1 << (i % BYTE_BIT));
}


//================================== PROTECTED ==========================================


/*
 * ХååץڡλȥȤ䤹
 *ԥޥ
 * parameters : page entry
 */
STATIC void incBackupCount(uint *pentry)
{
	union{
		uint ui;
		uchar uc[4];
	}value;


	value.ui = *pentry;
	++value.uc[3];
	*pentry = value.ui;
}


/*
 * ХååץڡλȥȤ򸺤餹
 *ԥޥ
 * parameters : page entry
 */
STATIC INLINE void decBackupCount(uint *pageEnt)
{
	union{
		uint ui;
		uchar uc[4];
	}value;


	value.ui = *pageEnt;
	if (value.uc[3] == 0)
		setBlockEmpty(*pageEnt);
}


/*
 * ꡼ڡХååפ
 * parameters : Хååʪɥ쥹,ץơ֥,ڡȥꥢɥ쥹
 * returns : 0 or Error number
 */
STATIC int backupPage(uint phaddr,PROC *proc,uint *pageEnt)
{
	int blk;
	size_t ioSize;

	enter_spinlock(&((MM_STRUCT*)proc->mm_struct)->pageDirGate);
	{
		/* Ǥ˥꡼ϳƤ롣 */
		if (((*pageEnt & PAGE_PRESEN) == 0) || (phaddr != (*pageEnt & ~(PAGE_SIZE - 1)))){
			goto EXIT;
		}

		/* page tableԺߤ */
		*pageEnt &= ~PAGE_PRESEN;

		/* ꤵץ¹ʤpage tableTBLեå夹 */
		if ((proc->cpu != get_current_cpu()) && (cputask[proc->cpu].current_task == proc)){
			issue_interrupt_to_cpu(proc->cpu,FLASH_PAGEDIR_VECT);
		}

		/* Store page. */
		if ((blk = getEmptyBackup()) == -1){
			goto ERR;
		}
		if (phaddr < KERNEL_END){
			if (write_direct(pbDin, (void*)phaddr, pbSectors, blk, &ioSize) != NOERR){
				goto ERR;
			}
			if (ioSize < pbSectors){
				goto ERR;
			}
		}
		else{
			uint *pdir;
			uint *pentry;
			uint tmp;
			int error = 0;

			pdir = ((MM_STRUCT*)get_current_task()->mm_struct)->pageDir;
			pentry = getPageEntryAddr(USER_BEG, (uint*)(*getPageDirEntryAddr(USER_BEG, pdir) & ~(PAGE_SIZE - 1)));
			tmp = *pentry;
			*pentry = phaddr | PAGE_PRESEN | PAGE_USER | PAGE_RW;
			flashPageDir(pdir);

			if (write_direct(pbDin, (void*)USER_BEG, pbSectors, blk, &ioSize) != NOERR){
				error = 1;
			}
			if (ioSize < pbSectors){
				error = 1;
			}

			*pentry = tmp;
			flashPageDir(pdir);
			if (error == 1){
				goto ERR;
			}
		}

		/* ХååץƥȤγơ */
		if (*pageEnt & PT_COPY_ON_WRITE){
			*pageEnt = 2;
		}
		else{
			*pageEnt = 1;
		}
		*pageEnt <<= 24;
		setBlock(pageEnt, blk);
	}
EXIT:
	exit_spinlock(&((MM_STRUCT*)proc->mm_struct)->pageDirGate);

	return 0;
ERR:
	*pageEnt |= PAGE_PRESEN;
	exit_spinlock(&((MM_STRUCT*)proc->mm_struct)->pageDirGate);

	return -1;
}


/*
 * Хååץڡ꡼᤹
 * parmeters : device block,memory buffer
 * return : 0 or error=-1
 */
STATIC int restorePage(uint *pentry, void *buf)
{
	size_t ioSize;
	int rest;
	
	/* ǥХɤ߹ߡ */
	rest = read_direct(pbDin, buf, pbSectors, getBlock(*pentry), &ioSize);
	if (rest != NOERR){
		return rest;
	}
	ASSERT(ioSize == pbSectors);

	/* ȥ󥿤򸺤餹 */
	decBackupCount(pentry);

	return 0;
}


/*
 * Хååץڡ꡼᤹
 * parmeters : device block,memory buffer
 * return : 0 or error number
 */
STATIC int getFromBackup(uint pentry,void *buf)
{
	size_t ioSize;
	int rest;
	
	/* ǥХɤ߹ߡ */
	rest = read_direct(pbDin, buf, pbSectors, getBlock(pentry), &ioSize);
	if (rest != NOERR){
		return rest;
	}
	ASSERT(ioSize == pbSectors);

	return 0;
}


//================================== PUBLIC =============================================


/*
 * ڡХååѥǥХޥȤ
 * parameters : device path
 * return : error number
 */
int initBackupDev(const char *dev_path)
{
	DEV_STAT dev_stat;
	int rest;

	/* Device open. */
	rest = mountPageBackupDev(dev_path, (void**)&pbDin);
	if (rest < 0){
		return rest;
	}

	/* ѡƥ󥿥פγǧ */
	rest = get_devstat(pbDin, &dev_stat);
	if (rest < 0){
		return rest;
	}
	if (dev_stat.prt_type != PT_TYPE_PAGING){
		return -ENODEV;
	}
	pbSectors = PAGE_SIZE / dev_stat.sect_size;

	/* ӥåȥޥåפγơ */
	pbBitMapSize = (dev_stat.all_sect - PB_START_SECTER) / pbSectors / BYTE_BIT;
	if ((pbBitMap = (char*)allocMultiKernelPage(ROUNDUP_DIV(pbBitMapSize, PAGE_SIZE))) == NULL){
		return -ENOMEM;
	}
	memset(pbBitMap, 0, pbBitMapSize);
	pbBitMapCurrent = 0;

	return NOERR;
}


/***********************************************************************************
 *
 * ڡؿ
 *
 * ڡȤξ
 * ȥȤǤ뤳
 *
 * 桼å
 *  0xfebfffff 顼ʥС
 *  0xfebffffb Ķѿ
 *                 
 *               
 *                 
 *             Ķѿɥ쥹
 *             ɥ쥹
 *             Ķѿɥ쥹ݥ
 *             ɥ쥹ݥ
 *             
 *
 ***********************************************************************************/


//================================== PRIVATE ============================================


// ڡƤƿƥץΥڡ򥳥ԡ
// return : 0 ro error number
STATIC int copyKernelPage(uint *parentPageDir, uint *pageDir, void **o_kernelStack)
{
	void *kernelStack;
	uint *kStackPageTbl;

	// ƤΥڡǥ쥯ȥҤ˥ԡ
	memcpy(pageDir, parentPageDir, PAGE_SIZE);

	// ͥ륹åƤ
	kStackPageTbl = allocKernelPage();
	if (kStackPageTbl == NULL){
		return -ENOMEM;
	}
	memset(kStackPageTbl, 0, PAGE_SIZE);
	pageDir[KERNEL_STACK_BEG / PAGE_DIR_SIZE] = (uint)kStackPageTbl | PAGE_PRESEN | PAGE_RW;
	kernelStack = allocKernelPage();
	if (kernelStack == NULL){
		unlinkPhysTable(kStackPageTbl);
		return -ENOMEM;
	}
	kStackPageTbl[PAGE_SIZE / sizeof(uint) - 1] = (uint)kernelStack | PAGE_PRESEN | PAGE_RW;

	*o_kernelStack = kernelStack;

	return 0;
}


// ͥ륹åɺǥ桼ڡ
static void initUserPage(MM_STRUCT *mmStruct)
{
	// ڡǥ쥯ȥν
//	memset(&mmStruct->pageDir[USER_BEG / PAGE_DIR_SIZE], 0, PAGE_SIZE - (USER_BEG / PAGE_DIR_SIZE) * sizeof(uint));
	
	// ꡼¤Τν
	mmStruct->lastPageAddr = USER_BEG;
	mmStruct->firstStackAddr = USER_END;
}


// 桼ڡƤƿƥץΥڡ򥳥ԡ
// return : 0 ro error number
STATIC int copyUserPage(MM_STRUCT *parentMmStruct, MM_STRUCT *mmStruct)
{
	uint *parentPageDir = parentMmStruct->pageDir;
	uint *pageDir = mmStruct->pageDir;
	uint *parentPageTbl;
	void *userStack;
	uint *pageTbl;
	int lastDir,firstPage;
	int c_dir,c_page;
	int rest;

	/*
	 * Userΰ򥳥ԡ饤Ȥꤹ롣
	 * ƤΥڡơ֥륨ȥ꡼񤭹߲Ĥʤ顢񤭹ԲĤˤƥԡ饤ȥե饰ꤹ롣
	 * ҤΥڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤹ롣
	 * 桼åΤڡơ֥ȥ桼åڡϿ˳Ƥ롣
	 */
	// 桼ƥȥǡ饹ȥڡǥ쥯ȥꥤǥå
	lastDir = ROUNDUP_DIV(parentMmStruct->lastPageAddr, PAGE_DIR_SIZE);
	for (c_dir = USER_BEG / PAGE_DIR_SIZE,c_page = 0; c_dir < lastDir; ++c_dir){
		if (pageDir[c_dir] == 0){
			continue;
		}

		/* ڡȥ꡼˥ԡ饤Ȥꤹ */
		parentPageTbl = (uint*)(pageDir[c_dir] & ~(PAGE_SIZE - 1));
		for (c_page = 0; c_page < PAGE_SIZE / sizeof(uint); ++c_page){
			if (parentPageTbl[c_page] == 0){
				continue;
			}

			if (isPagePresen(parentPageTbl[c_page])){
				setCopyOnWrite(&parentPageTbl[c_page]);
				linkPhysTable((void*)(parentPageTbl[c_page] & ~(PAGE_SIZE - 1)));
			}
			else{
				incBackupCount(&parentPageTbl[c_page]);		/* Хåå */
			}
		}

		/* ǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ΩƤ롣 */
		setCopyOnWritePageTable(&pageDir[c_dir]);
		setCopyOnWritePageTable(&parentPageDir[c_dir]);
		linkPhysTable((void*)(pageDir[c_dir] & ~(PAGE_SIZE - 1)));
	}

	mmStruct->lastPageAddr = parentMmStruct->lastPageAddr;

	/*
	 * 桼åγ
	 * Ƥϥ桼åƬ桼åǸޤ
	 */
	firstPage = (parentMmStruct->firstStackAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
	for (c_dir = parentMmStruct->firstStackAddr / PAGE_DIR_SIZE; c_dir < USER_ESP_BEG / PAGE_DIR_SIZE; ++c_dir){
		if (pageDir[c_dir] == 0){
			continue;
		}

		parentPageTbl = (uint*)(pageDir[c_dir] & ~(PAGE_SIZE - 1));
		pageTbl = allocKernelPage();
		if (pageTbl == NULL){
			rest = -ENOMEM;
			goto ERR;
		}
		pageDir[c_dir] = (uint)pageTbl | PAGE_PRESEN | PAGE_RW | PAGE_USER;
		memset(pageTbl, 0, PAGE_SIZE);
		
		for (c_page = firstPage; c_page < PAGE_SIZE / sizeof(uint); ++c_page){
			if (parentPageTbl[c_page] == 0){
				continue;
			}

			userStack = allocUserPage(&pageTbl[c_page]);
			if (userStack == NULL){
				rest = -ENOMEM;
				goto ERR;
			}
			pageTbl[c_page] = (uint)userStack | PAGE_PRESEN | PAGE_RW | PAGE_USER;
			if (isPagePresen(parentPageTbl[c_page])){
				memcpy(userStack,(void*)(parentPageTbl[c_page] & ~(PAGE_SIZE - 1)), PAGE_SIZE);
			}
			else{
				rest = getFromBackup(parentPageTbl[c_page], userStack);
				if (rest < 0){
					goto ERR;
				}
			}
		}
		firstPage = 0;
	}
	mmStruct->firstStackAddr = parentMmStruct->firstStackAddr;

	return 0;
ERR:
	for (c_dir = USER_ESP_BEG / PAGE_DIR_SIZE - 1; (pageDir[c_dir] != 0) && (isSetCopyOnWrite(pageDir[c_dir]) == 0); --c_dir){
		pageTbl = (uint*)(pageDir[c_dir] & ~(PAGE_SIZE - 1));
		for (c_page = PAGE_SIZE / sizeof(uint) - 1; (0 <= c_page) && (pageTbl[c_page] != 0); --c_page){
			unlinkPhysTable((void*)(pageTbl[c_page] & ~(PAGE_SIZE - 1)));
		}
		unlinkPhysTable(pageTbl);
	}
	return rest;
}


/*
 * ڡȥڡơ֥ڡñ̤ǳ롣
 * ̷
 * 	桼ΥƥȡǡڡϾ롣
 * 	桼åϾ˥åƬڡ鳫롣
 * 	ͥ륹åϾ롣
 * ̥ѥ᡼
 * 	꡼¤,ڡեȥɥ쥹,ڡ饹ȥɥ쥹
 */
STATIC void releasePage(MM_STRUCT *mms, uint firstAddr, uint lastAddr)
{
	uint *pageDir = mms->pageDir;
	uint *pageTbl;
	int lastDir;
	int limDir;
	int firstPage;
	int lastPage;
	int c_dir,c_page;


	enter_spinlock(&mms->pageDirGate);
	{
		lastDir = ROUNDUP_DIV(lastAddr,PAGE_DIR_SIZE);
		limDir = lastAddr / PAGE_DIR_SIZE;
		firstPage = (firstAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
		for (c_dir = firstAddr / PAGE_DIR_SIZE; c_dir < lastDir; ++c_dir){
			if (pageDir[c_dir] == 0){
				continue;
			}

			pageTbl = (uint*)(pageDir[c_dir] & ~(PAGE_SIZE - 1));
	
			/* ڡȥ꡼γ */
			if (c_dir == limDir){
				lastPage = ROUNDUP_DIV((lastAddr & (PAGE_DIR_SIZE - 1)),PAGE_SIZE);
			}
			else{
				lastPage = PAGE_SIZE / sizeof(uint);
			}
			for (c_page = firstPage; c_page < lastPage; ++c_page){
				if (pageTbl[c_page] == 0){
					continue;
				}

				/* ڡ¸ߤ */
				if (pageTbl[c_page] & PAGE_PRESEN){
					unlinkPhysTable((void*)pageTbl[c_page]);
				}
				/* ڡХååפƤ */
				else{
					decBackupCount(&pageTbl[c_page]);
				}
			}
			
			/* ڡȥ꡼Υꥢ */
			if (isSetCopyOnWrite(pageDir[c_dir]) == 0){
				for (c_page = firstPage; c_page < lastPage; ++c_page){
					pageTbl[c_page] = 0;
				}
			}

			firstPage = 0;

			/*
			 * ơ֥륨ȥ꡼ڡǥ쥯ȥⳫ롣
			 */
			if ((lastAddr == mms->lastPageAddr) || (lastPage == PAGE_SIZE / sizeof(uint))){
				unlinkPhysTable((void*)pageDir[c_dir]);
				pageDir[c_dir] = 0;
			}
		}
	}
	exit_spinlock(&mms->pageDirGate);
}


/*
 * δĶѿХȿ׻
 * parameters : ,Ķѿ,ȥХåե
 * return : Хȿ
 */
STATIC int calcArgLen(char **argv,char **envp,int *argc,int *envc)
{
	int size=0;
	int i;


	for (i = 0; argv[i] != NULL; ++i)
		size += strlen(argv[i]) + 1;			/*  */
	size += (i + 1) * sizeof(char*);			/* ɥ쥹󥵥 */
	size += sizeof(char**);						/* ɥ쥹ݥ󥿡 */
	*argc = i;

	for (i = 0; envp[i] != NULL; ++i)
		size += strlen(envp[i]) + 1;			/* Ķѿ */
	size += (i + 1) * sizeof(char*);			/* Ķѿɥ쥹󥵥 */
	size += sizeof(char**);						/* Ķѿɥ쥹ݥ󥿡 */
	*envc = i;

	return ROUNDUP(size+sizeof(int),sizeof(int));		/* +argc. */
}


/*
 * ʸ򥳥ԡʸ󥵥+1֤
 * parameters : ԡХåե,ԡʸ
 * return : ʸ󥵥
 */
STATIC INLINE int cpystr(char *s1,const char *s2)
{
	int i;

	i=0;
	while((s1[i]=s2[i])!='\0')++i;

	return i+1;
}


//================================== PUBLIC =============================================


/*
 * ƥץΥ꡼ƥȤ򥳥ԡ
 * parameters : isKernelThreadˤϥͥ륹åɤȤ"0"ʳꤹ
 * return : New MM_STRUCT address or error=NULL
 */
int forkPage(MM_STRUCT *parentMmStruct, int isKernelThread, void **o_mmStruct, void **o_kernelStack)
{
	uint *pageDir;
	MM_STRUCT *mmStruct;
	int rest;

	mmStruct = kmalloc(sizeof(MM_STRUCT));
	if (mmStruct == NULL){
		return -ENOMEM;
	}
	mmStruct->pageDirGate = 0;

	pageDir = allocKernelPage();
	if (pageDir == NULL){
		kfree(mmStruct);
		return -ENOMEM;
	}
	mmStruct->pageDir = pageDir;

	// ͥڡ򥳥ԡ
	rest = copyKernelPage(parentMmStruct->pageDir, pageDir, o_kernelStack);
	if (rest < 0){
		goto  ERR;
	}

	if (isKernelThread != 0){
		// 桼ڡ򥯥ꥢ
		initUserPage(mmStruct);
	}
	else{
		enter_spinlock(&parentMmStruct->pageDirGate);
		{
			// 桼ڡ򥳥ԡ
			rest = copyUserPage(parentMmStruct, mmStruct);
			if (rest < 0){
				exit_spinlock(&parentMmStruct->pageDirGate);
				goto  ERR;
			}
		}
		exit_spinlock(&parentMmStruct->pageDirGate);
	}
	
	/* ڡǥ쥯ȥ򹹿롣 */
	flashPageDir(parentMmStruct->pageDir);

	*o_mmStruct = mmStruct;
	
	return 0;
ERR:
	kfree(mmStruct);
	unlinkPhysTable(pageDir);
	return rest;
}


/*
 * ¹ԥե꡼˥ɤ
 * EXEC_FDݥ󥿤NULLʤ꡼0ꥢ롣
 * ɲͽ굡ǽ
 *  Ǥ˥ɺѤƱ¹ԥեɤ߼ꥻơߥ򥳥ԡ饤Ȥˤ롣
 * parametersEXEC_FDݥ󥿡ƥХȿɥХȿɳϥ˥ɥ쥹ڡ°ɹߤΤ=LB_R,ɤ߽=LB_WR
 * return : 0 or error=-1
 */
int loadBinary(EXEC_FD *open_f,size_t size,size_t load_size,uint address,int attribute)
{
	void *page;
	uint *pdir;
	uint *ptbl;
	uint *pentry;
	uint addr,last;
	MM_STRUCT *mms = (MM_STRUCT*)get_current_task()->mm_struct;


	pdir = mms->pageDir;
	last = address + size;

/*	enter_spinlock(&mms->pageDirGate);*/
	{
		/* ɥʬ꡼Ƥ롣 */
		for(addr=address;addr<last;addr+=PAGE_SIZE)
		{
			if((ptbl=(uint*)(*getPageDirEntryAddr(addr,pdir)&~(PAGE_SIZE-1)))==NULL)
			{
				/* ڡơ֥γơ */
				if((ptbl = allocKernelPage()) == NULL)
					goto ERR;
				memset(ptbl,0,PAGE_SIZE);
				*getPageDirEntryAddr(addr,pdir)=(uint)ptbl|PAGE_PRESEN|PAGE_USER|PAGE_RW;
			}

			/* ꡼°ꤹ롣 */
			pentry=getPageEntryAddr(addr,ptbl);
			if ((page = allocUserPage(pentry))==NULL)goto ERR;
			*pentry=(uint)page|PAGE_PRESEN|PAGE_USER|PAGE_RW;
		}
	}
/*	exit_spinlock(&mms->pageDirGate);*/

	/* ڡǥ쥯ȥ򹹿롣 */
	flashPageDir(pdir);

	/* ե뤫꡼ɤ߹ࡣ */
	if (exec_read(open_f, (void*) address, load_size) != load_size) {
		return -1;
	}
	memset((char*)address+load_size,0,size-load_size);

	/* ڡ°ɹߤʤꤷľ */
	if(attribute==LB_R)
	{
		for(addr=address;addr<last;addr+=PAGE_SIZE)
		{
			ptbl=(uint*)(*getPageDirEntryAddr(addr,pdir)&~(PAGE_SIZE-1));
			*getPageEntryAddr(addr,ptbl)&=~PAGE_RW;
		}

		/* ڡǥ쥯ȥ򹹿롣 */
		flashPageDir(pdir);
	}

	/* 饹ȥڡɥ쥹򹹿롣 */
	if (mms->lastPageAddr < last)
		mms->lastPageAddr = ROUNDUP(last,PAGE_SIZE);

	return 0;

ERR:
/*	exit_spinlock(&mms->pageDirGate);*/

	return -1;
}


/*
 * 桼åꤹ
 * parameters : ,Ķѿ
 * return : åƬɥ쥹
 */
uint setUserStack(char **argv,char **envp)
{
	void *buf;
	uint stack;
	char *str;
	char *tmp=NULL;
	uint diff;
	int argSize;
	int argc,envc;
	uint esp;
	MM_STRUCT *mms = (MM_STRUCT*)get_current_task()->mm_struct;
	int i;


	/* NULLʤ鲾Ϳ롣 */
	if (argv == NULL){
		argv = &tmp;
	}
	if (envp == NULL){
		envp=&tmp;
	}

	/* "sizeof(SYS_INFO)+sizeof(int)"ϥƥǼѤmain()Υ꥿󥢥ɥ쥹Ǽѡ */
	argSize = calcArgLen(argv,envp,&argc,&envc);
	if (PAGE_SIZE < argSize + sizeof(SYS_INFO) + sizeof(int)){
		WARNING(0);
		return 0;
	}

	buf = kmalloc(argSize + sizeof(SYS_INFO) + sizeof(int));
	if(buf == NULL){
		return 0;
	}
	diff = USER_ESP_BEG - (uint)buf - (argSize + sizeof(SYS_INFO));
	stack = (uint)buf;

	*(int*)stack = argc;														/* argc. */
	stack += sizeof(int);
	*(uint*)stack = stack + sizeof(char**) * 2 + diff;							/* argv. */
	stack += sizeof(char**);
	*(uint*)stack = stack + sizeof(char**) + sizeof(char*) * (argc + 1) + diff;	/* envp. */
	stack += sizeof(char**);

	str = (char*)((char**)stack + (argc + envc + 2));

	/* argvΥԡ */
	for(i = 0; i < argc; ++i){
		((char**)stack)[i] = str + diff;
		str += cpystr(str,argv[i]);
	}
	((char**)stack)[i] = NULL;
	stack += sizeof(char*) * (i + 1);

	/* envpΥԡ */
	for(i = 0; i < envc; ++i){
		((char**)stack)[i] = str + diff;
		str += cpystr(str,envp[i]);
	}
	((char**)stack)[i] = NULL;

	/* Хåե饹å˥ԡ */
	memcpy((void*)(USER_ESP_BEG - argSize - sizeof(SYS_INFO)), buf, argSize);

	kfree(buf);

	/* esp */
	esp = USER_ESP_BEG - argSize - sizeof(SYS_INFO) - sizeof(int);

	/* ʹߤΥåڡ */
	releasePage(mms, mms->firstStackAddr, ROUNDDOWN(esp,PAGE_SIZE));

	/* ƬΥåɥ쥹ꤹ */
	mms->firstStackAddr = ROUNDDOWN(esp,PAGE_SIZE);

	return esp;
}


/*
 * 桼ΥƥȤȥǡڡ롣
 * parameters : ꡼¤
 */
void releaseUserPage(void *mm_struct)
{
	MM_STRUCT *mms = (MM_STRUCT*)get_current_task()->mm_struct;


	releasePage(mms,USER_BEG,mms->lastPageAddr);
}


/*
 * 桼Υͥڡȥڡǥ쥯ȥ
 * parameters : ꡼¤
 */
void releasePageDir(void *mm_struct)
{
	MM_STRUCT *mms = mm_struct;
	
	/* 桼ƥȡǡڡ롣 */
	releasePage(mms,USER_BEG,mms->lastPageAddr);

	/* 桼å롣 */
	releasePage(mms,mms->firstStackAddr,USER_END);

	/* ͥ륹åڡ롣 */
	releasePage(mm_struct,KERNEL_STACK_BEG,KERNEL_END);

	/* ڡǥ쥯ȥ롣 */
	unlinkPhysTable(mms->pageDir);

	kfree(mm_struct);
}


/*
 * ڡեȽ
 * todo
 *  桼åڡԺߤνθľ(¤ߤ)
 * parameters : page fault address,Exception frame
 */
STATIC void printContext(uint errnum,uint addr,uint eip,uint cs,uint esp,uint ss)
{
#ifdef DEBUG	
	printSyscallEntry(1);
#endif
	if(cs == KERNEL_CODE_DES){
		printk("error=%x fault=%x eip=%x cs=%x process=%x\n",
		        errnum,addr,eip,cs,get_current_task());
		decrementNest();
	}
	else{
		printk("error=%x fault=%x eip=%x cs=%x esp=%x ss=%x process=%x\n",
		        errnum,addr,eip,cs,esp,ss,get_current_task());
	}
}


void pageFault(INTERRUPT_FRAME frame)
{
	/* 顼ɥӥåȥޥ */
	enum{
		PRESEN		= 1,
		RW_MODE		= 2,
		USER_MODE	= 4,
		RSVBIT		= 8,
	};
	MM_STRUCT *mm_struct = get_current_task()->mm_struct;
	int kernelAreaFault,userAreaFault;
	int rest;
	uint faultAddr = getFualtAddr();

	sti();

	/* 桼øڡȿ */
	kernelAreaFault = (faultAddr < USER_BEG  ) ||
	                  (IOMAP_BEG <= faultAddr);
	userAreaFault = (mm_struct->lastPageAddr < faultAddr                  ) &&
	                (faultAddr < mm_struct->firstStackAddr - PAGE_SIZE * 2);
	if (kernelAreaFault || userAreaFault){
		/* 桼ʥϥɥ餫ξ硣 */
		if (faultAddr == (uint)returnUserHandler){
			decrementNest();
			returnUserHandler();
		}
		printk("Page privilege violation!\n");
		printContext(frame.error,faultAddr,frame.eip,frame.cs,frame.user_esp,frame.user_ss);
		forceSendSignal(get_current_task(), SIGSEGV, TASK_SIGNAL_WAIT);
		return;
	}

	/* ڡԺ */
	if ((frame.error & PRESEN) == 0){
		/* ڡȥ꡼˥ڡ꡼Ƥ */
		rest = setPageMemory(faultAddr,mm_struct);
		if (rest != 0)
		{
			printk("error code = %d ",rest);
			WARNING(0);
			forceSendSignal(get_current_task(), SIGSEGV, TASK_SIGNAL_WAIT);
			return;
		}
		else{
			/* Ƭɥ쥹ι */
			if ((mm_struct->firstStackAddr - PAGE_SIZE * 2 <= faultAddr) &&
			    (faultAddr < mm_struct->firstStackAddr                 )    ){
				mm_struct->firstStackAddr = ROUNDDOWN(faultAddr,PAGE_SIZE);
			}
		}
	}
	else{
		/* ԡ饤Ȥɤ */
		if(isCopyOnWrite(faultAddr,mm_struct)){
			/* ԡ饤ȤΥڡȥ꡼˥ڡ꡼Ƥ */
			rest = setPageMemoryCopyOnWriteEntry(faultAddr,mm_struct);
			if (rest != 0){
				WARNING(0);
				forceSendSignal(get_current_task(), SIGSEGV, TASK_SIGNAL_WAIT);
				return;
			}
		}
		/* ڡ񤭹߰ȿ */
		else{
			printk("\nRead only page violation!\n");
			printContext(frame.error,faultAddr,frame.eip,frame.cs,frame.user_esp,frame.user_ss);
			forceSendSignal(get_current_task(), SIGSEGV, TASK_SIGNAL_WAIT);
			return;
		}
	}

	/* TBL򹹿롣 */
	flashPageDir(mm_struct->pageDir);
	
	return;
}


/*
 * 桼Хåեɥ쥹å
 * Ūϥͥ˲ʤ褦ˤ뤳Ȥȡͥ㳰ȯ
 * ꡼꡼򵯤Τɤȡ
 * return : NOERR or ERR
 */
int checkMem(const void *memory,size_t size)
{
	int kernelArea,noAllocArea;
	const char *mem = memory;
	MM_STRUCT *mm_struct = get_current_task()->mm_struct;


	kernelArea = ((uint)mem < USER_BEG         ) ||
	             (IOMAP_BEG <= (uint)mem       ) ||
	             (IOMAP_BEG < (uint)mem + size);
	noAllocArea = ((uint)mem < mm_struct->firstStackAddr - PAGE_SIZE) &&
	              (mm_struct->lastPageAddr +1 < (uint)mem + size   );
	if (kernelArea || noAllocArea){
		return ERR;
	}
	else{
		return NOERR;
	}
}


/*
 * ڡǥ쥯ȥɤ߹ߤ
 * parameters : memory manage structure
 */
void updateVm(void *mm_struct)
{
	flashPageDir(((MM_STRUCT*)get_current_task()->mm_struct)->pageDir);
}


/*
 * ڡǥ쥯ȥꥢɥ쥹
 * return : page directory address
 */
uint *getPageDir()
{
	return ((MM_STRUCT*)get_current_task()->mm_struct)->pageDir;
}


/*
 * 桼ΰ衦ͥ륹åɥ쥹ʪɥ쥹
 */
uint getPhysicalFromLogicalAddr(PROC *proc, uint logicalAddr)
{
	MM_STRUCT *mmStruct = proc->mm_struct;
	uint *pageTbl = (uint*)(mmStruct->pageDir[logicalAddr / PAGE_DIR_SIZE] & ~(PAGE_SIZE - 1));
	
	if (pageTbl == NULL){
		return 0;
	}
	else{
		uint pageEntry = pageTbl[(logicalAddr % PAGE_DIR_SIZE) / PAGE_SIZE];
		
		if (pageEntry & PAGE_PRESEN){
			 return (pageEntry & ~(PAGE_SIZE - 1)) + (logicalAddr % PAGE_SIZE);
		}
		else{
			return 0;
		}
	}
}


// 桼ϥɥ˰ܹԤ뤿ᥫͥ륹åȥ桼åؤ롢"doSigHandler"ƤФ롣
// return : NOERR or error number
int doUserHandler(int sigNum, SIG_ACTION sigaction)
{
	uint *kernelPageTbl;
	uint *userPageTbl;
	uint *kernelStk;
	uint *userStk;
	uint userEsp;
	PROC *proc = get_current_task();
	MM_STRUCT *mmStruct = (MM_STRUCT*)proc->mm_struct;
	int emptyUser;
	int emptykernel;
	int error = NOERR;

	// ͥ륹åȥ桼åΰݤ롣
	kernelStk = allocKernelPage();
	if (kernelStk == NULL){
		return -ENOMEM;
	}
	userPageTbl = (uint*)(*getPageDirEntryAddr(USER_ESP_BEG - 1, mmStruct->pageDir) & ~(PAGE_SIZE - 1));
	userStk = allocUserPage(&userPageTbl[PAGE_SIZE / sizeof(uint) - 1]);
	if (userStk == NULL){
		unlinkPhysTable(kernelStk);
		return -ENOMEM;
	}

	// 桼åΥƥȤꤹ롣
	userStk[PAGE_SIZE / sizeof(uint) - 1] = sigNum;
	userStk[PAGE_SIZE / sizeof(uint) - 2] = (uint)returnUserHandler;
	userEsp = USER_ESP_BEG - (sizeof(uint) * 2);
	
	// 桼åڡؤ롣
	for (emptyUser = PAGE_SIZE / sizeof(uint) - 2; userPageTbl[emptyUser] != 0; --emptyUser){
		if (emptyUser <= 0){
			error = -ENOSPC;
			goto ERR;
		}
	}
	userPageTbl[emptyUser] = userPageTbl[PAGE_SIZE / sizeof(uint) - 1];
	userPageTbl[PAGE_SIZE / sizeof(uint) - 1] = (uint)userStk | PAGE_PRESEN | PAGE_RW | PAGE_USER;
	// ڡܤ߶ػߤˤƥڡեȤ򵯤褦ˤ롣
	userPageTbl[PAGE_SIZE / sizeof(uint) - 2] &= ~PAGE_RW;

	// ͥ륹åڡζ˸ߤΥڡ򤹤롣
	kernelPageTbl = (uint*)(*getPageDirEntryAddr(KERNEL_ESP_BEG - 1, mmStruct->pageDir) & ~(PAGE_SIZE - 1));
	for (emptykernel = PAGE_SIZE / sizeof(uint) - 2; kernelPageTbl[emptykernel] != 0; --emptykernel){
		if (emptykernel <= 0){
			error = -ENOSPC;
			goto ERR;
		}
	}
	kernelPageTbl[emptykernel] = kernelPageTbl[PAGE_SIZE / sizeof(uint) - 1];

	// 桼ϥɥذܹԤ롣
	callUserHandler((uint)kernelStk | PAGE_PRESEN | PAGE_RW, &kernelPageTbl[PAGE_SIZE / sizeof(uint) - 1],
		sigaction, userEsp, KERNEL_ESP_BEG - FPU_SAVE_SIZE - (PAGE_SIZE / sizeof(uint) - 1 - emptykernel) * PAGE_SIZE, &proc->espBack);

	// 桼åڡܤ߲ǽ᤹
	userPageTbl[PAGE_SIZE / sizeof(uint) - 2] |= PAGE_RW;
	// 桼åڡ᤹
	userPageTbl[PAGE_SIZE / sizeof(uint) - 1] = userPageTbl[emptyUser];
	userPageTbl[emptyUser] = 0;
	
	kernelPageTbl[emptykernel] = 0;
ERR:
	unlinkPhysTable(kernelStk);
	unlinkPhysTable(userStk);

	return error;
}


// ͥ륹å򸵤ᤷ"callUserHandler"ƤӽФ롢"pageFault"ƤФ롣
void returnUserHandler()
{
	uint *kernelPageTbl;
	PROC *proc = get_current_task();
	MM_STRUCT *mmStruct = (MM_STRUCT*)proc->mm_struct;
	int empty;

	// ͥ륹åڡõ
	kernelPageTbl = (uint*)(*getPageDirEntryAddr(KERNEL_ESP_BEG - 1, mmStruct->pageDir) & ~(PAGE_SIZE - 1));
	for (empty = PAGE_SIZE / sizeof(uint) - 2; (kernelPageTbl[empty] != 0) && (0 < empty); --empty){;
	}

	returnCallUserHandler(proc->espBack, kernelPageTbl[empty + 1], &kernelPageTbl[PAGE_SIZE / sizeof(uint) - 1]);

	// ˤäʤϤ
	ASSERT(0);
}


/*
 * ưΥͥڡơ֥
 * return : MM_STRUCTɥ쥹 or error=NULL
 */
void *initPaging()
{
	void *stack;/*,*user_page;*/
	uint *pdir,*ptbl;
	MM_STRUCT *mstruct;
	int i;


	/* ͥڡǥ쥯ȥ */
	if((pdir=(uint*)allocKernelPage())==NULL)return NULL;
	memset(pdir,0,PAGE_SIZE);
	for(i=0;i<KERNEL_STACK_BEG/PAGE_DIR_SIZE;++i)
		pdir[i]=i*PAGE_DIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M;

	/* ͥ륹åڡƤ */
	if((ptbl=(uint*)allocKernelPage())==NULL)return NULL;
	memset(ptbl,0,PAGE_SIZE);
	pdir[KERNEL_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW;
	if((stack=allocKernelPage())==NULL)return NULL;
	ptbl[PAGE_SIZE/sizeof(uint)-1]=(uint)stack|PAGE_PRESEN|PAGE_RW;

	/* ꡼ޥåץIOڡѥǥ쥯ȥ */
	for(i=IOMAP_BEG/PAGE_DIR_SIZE;i<PAGE_SIZE/sizeof(uint);++i)
	   	pdir[i]=i*PAGE_DIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M|PAGE_CASH_DISABLE;

	/* ڡ󥰳 */
	asm volatile(
			"movl	%%eax,%%cr3\n"			/* Set page directory address */
			"movl	$0x10,%%eax\n"
			"movl	%%eax,%%cr4\n"			/* 4Mڡĥ */
			"movl	%%cr0,%%eax\n"
			"orl	$0x80010000,%%eax\n"	/* Enable paging,Enable wp(ѡХν񤭹ݸ) */
			"movl	%%eax,%%cr0\n"
			"jmp	1f\n"
		"1:"
		::"a"(pdir)
	);

	/* ꡼¤Τν */
	if((mstruct=(MM_STRUCT*)kmalloc(sizeof(MM_STRUCT)))==NULL)return NULL;
	mstruct->pageDir = pdir;
	mstruct->pageDirGate = 0;
	mstruct->firstStackAddr = USER_ESP_BEG;

	return (void*)mstruct;
}


/***********************************************************************************
 *
 * ƥॳ
 *
 ***********************************************************************************/

/*
 * 桼ڡΥɥ쥹ޤǳƤ롣
 */
int sys_brk(void *addr)
{
	MM_STRUCT *mm_struct = get_current_task()->mm_struct;


	if ((uint)addr < mm_struct->lastPageAddr)
		return 0;
	if (mm_struct->firstStackAddr <= (uint)addr)
		return -ENOMEM;

	mm_struct->lastPageAddr = ROUNDUP((uint)addr,PAGE_SIZE);

	return 0;
}


/***********************************************************************************
 *
 * ؿ
 *
 ***********************************************************************************/

/*
 * GLOBAL
 * ꡼ƥν
 */
void initMm()
{
	/* Find size of physical memory  */
	printk("Memory size = %d MB\n",findAllMemsize() / 0x100000);

	/* ʪ꡼ơ֥ */
	initPhysMemTable();
}
/************************************************************************/
int volatile test_mmFlag = 0;
int test_mm(uint addr)
{
	printk("test_mm() 0x%x\n", addr);
	test_mmFlag = 0;
	return 0;
}
/*************************************************************************/
