/*
 * lock.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef lock_h
#define lock_h


#include <kern/proc.h>
#include <kern/lib.h>
#include <dev/console/console.h>


#ifndef ASM_FILE


// åѹ¤
typedef struct{
	int volatile	refCount;	// 楫
	int				modify;		// ե饰
	int				gate;		// 楫ԥå
}MODIFY_LOCK;

typedef struct{
	void			*waitHead;	// ȥꥹȥإå
	int volatile	refCount;	// 楫
	int				modify;		// ե饰
	int				gate;		// 楫ԥå
}MODIFY_WAIT_LOCK;

/* ץ󥯹¤ */
typedef struct PROC_LINK{
	struct PROC_LINK *next;
	struct PROC_LINK *prev;
}PROC_LINK;

/* ץȥå塼¤ */
typedef struct WAIT_QUEUE{
	void  *wait_next;		/* ȥ󥯤μΥץ */
	void  *wait_prev;		/* ȥ󥯤Υץ */
	ushort update;			/* 񤭹ߥե饰 */
	ushort cnt;				/* Wait count. */
	int    gate;			/* Lock gate. */
}WAIT_LOCK;


/*****************************************************************************************
 * ԥå
 *****************************************************************************************/


// ԥå
extern inline void enter_spinlock(int volatile *gate)
{
	int rest;

	for(;;){
		while (*gate == 1);
		asm volatile(
			"movl	$1,%%eax\n"
			"xchgl	%%eax,(%%edx)"
			:"=a"(rest):"d"(gate)
		);
		if (rest == 0){
			break;
		}
	}
}


// ԥåФ
extern inline void exit_spinlock(int volatile *gate)
{
	*gate=0;
}


extern inline void cli()
{
	asm volatile("cli");
}

extern inline void sti()
{
	asm volatile("sti");
}


extern int enterCli();
extern void exitCli(int);
extern void modifyLock(MODIFY_LOCK *modifyLock);
extern void modifyUnlock(MODIFY_LOCK *modifyLock);
extern void modifyRef(MODIFY_LOCK *modifyLock);
extern void modifyRefEnd(MODIFY_LOCK *modifyLock);
extern void modifyWaitLock(MODIFY_WAIT_LOCK *modifyLock);
extern void modifyWaitUnlock(MODIFY_WAIT_LOCK *modifyLock);
extern void modifyWaitRef(MODIFY_WAIT_LOCK *modifyLock);
extern void modifyWaitRefEnd(MODIFY_WAIT_LOCK *modifyLock);


#endif


#endif
