/*
 * lock.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/param.h>
#include <kern/proc.h>
#include <kern/device.h>
#include <kern/lock.h>
#include <kern/debug.h>
#include <kern/test.h>


//#define DEBUG_LOCK 1
#ifdef DEBUG_LOCK
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE inline
#endif


/*****************************************************************************************
 * ߶ػߥå
 *****************************************************************************************/

//================================== PUBLIC =============================================

/*
 * ߶ػ
 * return : eflags
 */
int enterCli()
{
	int eflag;

	asm volatile(
		"pushfl\n"
		"popl	%%eax\n"
		"cli"
		:"=a"(eflag):
	);
	
	return eflag;
}

/*
 * ¸Ƥeflags᤹
 */
void exitCli(int eflag)
{
	asm volatile(
		"pushl	%%eax\n"
		"popfl"
		::"a"(eflag)
	);
}


/*****************************************************************************************
 * ȥå
 * δ֤ȽåϹå롣
 *****************************************************************************************/

//================================== PUBLIC =============================================

/*
 * å
 */
void modifyLock(MODIFY_LOCK *modifyLock)
{
	enter_spinlock(&modifyLock->gate);
	{
		while (0 < modifyLock->refCount);
		modifyLock->modify = YES;
		modifyLock->refCount += 1;
	}
	exit_spinlock(&modifyLock->gate);
}

/*
 * å
 */
void modifyUnlock(MODIFY_LOCK *modifyLock)
{
	ASSERT(0 < modifyLock->refCount);

	modifyLock->modify = NO;
	modifyLock->refCount -= 1;
}

/*
 * ȥȥå
 */
void modifyRef(MODIFY_LOCK *modifyLock)
{
	enter_spinlock(&modifyLock->gate);
	{
		while (modifyLock->modify == YES){
		}
		modifyLock->refCount += 1;
	}
	exit_spinlock(&modifyLock->gate);
}

/*
 * ȥȥ
 */
void modifyRefEnd(MODIFY_LOCK *modifyLock)
{
	ASSERT(0 < modifyLock->refCount);

	modifyLock->refCount -= 1;
}


/*****************************************************************************************
 * ȥȥå
 * δ֤ϻȽϥȤϹϥȤ롣
 *****************************************************************************************/

//================================== PUBLIC =============================================

/*
 * ̾ﹹå
 */
void modifyWaitLock(MODIFY_WAIT_LOCK *modifyLock)
{
	int isSet;

	for (isSet = NO;;) {
		int eflags;

		enter_spinlock(&modifyLock->gate);
		{
			if (0 == modifyLock->refCount) {
				modifyLock->modify = YES;
				modifyLock->refCount++;
				isSet = YES;
			}
			else {
				// Բ
				eflags = enterCli();

				// 
				waitProcSignal(&modifyLock->waitHead);
			}
		}
		exit_spinlock(&modifyLock->gate);
		if (isSet == YES) {
			break;
		}
		else {
			// ߲
			exitCli(eflags);

			wait_task();
		}
	}
}

/*
 * ̾ﹹå
 */
void modifyWaitUnlock(MODIFY_WAIT_LOCK *modifyLock)
{
	ASSERT(0 < modifyLock->refCount);

	enter_spinlock(&modifyLock->gate);
	{
		modifyLock->modify = NO;
		modifyLock->refCount--;
		if (modifyLock->waitHead != NULL) {
			runProcSignal(&modifyLock->waitHead);
		}
	}
	exit_spinlock(&modifyLock->gate);
}

/*
 * 
 */
void modifyWaitRef(MODIFY_WAIT_LOCK *modifyLock)
{
	int isSet;

	for (isSet = NO;;){
		int eflags;

		enter_spinlock(&modifyLock->gate);
		{
			if (modifyLock->modify == NO){
				modifyLock->refCount++;
				isSet = YES;
			}
			else{
				// Բ
				eflags = enterCli();

				// 
				waitProcSignal(&modifyLock->waitHead);
			}
		}
		exit_spinlock(&modifyLock->gate);
		if (isSet == YES){
			break;
		}
		else{
			// ߲
			exitCli(eflags);

			wait_task();
		}
	}
}

/*
 * Ƚλ
 */
void modifyWaitRefEnd(MODIFY_WAIT_LOCK *modifyLock)
{
	ASSERT(0 < modifyLock->refCount);

	modifyLock->refCount--;
	enter_spinlock(&modifyLock->gate);
	{
		if (modifyLock->waitHead != NULL){
			runProcSignal(&modifyLock->waitHead);
		}
	}
	exit_spinlock(&modifyLock->gate);
}

//*************************************************************************************************

MODIFY_WAIT_LOCK waitQueue[2];

void lockTest(void *i_proc, int cnt, void *waitLock)
{
	static PROC *proc = NULL;
	
	if (cnt == 0) {
		proc = i_proc;
	}
	else if ((proc != NULL) && (&waitQueue[0] == waitLock)) {
		if (proc == i_proc) {
			printDebug(80 * 3 + 70, "Pro1  %d", cnt);
//			printk("Pro1 %d %x\n", cnt, i_proc);
		}
		else {
			printDebug(80 * 4 + 70, "Pro2  %d", cnt);
//			printk("Pro2 %d %x\n", cnt, i_proc);
		}
	}
}
