/*
 * list.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Xg
 */


#include <sys/types.h>
#include <sys/param.h>
#include <kern/list.h>
#include <kern/test.h>
#include <kern/debug.h>


//#define DEBUG_LIST 1
#ifdef DEBUG_LIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


/*****************************************************************************************
* Xg
******************************************************************************************/

/*
 * ̃ÑIuWFNg擾
 * return : IuWFNg|C^
 */
void *getNextList(
	const size_t offset,		// Xgo[̃ItZbg
	const OBJ_LIST *i_src)		// Xgo[|C^
{
	const LIST *src = (LIST*) i_src;

	ASSERT(i_src != NULL);

	return (void*) ((size_t) src->next - offset);
}

/*
 *sӁtPXgł͎gps
 * ÕÑIuWFNg擾
 * return : IuWFNg|C^ or NULL
 */
void *getPrevList(
	const size_t offset,		// Xgo[̃ItZbg
	const OBJ_LIST *i_src)		// Xgo[|C^
{
	const LIST *src = (LIST*) i_src;

	return (src != NULL) ? (void*) ((size_t) src->prev - offset) : NULL;
}

/*
 * Nwbh̍ŏ̃IuWFNg擾
 * return : IuWFNg|C^ or NULL
 */
void *getHeadObj(
	const size_t offset,		// Xgo[̃ItZbg
	const OBJ_LIST *head)		// wb_l
{
	return (head != NULL) ? (void*) ((size_t) head - offset) : NULL;
}

/*****************************************************************************************
* PXg
******************************************************************************************/

//================================== PUBLIC =============================================

/*
 * Xgvf̏
 */
void initList(
	OBJ_LIST *m_src)		// Xgo[|C^
{
	LIST *src = (LIST*) m_src;

	src->next = NULL;
}

/*
 * ɐڑ
 */
void addList(OBJ_LIST *m_dst, OBJ_LIST *m_src)
{
	LIST *dst = (LIST*)m_dst;
	LIST *src = (LIST*)m_src;

	dst->next = src;
}

/*
 * Nwbhɐڑ
 */
void addHeadList(OBJ_LIST **m_head, OBJ_LIST *m_src)
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;
	
	src->next = *head;
	*head = src;
}

/******************************************************************************************************
* zXg
 *******************************************************************************************************/

//================================== PRIVATE ============================================

/*
 * ڑvf̎ɐڑ
 */
STATIC INLINE void addNext(LIST *dst, LIST *src)
{
	src->next = dst->next;
	src->prev = dst;
	dst->next->prev = src;
	dst->next = src;
}

/*
 * ڑvf̑Oɐڑ
 */
STATIC INLINE void addPrev(LIST *dst, LIST *src)
{
	src->next = dst;
	src->prev = dst->prev;
	dst->prev->next = src;
	dst->prev = src;
}

/*
 * Xg폜
 */
STATIC INLINE void remove(LIST *src)
{
	src->prev->next = src->next;	// nextŏɕς
	src->next->prev = src->prev;
	src->next =  src;
	src->prev = src;
}

//================================== PUBLIC =============================================

/*
 * NXgvf̏
 */
void initCirculList(
	OBJ_LIST *m_src)		// Xgo[|C^
{
	LIST *src = (LIST*) m_src;

	src->next = src->prev = src;
}

/*
 * ڑvf̎ɐڑ
 */
void addNextList(
	OBJ_LIST *m_dst,		// ڑ惊Xgo[|C^
	OBJ_LIST *m_src)		// ڑXgo[|C^
{
	addNext((LIST*) m_dst, (LIST*) m_src);
}

/*
 * ڑvf̑Oɐڑ
 */
void addPrevList(
	OBJ_LIST *m_dst,		// ڑ惊Xgo[|C^
	OBJ_LIST *m_src)		// ڑXgo[|C^
{
	addPrev((LIST*) m_dst, (LIST*) m_src);
}

/*
 * NXg폜
 */
void removeList(
	OBJ_LIST *m_src)		// Xgo[|C^
{
	remove((LIST*) m_src);
}

/*
 * Nwbh̎ɐڑ
 */
void addHeadNextList(
	OBJ_LIST **m_head,		// ڑwb_|C^
	OBJ_LIST *m_src)		// ڑXgo[|C^
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;

	if (*head == NULL) {
		src->next = src;
		src->prev = src;
		*head = src;
	}
	else {
		addNext(*head, src);
	}
}

/*
 * Nwbh̑Oɐڑ
 */
void addHeadPrevList(
	OBJ_LIST **m_head,		// wb_l
	OBJ_LIST *m_src)		// ڑXgo[|C^
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;

	if (*head == NULL) {
		src->next = src;
		src->prev = src;
		*head = src;
	}
	else {
		addPrev(*head, src);
	}
}

/*
 * NwbhwNXg폜
 */
void removeFromHeadList(
	OBJ_LIST **m_head,		// wb_l
	OBJ_LIST *m_src)		// ؒfXgo[|C^
{
	LIST **head = (LIST**) m_head;
	LIST *src = (LIST*) m_src;

	ASSERT(*head != NULL);

	if (*head == src) {
		if (src->next == src) {
			*head = NULL;
		}
		else {
			*head = src->next;
			remove(src);
		}
	}
	else {
		LIST *list;

		for (list = *head;;) {
			if (list == src){
				remove(src);
				break;
			}

			list = list->next;
			if (*head == list){
				// Yvf
				ASSERT(0);
			}
		}

	}
}
