/*
 * lib_path.c
 *
 * Copyright 2005, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ѥʸؿ
 */


#include <sys/param.h>
#include <sys/types.h>
#include <kern/fs.h>


// ʸӤפХȿ֤
// ɤ餫NULLʸǤ⽪
int cmpStrNum(const char *dstStr, const char *srcStr)
{
	int count;

	for (count = 0; dstStr[count] & srcStr[count]; ++count){
		if (dstStr[count] != srcStr[count]){
			break;
		}
	}

	return count;
}


/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or ԰=NULL;
 */
const char *cmpPathNull(const char *destPath, const char *srcPath)
{
	while (*destPath == *srcPath++){
		if (*destPath++ == '\0'){
			return srcPath - 1;
		}
	}

	if ((*(srcPath - 1) == '/') && (*destPath == '\0')){
		return srcPath;
	}
	else{
		return NULL;
	}
}


/*
 * ̾ʸȥѥʸӤ롣
 * parameters : destination name string,sorce path string,ӥХȿ
 * return : =0 or 礭=1 or =-1
 */
int cmpPath(const char *name,const char *path,int count)
{
	int i;

	for (i = 0; i < count; ++i){
		if (name[i] != path[i]){
			if ((uchar)name[i] > (uchar)path[i]){
				return 1;
			}
			else{
				return -1;
			}
		}
	}

	if ((path[count] == '/') || (path[count] == '\0')){
		return 0;
	}

	return -1;
}


/*
 * ѥʸ󥵥Ϥ롣
 * parmeters : path
 */
size_t pathLen(const char *path)
{
	const char *p=path;

	while (*p++ != '/'){
		if (*p == '\0'){
			return (size_t)(p-path);
		}
	}

	return (size_t)(p-path-1);
}


/*
 * ѥ饹ȥѥɤȽꤹ롣
 * parameters : path
 * return : name size or failed=-1;
 */
int isLastPath(const char *path)
{
	int i;

	for (i = 0; path[i] != '\0'; ++i){
		if ((path[i] == '/') && (path[i + 1] != '\0')){
			return -1;
		}
	}

	return i;
}
