/*
 * elf.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/param.h>
#include <sys/types.h>
#include <sys/elf32.h>
#include <sys/elf_common.h>
#include <machine/elf.h>
#include <kern/lib.h>
#include <kern/mm.h>
#include <kern/fs.h>
#include <dev/console/console.h>


/*
 * ELFХʥɤ롣
 * parameters : open file struct
 * return : ȥ꡼ɥ쥹 or error=0
 */
uint loadElf(EXEC_FD *fd)
{
	Elf32_Ehdr *header;
	Elf32_Phdr *phead;
	uint entry_addr;
	int tmp,i;

	/* إåɤ߹ */
	if ((header = kmalloc(sizeof(Elf32_Ehdr))) == NULL)
		return 0;
	fd->offset=0;
	if (exec_read(fd,header,sizeof(Elf32_Ehdr)) != sizeof(Elf32_Ehdr))
		goto ERR;

	/* ޥåʥСǧ */
	if (memcmp("\177ELF",header->e_ident,4) != 0)
		goto ERR;						

	/* סcpuǧ */
	if ((header->e_type != ET_EXEC) || (header->e_machine != EM_386))
		goto ERR;

	/* 桼ΥƥȤȥǡڡ롣 */
	releaseUserPage();

	/* ץإåɤ߹ࡣ */
	tmp = header->e_phnum * sizeof(Elf32_Phdr);				/* ץإå */
	if ((phead = kmalloc(tmp)) == NULL)
		goto ERR;
	fd->offset = header->e_phoff;
	if (exec_read(fd,phead,tmp) != tmp)
		goto ERR2;

	/* ץΥɡ */
	for (i = 0; i < header->e_phnum; ++i){
		if ((phead[i].p_type == PT_LOAD) && (0 < phead[i].p_memsz))
		{
			fd->offset = phead[i].p_offset;
			if (loadBinary(fd,phead[i].p_memsz,phead[i].p_filesz,phead[i].p_vaddr,(phead[i].p_flags & PF_W)? LB_WR : LB_R) == -1)
				goto ERR2;
		}
	}

	entry_addr = header->e_entry;

	kfree(phead);
	kfree(header);

	return entry_addr;
ERR2:
	kfree(phead);
ERR:
	kfree(header);

	return 0;
}


/*************************************************************************/
void test_elf(void *buf)
{
	printk("entry address=%x\n",((Elf32_Ehdr*)buf)->e_entry);
}
