/*
 * device.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef device_h
#define device_h


#include <sys/types.h>
#include <sys/bus.h>
#include "proc.h"
#include "fs.h"


#ifndef ASM_FILE


enum{
	/* ǥХ̡ */
	DEV_CLASS_BLOCK=0,		/* ֥åǥХ */
	DEV_CLASS_CHARA,		/* 饯ǥХ */
	DEV_CLASS_NETWORK,		/* ͥåȥǥХ */

	MAX_DEVICE_NAME	= 10,	// ǥХ̾ʸ

	DEVICE_ROOT_INODE = 0,	// ǥХե륷ƥ롼inodeֹ
};


// Ԥѹ¤
struct waitIntr{
	PROC *proc;		// Ԥץ
	int isIntr;		// ץߤ³Ȥ˥ץ塼ꤹ롣
};
typedef struct waitIntr WAIT_INTR;


#define DEV_FS_NAME "devFs"


/* ǥХơȹ¤Ρ */
typedef struct{
	ushort		major;			// ᥸㡼ֹ
	ushort		prt_num;		// ѡƥʥСޥʡֹ
	ushort		prt_type;		// ѡƥ󥿥
	ushort		sect_size;		// 
	size_t		all_sect;		// 
	const char *name;
}DEV_STAT;


extern void devInitWait(WAIT_INTR *);
extern void devWaitIntr(WAIT_INTR*,uint);
extern int devWakeIntr(WAIT_INTR*);
extern int initDeviceFs();
extern int initBlockCache();
extern int mountDeviceFs();
extern int registBlockPartition(const char*);
extern int delete_device(const char*);
extern void setupIntr(struct resource *, void (*handler)(void *), void *);
extern int get_devstat(int,DEV_STAT*);
extern int sys_sync();
extern int read_direct(int, void*, size_t, size_t, size_t*);
extern int write_direct(int, void*, size_t, size_t, size_t*);
extern int read_cache(int, void*, size_t, size_t, size_t*);
extern int write_cache(int, void*, size_t, size_t, size_t*);
extern int sys_ttyname(int,char*);


#endif


#endif
