/*
 * debug.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef debug_h
#define debug_h


#ifndef ASM_FILE


#ifdef DEBUG
 #define ASSERT(bool) if ((bool) == 0){							\
 	printk("Assertion! : %s line=%d \n",__FILE__, __LINE__); 	\
 	idle();														\
 }
 #define WARNING(bool) if ((bool) == 0){						\
 	printk("Warning! : %s line=%d \n",__FILE__, __LINE__);		\
 }
#else
 #define ASSERT(bool)
 #define WARNING(bool)
#endif

extern int debugFlag;
extern void saveSyscallEntry(uint, int);
extern void printSyscallEntry(uint);
#ifdef DEBUG
extern void displayTop(int, const char*, int);
#endif


#endif


#endif
