/*
 * debug.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/config.h>
#include <sys/types.h>
#include <kern/proc.h>
#include <kern/lib.h>
#include <dev/console/console.h>


enum{
	ENTRY_NUM=10, 
};


#ifdef DEBUG


int debugFlag;
uint syscallEntry[ENTRY_NUM];

void saveSyscallEntry(uint entry, int syscall_num)
{
	memmove(&syscallEntry[1],syscallEntry,sizeof(uint) * (ENTRY_NUM-1));
	syscallEntry[0] = entry;
	
/****************************************************************************************************************/
	printDebug(70, "%x", entry);
/****************************************************************************************************************/
}


// parameters : n=number of prints
void printSyscallEntry(uint n)
{
	int i;

	if (n > ENTRY_NUM)
		n = ENTRY_NUM;
	printk("syscall entry\n");
	for (i = 0; i < n; ++i)
	{
		printk("%d %x ",i+1,syscallEntry[i]);
		printk("\n");
	}
}


// 
#endif
