/*
 * buf.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * obt@[B
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include "mm.h"
#include "lock.h"
#include "buf.h"
#include "test.h"
#include "debug.h"


//#define DEBUG_BUF 1
#ifdef DEBUG_BUF
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================


//================================== PROTECTED ==========================================


//================================== PUBLIC =============================================


// obt@蓖Ă
// return : EFAULTFg[^TCYI[o[
//          ENOMEMFVXe[Ȃ
int allocBuf(
	const uint size, 			// vTCY
	ALLOC_BUF *m_allocBuf, 		// ALLOC_BUF\
	void **o_buf)				// obt@
{
	uint actualSize;
	int eflag;
	int error = NOERR;

	eflag = enterCli();
	enter_spinlock(&m_allocBuf->lock);
	{
		if (m_allocBuf->sizeTotal < m_allocBuf->sizeMax){
			*o_buf = kmallocSize(size, &actualSize);
			if (*o_buf != NULL){
				m_allocBuf->sizeTotal += actualSize;
			}
			else{
				error = -ENOMEM;
			}
		}
		else{
			error = -EFAULT;	// ݒőTCYI[o[
		}
	}
	exit_spinlock(&m_allocBuf->lock);
	exitCli(eflag);
	
	return error;
}


// 蓖Ăobt@J
void freeBuf(
	void *i_buf,				// Jobt@
	ALLOC_BUF *m_allocBuf)		// ALLOC_BUF\
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&m_allocBuf->lock);
	{
		m_allocBuf->sizeTotal -= kfree(i_buf);

		ASSERT(0 <= (int)m_allocBuf->sizeTotal);
	}
	exit_spinlock(&m_allocBuf->lock);
	exitCli(eflag);
}


// \TCY擾
int getRestSizeBuf(
	ALLOC_BUF *allocBuf)			// ALLOC_BUF\
{
	return allocBuf->sizeMax - allocBuf->sizeTotal;
}


// ALLOC_BUF\̂
void initAllocBuf(
	const uint sizeMax, 			// TCY
	ALLOC_BUF *m_allocBuf)			// ALLOC_BUF\
{
	memset(m_allocBuf, 0, sizeof(*m_allocBuf));
	m_allocBuf->sizeMax = sizeMax;
}
