/*-
 * Copyright (c) 1996-1997 John D. Polstra.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/i386/include/elf.h,v 1.9.2.1 2001/11/03 01:41:08 ps Exp $
 */
/*
 * ELF definitions for the i386 architecture.
 */


#ifndef _MACHINE_ELF_H_
#define _MACHINE_ELF_H_ 1


/*
 * Relocation types.
 */
#define R_386_NONE		0	/* No relocation. */
#define R_386_32		1	/* Add symbol value. */
#define R_386_PC32		2	/* Add PC-relative symbol value. */
#define R_386_GOT32		3	/* Add PC-relative GOT offset. */
#define R_386_PLT32		4	/* Add PC-relative PLT offset. */
#define R_386_COPY		5	/* Copy data from shared object. */
#define R_386_GLOB_DAT	6	/* Set GOT entry to data address. */
#define R_386_JMP_SLOT	7	/* Set GOT entry to code address. */
#define R_386_RELATIVE	8	/* Add load address of shared object. */
#define R_386_GOTOFF	9	/* Add GOT-relative symbol address. */
#define R_386_GOTPC		10	/* Add PC-relative GOT table address. */
#define R_386_COUNT		11	/* Count of defined relocation types. */


#endif /* !_MACHINE_ELF_H_ */
