/*-
 * Copyright (c) 1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/i386/include/cpufunc.h,v 1.96.2.3 2002/04/28 22:50:54 dwmalone Exp $
 */

/*
 * Functions to provide access to special i386 instructions.
 */


#ifndef _MACHINE_CPUFUNC_H_
#define	_MACHINE_CPUFUNC_H_


#include <sys/cdefs.h>
#include <sys/types.h>


#ifndef ASM_FILE


#ifdef KERNEL


extern inline void outb(int port,uchar value)
{
	asm volatile(
		"outb	%%dx"
		::"d"(port),"a"(value)
	);
}

extern inline uchar inb(int port)
{
	uchar rest;

	asm volatile(
		"inb	%%dx"
		:"=a"(rest):"d"(port)
	);

	return rest;
}

extern inline void outw(int port, ushort value)
{
	asm volatile(
		"outw	%%dx"
		::"d"(port),"a"(value)
	);
}

extern inline ushort inw(int port)
{
	ushort rest;

	asm volatile(
		"inw	%%dx"
		:"=a"(rest):"d"(port)
	);

	return rest;
}

extern inline void outl(int port, uint value)
{
	asm volatile(
		"outl	%%dx"
		::"d"(port),"a"(value)
	);
}

extern inline uint inl(int port)
{
	uint rest;

	asm volatile(
		"inl	%%dx"
		:"=a"(rest):"d"(port)
	);

	return rest;
}

extern inline void insb(u_int port, void *addr, size_t cnt)
{
	asm volatile(
			"cld; rep; insb"
			 : "=D" (addr), "=c" (cnt)
			 :  "0" (addr),  "1" (cnt), "d" (port)
			 : "memory");
}

extern inline void insw(u_int port, void *addr, size_t cnt)
{
	asm volatile(
			"cld; rep; insw"
			 : "=D" (addr), "=c" (cnt)
			 :  "0" (addr),  "1" (cnt), "d" (port)
			 : "memory");
}

extern inline void insl(u_int port, void *addr, size_t cnt)
{
	asm volatile(
			"cld; rep; insl"
			 : "=D" (addr), "=c" (cnt)
			 :  "0" (addr),  "1" (cnt), "d" (port)
			 : "memory");
}

extern inline void outsb(u_int port, const void *addr, size_t cnt)
{
	asm volatile(
			"cld; rep; outsb"
			 : "=S" (addr), "=c" (cnt)
			 :  "0" (addr),  "1" (cnt), "d" (port));
}

extern inline void outsw(u_int port, const void *addr, size_t cnt)
{
	asm volatile(
			"cld; rep; outsw"
			 : "=S" (addr), "=c" (cnt)
			 :  "0" (addr),  "1" (cnt), "d" (port));
}

extern inline void outsl(u_int port, const void *addr, size_t cnt)
{
	asm volatile(
			"cld; rep; outsl"
			 : "=S" (addr), "=c" (cnt)
			 :  "0" (addr),  "1" (cnt), "d" (port));
}


static inline u_int bsfl(u_int mask)
{
	u_int	result;

	asm volatile("bsfl %0,%0" : "=r" (result) : "0" (mask));
	return (result);
}

static inline int ffs(int mask)
{
	/*
	* Note that gcc-2's builtin ffs would be used if we didn't declare
	* this inline or turn off the builtin.  The builtin is faster but
	* broken in gcc-2.4.5 and slower but working in gcc-2.5 and later
	* versions.
	*/
	return (mask == 0 ? mask : bsfl((u_int)mask) + 1);
}

#endif // KERNEL


#endif


#endif /* !_MACHINE_CPUFUNC_H_ */
