/*-
 * Copyright (c) 1997 Jonathan Lemon
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/i386/i386/bioscall.s,v 1.6.2.1 2000/07/07 00:38:46 obrien Exp $
 */

/*
 * Functions for calling x86 BIOS functions from the BSD kernel
 */


#define ASM_FILE


#include <machine/segment.h>


.data

.align 4

bioscall_vector:
	.long	0
	.word	KERNEL_CODE_DES


.text

/*
 * int bios32(struct bios_regs *regs, u_int offset)
 * return : 0 or 1 = error
 */
.globl bios32
bios32:
	pushl	%ebp
	movl	12(%esp),%ebp
	movl	%ebp,bioscall_vector
	movl	8(%esp),%ebp
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	0(%ebp),%eax
	movl	4(%ebp),%ebx
	movl	8(%ebp),%ecx
	movl	12(%ebp),%edx
	movl	16(%ebp),%esi
	movl	20(%ebp),%edi
	pushl	%ebp
	lcall	*bioscall_vector
	popl	%ebp
	movl	%eax,0(%ebp)
	movl	%ebx,4(%ebp)
	movl	%ecx,8(%ebp)
	movl	%edx,12(%ebp)
	movl	%esi,16(%ebp)
	movl	%edi,20(%ebp)
	movl	$0,%eax			/* presume success */
	jnc	1f
	movl	$1,%eax			/* nope */
1:
	popl	%edi
	popl	%esi
	popl	%ebx
	popl	%ebp
	ret
