/*
 * display.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * fBXvC\
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <dev/console/display.h>
#include <kern/test.h>
#include <kern/debug.h>


//#define DEBUG_DISPLAY 1
#ifdef DEBUG_DISPLAY
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


/***************************************************************************************
 *
 * fBXvC
 *
 ***************************************************************************************/

//================================== PRIVATE ============================================

typedef struct{
	uchar ch;			// 
	uchar attr;			// 
}VRAM;

enum{
	VRAM_BASE_ADDR	= 0xb8000,		// VGArfIX^[gAhX
	VRAM_SIZE		= 0x8000,		// VGArfITCYioCgj

	CTL_ADDR			= 0x3d4,	// CRTAhXWX^
	CTL_DATA			= 0x3d5,	// CRTf[^IOWX^
	START_ADDR_HIGH		= 0xc,		/* High byte of print start address */
	START_ADDR_LOW		= 0xd,		/* Low  byte of print start address  */
	CURSOR_ADDR_HIGH	= 0xe,		/* High byte of cursor address */
	CURSOR_ADDR_LOW		= 0xf,		/* Low  byte of cursor address */

	TOTAL_LINES	= VRAM_SIZE / sizeof(VRAM) / SCREEN_COLUMNS,	// [̈̑s
};

/*
 * [̈̈ʒuVRAMPʁiQoCgjɂȂ
 */
typedef struct{
	volatile int screenTop;		// [̈̉ʂ̊Jnʒu
	volatile int cursor;		// [̈̃J[\ʒu
} VRAM_AREA; 

static VRAM_AREA vramArea;

/*****************************************************
static void testPrint(int position, int uvalue)
{
	VRAM *vram = (VRAM*) VRAM_BASE_ADDR;
	char tmp_buf[12];
	int pos;
	int i;

	for (i = 0; ; ++i) {
		tmp_buf[i] = uvalue % 10 + '0';
		if ((uvalue /= 10) == 0) {
			break;
		}
	}
	for (pos = position;i >= 0; --i, ++pos) {
		vram[pos].ch = tmp_buf[i];
	}
}
*******************************************************/

/*
 * [̈̉ʈʒuݒ肷
 */
STATIC INLINE void moveScreen(
	const int position)
{
	outb(CTL_ADDR, START_ADDR_HIGH);
	outb(CTL_DATA, position >> 8);
	outb(CTL_ADDR, START_ADDR_LOW);
	outb(CTL_DATA, position);
}

/*
 * PsXN[Abv
 */
STATIC void scrollup()
{
	VRAM *vram;
	int i;

	if (vramArea.screenTop / SCREEN_COLUMNS < TOTAL_LINES - SCREEN_LINES) {
		vramArea.screenTop += SCREEN_COLUMNS;
	}
	else {
		VRAM *vramBegin = (VRAM*) VRAM_BASE_ADDR;

		// Pʂ[̈̎n߂Ɉړ
		vram = (VRAM*) VRAM_BASE_ADDR + vramArea.screenTop + SCREEN_COLUMNS;
		for (i = 0; i < SCREEN_COLUMNS * (SCREEN_LINES - 1); ++i) {
			vramBegin[i] = vram[i];
		}

		vramArea.screenTop = 0;
	}

	// VsNA[
	vram = (VRAM*) VRAM_BASE_ADDR + vramArea.screenTop + (SCREEN_COLUMNS * (SCREEN_LINES - 1));
	for (i = 0; i < SCREEN_COLUMNS; ++i) {
		vram[i].ch = '\0';
		vram[i].attr = ATTR_NORMAL;
	}

	moveScreen(vramArea.screenTop);
}

//================================== PUBLIC =============================================

/*
 * P\
 */
void putDisplay(
	const int i_position,		// [̈̈ʒu
	const int ch,				// LN^[
	const int attr)				// 
{
	int position = i_position;
	VRAM *vram;

	ASSERT(0 <= position);

	while (SCREEN_COLUMNS * TOTAL_LINES <= position) {
		position -= SCREEN_COLUMNS * (TOTAL_LINES - SCREEN_LINES + 1);
	}
	vram = (VRAM*) VRAM_BASE_ADDR + position;
	vram->ch = ch;
	vram->attr = attr;
}

/*
 * Update cursor position.
 */
void updateCursor(
	const int i_position)		// [̈̈ʒu
{
	int position;
	int top;

	// ʒuʗ̈𒴂XN[Abv
	for (top = vramArea.screenTop; top + SCREEN_COLUMNS * SCREEN_LINES <= i_position; top += SCREEN_COLUMNS) {
		scrollup();
	}

	// J[\\
	position = i_position;
	while (SCREEN_COLUMNS * TOTAL_LINES <= position) {
		position -= SCREEN_COLUMNS * (TOTAL_LINES - SCREEN_LINES + 1);
	}

	// J[\ʒuݒ肷
	outb(CTL_ADDR, CURSOR_ADDR_HIGH);
	outb(CTL_DATA, position >> 8);
	outb(CTL_ADDR, CURSOR_ADDR_LOW);
	outb(CTL_DATA, position);
	vramArea.cursor = position;
}

/*
 * rfI[ړ
 */
void copyDisplay(
	const int to,			// Rs[̃[̈ʒu
	const int from,			// Rs[̃[̈ʒu
	const size_t size)		// Rs[TCY
{
	VRAM *vramTo = (VRAM*) VRAM_BASE_ADDR + to;
	VRAM *vramFrom = (VRAM*) VRAM_BASE_ADDR + from;

	memmove(vramTo, vramFrom, sizeof(VRAM) * size);
}

/*
 * rfI[̈̃J[\ʒu擾
 * return : [̈̈ʒu
 */
int getCursorPos()
{
	return vramArea.cursor;
}

/*
 * rfI[̈̉ʐ擪ʒu擾
 * return : [̈̈ʒu
 */
int getScreenTop()
{
	return vramArea.screenTop;
}

/*
 * 
 */
void initDisplay()
{
	VRAM *vram;

	/* Start position 0 */
	moveScreen(0);

	/* Clear screen */
	for (vram = (VRAM*)VRAM_BASE_ADDR; vram < (VRAM*)(VRAM_BASE_ADDR + VRAM_SIZE); ++vram) {
		vram->ch = 0;
		vram->attr = ATTR_NORMAL;
	}
}

/***************************************************************************************
 *
 * fobOp
 *
 ***************************************************************************************/

#ifdef DEBUG
/*
 * ɉʂ̐擪̔Cӂ̌\
 */
void displayTop(int column, const char *bytes, int size)
{
	VRAM *vram = (VRAM*) VRAM_BASE_ADDR + getScreenTop() + column;
	int i;
	
	for (i = 0; i < size; ++i){
		vram[i].ch = bytes[i];
	}
}
#endif

/***************************************************************************************
 *
 * eXgp
 *
 ***************************************************************************************/

int testDisplay(int num)
{
	static int scroll = NO;
	VRAM *vram = (VRAM*) VRAM_BASE_ADDR + getScreenTop() + (80 * 2 + 70);
	
	if (num == 0) {
		scroll = YES;
	}
	if (scroll == YES) {
		vram->ch = num + '0';
		mili_timer(1000);
	}
	
	return 0;
}
