/*
 * 8254.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 8254C^[o^C}[
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/lib.h>
#include <kern/time.h>
#include <kern/interrupt.h>
#include <dev/8254.h>
#include <kern/test.h>
#include <kern/debug.h>


//#define DEBUG_8254 1
#ifdef DEBUG_8254
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


/******************************************************************************************************
 *
 * 8254vO}uC^[o^C}[
 *
 *******************************************************************************************************/

//================================== PRIVATE ============================================

enum {
	PIT_HZ = 1193181,	/* 8254C^[o^C}[̃wc */

	/* 8254 IO register */
	PIT_CNR0=0x40,		/* counter0 register */
	PIT_CTR= 0x43,		/* control register */
};

static volatile int tasking = NO;
static uint intervalTime;		// ݂̐ݒ莞ԁimsj

/*
 * ԁimsjNbNɕϊB
 * return : NbN
 */
STATIC INLINE uint timeToClock(
	const uint i_time)		// ms
{
	return PIT_HZ * i_time / 1000;
}

/*
 * NbNԁimsjɕϊB
 * return : ԁimsj
 */
STATIC INLINE uint clockToTime(
	const uint i_clock)		// NbN
{
	return i_clock * 1000 / PIT_HZ;
}

/*
 * 8254 C^[o^C}[荞݃nh[
 * return : YES = ^XNXCb` or NO = ^XNXCb`Ȃ
 */
STATIC int intrIntervalTimer()
{
	uint nextTime;

	// ^C}[nh̎s
	execIntervalTimer(intervalTime, &nextTime);

	// ^C}[ݒ肷i^C}[nh̎sj
	intervalTime = nextTime;
	if (0 < intervalTime) {
		uint clock = timeToClock(intervalTime);

		outb(PIT_CNR0, clock & 0xff);
		outb(PIT_CNR0, clock >> 8);
	}

	return tasking;
}

//================================== PUBLIC =============================================

/*
 * Set interval timer.
 * return : ߂ݒ莞ԁimsj
 */
uint setIntervalTimer(
	const uint i_time)		// ݒ莞ԁimsj
{
	int restClock;
	int clock = timeToClock(i_time);

	if (intervalTime == 0){
		intervalTime = i_time;
		outb(PIT_CNR0, clock & 0xff);
		outb(PIT_CNR0, clock >> 8);
		return intervalTime;
	}

	restClock = inb(PIT_CNR0);		// cNbN
	restClock += inb(PIT_CNR0) << 8;

	if (clock < restClock){
		intervalTime -= clockToTime(restClock - clock);
		if (0 < intervalTime){
			outb(PIT_CNR0, clock & 0xff);
			outb(PIT_CNR0, clock >> 8);
		}
		else{
			intervalTime += clockToTime(restClock - clock);
		}
		return intervalTime;
	}
	else{
		return intervalTime + clockToTime(clock - restClock);
	}
}

/*
 * C^[o^C}[荞݂Ń^XNXCb`sݒ肷
 */
void setIntervalTasking(
	int isTasking)		// YESF NO:Ȃ
{
	tasking = isTasking;
}

/*
 * ԂvO̐ݒ
 *sӁtN̂ݎgpB
 */
void setClockSecond(void)
{
 	outb(PIT_CTR,0x30);	/* CLK0,LSB.MSB,[h0,binary */
	outb(PIT_CNR0,0);	/* LSB */
	outb(PIT_CNR0,0);	/* MSB */
}

/*
 * vԂ擾
 *sӁtsetClockSecond()Ƒ΂Ŏgp邱ƁB
 * return : v(s)
 */
double getClockSecond(void)
{
	int low = inb(PIT_CNR0);
	int high = inb(PIT_CNR0);
	double clock = 0xffff - low - (high << 8);

	return clock / (double) PIT_HZ;
}

/*
 * 
 */
void initIntervalTimer(void)
{
	irq_entry[IRQ0] = intrIntervalTimer;
//	outb(PIT_CTR,0x30);		// One shot timer(mode 0).
//	outb(PIT_CTR,0x34);		// CLK0,LSB.MSB,[h2,binary.
	release_irq_mask(0);
}
