/*
 * utime.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<unistd.h>
#include<sys/time.h>
#include<utime.h>


int utime(const char *filename, struct utimbuf *buf)
{
	int rest;


	if((rest=syscall4(SYS_CHATTR,(int)filename,CHATTR_UTIME,(int)buf))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int utimes(const char *path, const struct timeval *times)
{
	struct utimbuf buf;


	buf.actime=times[0].tv_sec;
	buf.modtime=times[1].tv_sec;

	return utime(path,&buf);
}


int lutimes(const char *path, const struct timeval *times)
{
	return utimes(path,times);
}
