/*
 * termios.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<stropts.h>
#include<termios.h>


int tcgetattr(int fd, struct termios *termios_p)
{
	return ioctl(fd,IOCTL_COM_TCGETTCATTR,termios_p);
}


int tcsetattr(int fd, int optional_actions, struct termios *termios_p)
{
	return ioctl(fd,IOCTL_COM_TCSETTCATTR,optional_actions,termios_p);
}


int tcsendbreak(int fd, int duration)
{
	return ioctl(fd,IOCTL_COM_TCSENDBREAK,duration);
}


int tcdrain(int fd)
{
	return ioctl(fd,IOCTL_COM_TCDRAIN);
}


int tcflush(int fd, int queue_selector)
{
	return ioctl(fd,IOCTL_COM_TCFLASH,queue_selector);
}


int tcflow(int fd, int action)
{
	return ioctl(fd,IOCTL_COM_TCFLASH,action);
}


speed_t cfgetispeed(const struct termios *termios_p)
{
	return termios_p->boud_rate;
}


speed_t cfgetospeed(const struct termios *termios_p)
{
	return termios_p->boud_rate;
}


int cfsetispeed(struct termios *termios_p, speed_t speed)
{
	termios_p->boud_rate=speed;
	return 0;
}


int cfsetospeed(struct termios *termios_p, speed_t speed)
{
	termios_p->boud_rate=speed;
	return 0;
}
