/*
 * stat.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<fcntl.h>
#include<sys/stat.h>


int openMask=0;


/*
 * timespec¤ΤؤβбΤν
 * stat¤ΥСtimespec¤Τͤꤹ롣
 */
static void setTimespec(struct stat *buf)
{
	buf->st_atimespec.ts_sec=buf->st_atime;
	buf->st_mtimespec.ts_sec=buf->st_mtime;
	buf->st_ctimespec.ts_sec=buf->st_ctime;
	buf->st_atimespec.ts_nsec=buf->st_mtimespec.ts_nsec=buf->st_ctimespec.ts_nsec=0;
}


int mkdir(const char *path, mode_t mode)
{
	int rest;


	if((rest=syscall3(SYS_MKDIR,(int)path,(int)mode))<0)
		return _error(-rest);
	return 0;
}


int fstat(int fildes,struct stat *buf)
{
	int rest;


	if((rest=syscall4(SYS_STAT,fildes,(int)NULL,(int)buf))<0)
		return _error(-rest);
	setTimespec(buf);

	return 0;
}


int stat(const char *path,struct stat *buf)
{
	int rest;


	if((rest=syscall4(SYS_STAT,0,(int)path,(int)buf))<0)
		return _error(-rest);
	setTimespec(buf);

	return 0;
}


int chmod(const char *path, mode_t mode)
{
	int rest;


	if((rest=syscall4(SYS_CHATTR,(int)path,CHATTR_MODE,(int)mode))<0)
		return _error(-rest);
	return 0;
}


int fchmod(int fildes, mode_t mode)
{
	int rest;


	if((rest=syscall4(SYS_FCHATTR,fildes,CHATTR_MODE,(int)mode))<0)
		return _error(-rest);
	return 0;
}


mode_t umask(mode_t mask)
{
	mode_t old;


	old=openMask;
	openMask=mask&0x1f;

	return old;
}


int mkfifo(const char *pathname, mode_t mode)
{
	int fd;


	if((fd=creat(pathname,mode|O_FIFO))==-1)return -1;
	close(fd);

	return 0;
}


/********************** ̤ݡ **************************/


int lstat(const char *path, struct stat *buf)
{
	return _error(ENOTSUP);
}


int mknod(const char *path, mode_t mode, dev_t dev)
{
	return _error(ENOTSUP);
}


int lchmod(const char *path, mode_t mode)
{
	return _error(ENOTSUP);
}
