/*
 * fcntl.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<stdarg.h>
#include<stdio.h>
#include<sys/stat.h>
#include<fcntl.h>


int open(const char *path,int oflag,...)
{
	int fd;
	va_list ap;


	if(*path=='\0')return _error(ENOENT);
	va_start(ap,oflag);
	fd=syscall4(SYS_OPEN,(int)path,oflag,va_arg(ap,int)&~openMask);
	va_end(ap);

	if(fd<0)return _error(-fd);
	return fd;
}


int creat(const char *path,mode_t mode)
{
	int fd;


	fd=syscall4(SYS_CREAT,(int)path,O_WRONLY,mode);

	if(fd<0)
	{
		errno=-fd;
		return -1;
	}
	else return fd;
}


int fcntl(int fildes,int cmd,...)
{
	int rest;
	va_list ap;


	va_start(ap,cmd);
	rest=syscall4(SYS_FCNTL,fildes,cmd,va_arg(ap,int));
	va_end(ap);

	if(rest<0)
	{
		errno=-rest;
		return -1;
	}
	else return rest;
}
