/*
 * dirent.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<stdlib.h>
#include<errno.h>
#include<string.h>
#include<dirent.h>


static struct dirent dirent;


DIR *opendir(const char *dirname)
{
	int rest;


	if((rest=syscall2(SYS_OPENDIR,(int)dirname))<0)
	{
		errno=-rest;
		return NULL;
	}

	return (DIR*)rest;
}


int closedir(DIR *dirp)
{
	int rest;


	if((rest=syscall2(SYS_CLOSE,(int)dirp))<0)
		return _error(-rest);

	return 0;
}


void rewinddir(DIR *dir)
{
	syscall2(SYS_REWINDDIR,(uint)dir);
}


struct dirent *readdir(DIR *dirp)
{
	int rest;


	if((rest=syscall3(SYS_READDIR,(int)dirp,(int)dirent.d_name))<0)
	{
		errno=-rest;
		return NULL;
	}

	if(*dirent.d_name=='\0')return NULL;
	dirent.d_namlen=strlen(dirent.d_name);

	return &dirent;
}
