/*
 * stdlib.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<ctype.h>
#include<limits.h>


/******************************************************************************************
 *                              memory allocate
 ******************************************************************************************/

enum{
	MIN_SIZE=8,					/* ǾХȿ */
	FIRST_INDEX=3,				/* Ǿإåǥå */
	HEADER_NUM=31-FIRST_INDEX,	/* إåơ֥ */
	MAGIC_NUMBER=0xffff,		/* إåޥåʥС */
};


typedef union MALLOC_HEAD{
	union MALLOC_HEAD *next;
	struct{
		ushort index;
		ushort magic;
	}head;
}MALLOC_HEAD;


static const char indexNumber[]={
	0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
};


static MALLOC_HEAD *nextHead[HEADER_NUM];


void *malloc(size_t size)
{
	int index;
	MALLOC_HEAD *head;


	if(size==0)return  NULL;
	if(size<MIN_SIZE)size=MIN_SIZE;

	/* ǥå */
	if(size<0x100)
	{
		index=indexNumber[size];
		if(size&((1<<index)-1))++index;
	}
	else if(size<0x10000)
	{
		index=indexNumber[size>>8]+8;
		if(size&((1<<index)-1))++index;
	}
	else if(size<0x1000000)
	{
		index=indexNumber[size>>16]+16;
		if(size&((1<<index)-1))++index;
	}
	else
	{
		index=indexNumber[size>>24]+24;
		if(size&((1<<index)-1))++index;
		if(index==32)return NULL;
	}

	/* ꡼ */
	if(nextHead[index-FIRST_INDEX]!=NULL)
	{
		head=nextHead[index-FIRST_INDEX];
		nextHead[index-FIRST_INDEX]=head->next;
	}
	else
	{
		if((head=(MALLOC_HEAD*)sbrk((1<<index)+sizeof(MALLOC_HEAD)))==NULL)return NULL;
	}
	head->head.magic=MAGIC_NUMBER;
	head->head.index=index-FIRST_INDEX;

	return (void*)(head+1);
}


void free(void *ptr)
{
	int index;
	MALLOC_HEAD *head;


	if(ptr==NULL)return;

	head=(MALLOC_HEAD*)ptr-1;
	if(head->head.magic!=MAGIC_NUMBER)return;		/* ҡפ˲Ƥ롣 */

	index=head->head.index;
	head->next=nextHead[index];
	nextHead[index]=head;
}


void *realloc(void *ptr,size_t size)
{
	void *mem;
	int shift;
	MALLOC_HEAD *head;


	if(ptr==NULL)return malloc(size);
	if(size==0)
	{
		free(ptr);
		return NULL;
	}

	head=(MALLOC_HEAD*)ptr-1;
	if(head->head.magic!=MAGIC_NUMBER)return NULL;	/* ҡפ˲Ƥ롣 */

	shift=head->head.index+FIRST_INDEX;
	if(size>(1<<shift))								/* (1<<shift)=ߤͿ줿 */
	{
		if((mem=malloc(size))==NULL)return NULL;
		memcpy(mem,ptr,1<<shift);
		free(ptr);
		return mem;
	}
	else return ptr;
}


void *calloc(size_t nmemb, size_t size)
{
	void *mem;


	if((mem=malloc(size*nmemb))==NULL)return NULL;
	memset(mem,0,size*nmemb);

	return mem;
}


/**********************************************************************************************
 *
 **********************************************************************************************/


double strtod(const char *nptr, char **endptr)
{
	int sign;
	double rest,denom,nume;


	/* ۥ磻ȥڡν */
	for(;isspace(*nptr);++nptr);

	/* γǧ */
	if(*nptr=='+')
	{
		sign=1;
		++nptr;
	}
	else if(*nptr=='-')
	{
		sign=-1;
		++nptr;
	}
	else sign=1;

	/* Ѵ */
	rest=0;
	while(isdigit(*nptr))
	{
		rest*=10;
		rest+=*nptr++-'0';
	}

	/* Ѵ */
	if(*nptr=='.')
	{
		denom=1;	/* ʬ */
		nume=0;		/* ʬ */
		++nptr;
		while(isdigit(*nptr))
		{
			nume*=10;
			nume+=*nptr++-'0';
			denom*=10;
		}
		rest+=nume/denom;
	}

	if(endptr!=NULL)*endptr=(char*)nptr;

	/* η׻ */
	return rest*sign;
}


long int strtol(const char *nptr, char **endptr, int base)
{
	int sign;
	int value,digit;


	/* γǧ */
	if((base>36)||((base<0)||(base==1)))
	{
		errno=EINVAL;
		return 0;
	}

	/* ۥ磻ȥڡν */
	for(;isspace(*nptr);++nptr);

	/* γǧ */
	if(*nptr=='+')
	{
		sign=1;
		++nptr;
	}
	else if(*nptr=='-')
	{
		sign=-1;
		++nptr;
	}
	else sign=1;

	/* 0ξ硣 */
	if(*nptr=='0')
	{
		if((*(nptr+1)=='x')||(*(nptr+1)=='X'))
		{
			if(base==0)base=16;
			nptr+=2;
		}
		else
		{
			if(base==0)base=8;
			++nptr;
		}
	}

	/* Ѵ */
	value=0;
	for(;isalnum(*nptr);++nptr)
	{
		if(isupper(*nptr))digit=*nptr-'A'+10;
		else if(islower(*nptr))digit=*nptr-'a'+10;
		else if(isdigit(*nptr))digit=*nptr-'0';
		else break;

		if(digit>=base)break;
		value*=base;
		value+=digit;
	}

	if(endptr!=NULL)*endptr=(char*)nptr;

	return value*sign;
}


unsigned long int strtoul(const char *nptr, char **endptr, int base)
{
	return (unsigned long int)strtol(nptr,endptr,base);
}


int atoi(const char *str)
{
	int rest=0;


	for(;*str!='\0';++str)
	{
		if((*str<'0')||(*str>'9'))return 0;
		rest=rest*10+*str-'0';
	}

	return rest;
}


double atof(const char *nptr)
{
	return strtod(nptr,NULL);
}


long atol(const char *nptr)
{
	return strtol(nptr,NULL,10);
}


extern char **environ;

char *getenv(const char *name)
{
	char **p;
	char *q;
	int i;


	for(p=environ;p!=NULL;++p)
	{
		q=*p;
		for(i=0;q[i]==name[i];++i);
		if((q[i]=='=')&&(name[i]=='\0'))return q;
	}
	return NULL;
}


void abort(void)
{
	kill(getpid(),SIGABRT);
}


/* atexit()ѴؿϿ󥯡 */
typedef struct ATEXIT_FUNC{
	void (*function)(void);
	struct ATEXIT_FUNC *next;
}ATEXIT_FUNC;

static ATEXIT_FUNC *atexitFunc;

int atexit(void (*function)(void))
{
	static int count=0;

	ATEXIT_FUNC *p;


	if(count>=ATEXIT_MAX)return _error(EBUSY);

	if((p=malloc(sizeof(ATEXIT_FUNC)))==NULL)return -1;

	p->function=function;
	p->next=atexitFunc->next;
	atexitFunc=p;
	count+=1;

	return 0;
}


void exit(int state)
{
	ATEXIT_FUNC *p;


	/* atexit()Ͽؿμ¹ԡ */
	for(p=atexitFunc;p!=NULL;p=p->next)
		p->function();

	_exit(state);
}


int system(const char *string)
{
	return _error(ENOTSUP);
}
