/*
 * stat.h
 */


#ifndef sys_stat_h
#define sys_stat_h


#include<sys/types.h>
#include<share/stat.h>


enum{
	/* File type. */
	S_IFMT=0xF000,		/* format mask */

	/* File mode bits. */
	S_ISUID=0x0800,		/* Set-user-ID on execution. */
	S_ISGID=0x0400,		/* Set-group-ID on execution. */
	S_IRWXU=0x01C0,		/* Read, write, execute/search by owner. */
	S_IRUSR=0x0100,		/* Read permission, owner. */
	S_IWUSR=0x0080,		/* Write permission, owner. */
	S_IXUSR=0x0040,		/* Execute/search permission, owner. */
	S_IRWXG=0x0038,		/* Read, write, execute/search by group. */
	S_IRGRP=0x0020,		/* Read permission, group. */
	S_IWGRP=0x0010,		/* Write permission, group. */
	S_IXGRP=0x0008,		/* Execute/search permission, group. */
	S_IRWXO=0x0007,		/* Read, write, execute/search by others. */
	S_IROTH=0x0004,		/* Read permission, others. */
	S_IWOTH=0x0002,		/* Write permission, others. */
	S_IXOTH=0x0001,		/* Execute/search permission, others. */

	S_ISVTX=0x200,		/* save swapped text even after use */

	/* File types. */
	S_IFIFO=0x1000,		/* fifo */
	S_IFCHR=0x2000,		/* character device */
	S_IFDIR=0x4000,		/* directory */
	S_IFBLK=0x6000,		/* block device */
	S_IFREG=0x8000,		/* regular file */
	S_IFLNK=0xA000,		/* symbolic link */
	S_IFSOCK=0xC000,	/* socket */
};


/* The macro shall evaluate to a non-zero value if the test is true; 0 if the test is false. */
#define S_ISFIFO(m) (m&S_IFIFO)		/* Test for a pipe or FIFO special file. */
#define S_ISCHR(m)  (m&S_IFCHR)		/* Test for a character special file. */
#define S_ISDIR(m)  (m&S_IFDIR)		/* Test for a directory. */
#define S_ISBLK(m)  (m&S_IFBLK)		/* Test for a block special file. */
#define S_ISREG(m)  (m&S_IFREG)		/* Test for a regular file. */
#define S_ISLNK(m)  (m&S_IFLNK)		/* Test for a symbolic link. */
#define S_ISSOCK(m) (m&S_IFSOCK)	/* Test for a socket. */

/*
 * The implementation may implement message queues, semaphores, or shared memory objects as distinct
 * file types. The following macros shall be provided to test whether a file is of the specified type.
 * The value of the buf argument supplied to the macros is a pointer to a stat structure. The macro
 * shall evaluate to a non-zero value if the specified object is implemented as a distinct file type
 * and the specified file type is contained in the stat structure referenced by buf. Otherwise,
 * the macro shall evaluate to zero.
 */
#define S_TYPEISMQ(buf)			/* Test for a message queue. */
#define S_TYPEISSEM(buf)		/* Test for a semaphore. */
#define S_TYPEISSHM(buf)		/* Test for a shared memory object. */


/* functions and may also be defined as macros. */
extern int    chmod(const char*, mode_t);
extern int    fchmod(int, mode_t);
extern int    fstat(int, struct stat*);
extern int    lchmod(const char*, mode_t);
extern int    lstat(const char *, struct stat *);
extern int    mkdir(const char*, mode_t);
extern int    mkfifo(const char*, mode_t);
extern int    mknod(const char *, mode_t, dev_t);
extern int    stat(const char*, struct stat*);
extern mode_t umask(mode_t);

extern int openMask;	/* եεĥӥåȥޥ */


#endif
