/*
 * signal.h
 */


#ifndef signal_h
#define signal_h


#include<sys/types.h>
#include<share/signal.h>


typedef int sig_atomic_t;
typedef	void (*sig_t)(int);		/* type of signal function */


extern int	kill(pid_t, int);
extern int	sigaction(int, const struct sigaction*, struct sigaction*);
extern int	sigaddset(sigset_t*, int);
extern int	sigdelset(sigset_t*, int);
extern int	sigemptyset(sigset_t *);
extern int	sigfillset(sigset_t *);
extern int	sigismember(const sigset_t *, int);
extern int	sigpending(sigset_t *);
extern int	sigprocmask(int, const sigset_t *, sigset_t *);
extern int	sigsuspend(const sigset_t *);
extern int	sigsetpending(sigset_t *);
extern int raise(int sig);
extern sig_t signal(int, sig_t);


#endif
