/*
 * arpa/inet.h
 *
 * definitions for internet operations.
 */


#ifndef arpa_inet_h
#define arpa_inet_h


#include<netinet/in.h>


#define htons swap_int16
#define ntohs swap_int16
#define htonl swap_int32
#define ntohl swap_int32


extern inline uint16_t swap_int16(uint16_t value)
{
	return (value>>8)+(value<<8);
}

extern inline uint32_t swap_int32(uint32_t value)
{
	return (value>>24)+((value>>8)&0xff00)+((value<<8)&0xff0000)+(value<<24);
}

extern in_addr_t    inet_addr(const char *);


#endif
