/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include<types.h>
#include<segment.h>
#include<share/wait.h>


#ifndef ASM_FILE


enum{
	MAX_CHILD=8,		/* Max number of child processes */

	/* ץξ֡ */
	TASK_RUNNING=    1<<0,
	TASK_WAIT=       1<<1,
	TASK_DEVICE_WAIT=1<<2,	/* ǥХԤ */
	TASK_SIGNAL_WAIT=1<<3,	/* ʥԤ */
	TASK_TRACE=      1<<4,	/* ȥ졼档 */
	TASK_EXIT=       1<<5,	/* Exit. */
	TASK_CHILD_WAIT= 1<<6,	/* wait callԤ */
};


#define PROC_ZERO_TOP child			/* 0λϤǡ */
#define PROC_ZERO_END cpu			/* 0κǸμǡ */

/* ץ¤ */
typedef struct PROC{
	struct PROC *next;			/* Schedule linkμΥץ */
	struct PROC *prev;			/* Schedule linkΥץ */
	struct PROC *wait_next;		/* next link for wait */
	struct PROC *wait_prev;		/* prev link for wait */
	struct PROC *proc_next;		/* Process list link next. */
	struct PROC *proc_prev;		/* Process list link prev. */
	uint         esp;			/* ֤ƥȤΥåȥåesp */
	struct PROC *parent;		/* Parent process. */
	struct PROC *brother;		/* Brother process */
	struct PROC *child;			/* Child process */
	uchar        wait_update;	/* ߥȡ */
	uchar        nest_count;	/* ߥͥȥȡ */
	ushort       count_child;	/* Number of child processes */
	uint64       cpu_time[2];	/* CPU time,0:system 1:user. */
	uint         ctime[2];		/* Children clock tick,0:system 1:user. */
	uchar        exit_state;	/* Exit state. */
	uchar        signum;		/* Exit signal number. */
	uchar        cpu;			/* running cpu number ƯƤʤ-1ʲ*/
	uchar        state;			/* ץξ֡ */
	int          pid;			/* process ID. */
	int          gid;			/* groupe ID. */
	int          uid;			/* user ID. */
	void        *ctlterm;		/* ߥʥ湽¤Ρ */
	void        *timer_struct;	/* ޡ¤Ρ */
	void        *signal_struct;	/* ʥ¤Ρ */
	void        *mm_struct;		/* ꡼¤Υɥ쥹 */
	void        *file_struct;	/* ե빽¤Υɥ쥹 */
}PROC;

/* ץꥹȹ¤Ρ */
typedef struct PROC_LIST{
	struct PROC_LIST *next;
	struct PROC_LIST *prev;
	int lockGate;
}PROC_LIST;

/* cpuȤΥ¤ */
typedef struct CPU{
	int cpu;				/* number of cpu */
	PROC *current_task;		/* ߤβƯprocess */
	uint proc_num;			/* ưץ */
	int gate;				/* Lock gate */
}CPU;


extern CPU cputask[];
extern PROC_LIST procHash[];


/*
 * Get current cpu number
 * returns : current cpu number
 */
extern inline int get_current_cpu()
{
	int result;


	asm volatile(
		"xorl	%%eax,%%eax\n"\
		"str	%%ax\n"\
		"subl	%1,%%eax\n"\
		"shrl	$3,%%eax"
		:"=a"(result):"i"(TSS_DES)
	);

	return result;
}

/*
 * Get current task
 * return : Current process
 */
extern inline PROC *get_current_task()
{
	return cputask[get_current_cpu()].current_task;
}


extern void add_to_schedule(PROC*,int);
extern void del_from_schedule(int);
extern PROC *searchProcList(int);
extern void waitProc1();
extern int initProc1();
extern int init_cputask(int);
extern int set_idle_proc(int);
extern void set_tss(int);
extern void start_tasking();
extern PROC *getNextProc(PROC*,int);
extern PROC *getAllProc(PROC*);
extern void exit(int,int);
extern int sys_fork();
extern int sys_exit();
extern int sys_exec();
extern int sys_wait();
extern int sys_setgid();
extern int sys_get_procid();
extern int sys_set_procid();
extern int sys_times();
extern int sys_setsid();


#endif


#endif
