/*
 * udp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * User datagram Protocl.
 */


#include<types.h>
#include<lib.h>
#include<errno.h>
#include<mm.h>
#include<proc.h>
#include<time.h>
#include<lock.h>
#include<interrupt.h>
#include<net/net.h>
#include<net/ip.h>
#include<net/ether.h>
#include<net/udp.h>


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


static int sendNotReach()
{
	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/*
 * Note! nextǤƬ˻äƤ롣
 */
typedef struct RECV_BUF{
	struct RECV_BUF *next;
	uint             srcip;		/* Source IP. */
	char             data[0];
}RECV_BUF;


/* PUBLIC */
static SOCKET waitSocket;	/* ȥåȥ󥯡 */
static int waitLock;		/* ͥѥåȡ */


/*
 * PUBLIC
 * Get  ephemeral port number.
 * return : ephemeral port number
 */
static ushort getEphemeralPort()
{
	enum{BEGIN_EPHM_PORT=1024};		/* եݡȤκǽֹ档 */

	static int gate=0;
	static int volatile port=BEGIN_EPHM_PORT;
	int pt;


	enter_spinlock(&gate);
	{
		pt=port++;
	}
	exit_spinlock(&gate);

	return pt;
}/*
 * PRIVATE
 * Add to wait link.
 * parameters : socket
 */
static inline void addWaitLink(SOCKET *sc)
{
	enter_spinlock(&waitLock);
	{
		sc->next=waitSocket.next;
		sc->prev=&waitSocket;
		waitSocket.next->prev=sc;
		waitSocket.next=sc;
	}
	exit_spinlock(&waitLock);
}


/*
 * PRIVATE
 * Delete from wait link.
 * parameters : socket
 */
static inline void delWaitLink(SOCKET *sc)
{
	enter_spinlock(&waitLock);
	{
		while(sc->update==1);
		sc->next->prev=sc->prev;
		sc->prev->next=sc->next;
		sc->next=sc->prev=sc;
	}
	exit_spinlock(&waitLock);
}


/*
 * PRIVATE
 * Save receive data.
 * parameters : IP datagram
 * return : 0 or task switch=1
 */
static int saveRecv(IP_HEADER *ip)
{
	SOCKET *sc;
	UDP_HEADER *udp;


	/* READԤץθ */
	udp=(UDP_HEADER*)ip->data;
	enter_spinlock(&waitLock);
	{
		for(sc=waitSocket.next;;sc=sc->next)
		{
			if(sc==&waitSocket)
			{
				exit_spinlock(&waitLock);
				return sendNotReach();
			}

			if(sc->srcport==udp->dstport)break;
		}

		while(sc->update==1);
		sc->update=1;								/* åȹϡ */
	}
	exit_spinlock(&waitLock);

	/* ǡ򥽥åȤϤ */
	while(sc->buf!=NULL)wait_task();
	sc->buf=ip;

	sc->update=0;									/* åȹλ */

	/* READԤץε */
	if(sc->wait.flag!=0)
	{
		wake_intr(&sc->wait,TASK_SIGNAL_WAIT);
		return 1;
	}

	return 0;
}


/*
 * PUBLIC
 * Get data from receive buffer.
 * parameters : buffer,buffer size,flags,SOCKET,source IP pointer
 * return : copy data size of error number
 */
static int getRecvBuf(void *buf,size_t len,int flags,SOCKET *sc,uint *srcip)
{
	enum{REPLY_TIMEOUT=2000};	/* ॢȥߥá */

	int size;
	IP_HEADER *ip;
	UDP_HEADER *udp;


	for(;;)
	{
		/* 쥷֥Хåե򸡺 */
		if(sc->buf!=NULL)
		{
			ip=(IP_HEADER*)sc->buf;
			sc->buf=NULL;
			udp=(UDP_HEADER*)ip->data;

			/* ǡХåե˥ԡ */
			size=swapWord(udp->len)-sizeof(UDP_HEADER);
			if(size>len)size=len;
			memcpy(buf,udp->data,size);
			*srcip=ip->srcip;

			break;
		}

		/* ǡ쥷Ԥ */
		addWaitLink(sc);
		sc->wait.flag=0;
		wait_intr(&sc->wait,REPLY_TIMEOUT,TASK_SIGNAL_WAIT);

		/*  */
		delWaitLink(sc);
		if(sc->wait.flag)		/* Time out. */
		{
			sc->wait.flag=0;
			if(sc->buf==NULL)return -ETIMEDOUT;
		}
	}

	return size;
}


/*
 * GROBAL
 * Receive UDP frame.
 * parameters : IP data
 * return : 0 or task switch=1
 */
int receiveUdp(IP_HEADER *ip)
{
	PSEUDO_HEADER pshead;
	UDP_HEADER *udp;


	udp=(UDP_HEADER*)ip->data;
/***************************************************************************************
printk("RECV UDP srcport=%x,dstport=%x,length=%x\n",
	swapWord(udp->srcport),swapWord(udp->dstport),swapWord(udp->len));
***************************************************************************************/
	/* åγǧ */
	pshead.srcip=ip->srcip;
	pshead.dstip=ip->dstip;
	pshead.tmp=0;
	pshead.prot=ip->prot;
	pshead.len=udp->len;
	if(calcSumM((uint*)&pshead,(uint*)udp,sizeof(PSEUDO_HEADER),swapWord(udp->len)))
		return 0;

	return saveRecv(ip);
}


/**************************************************************************
 *
 * Socket interface.
 *
 **************************************************************************/


static int send(SOCKET *sc,const void *msg,size_t len,int flags,struct sockaddr *to)
{
	char head[sizeof(PSEUDO_HEADER)+sizeof(UDP_HEADER)];
	PSEUDO_HEADER *pshead;
	UDP_HEADER *udp;
	TRANS_BUF_INFO tbi;


	sc->srcport=swapWord(getEphemeralPort());

	/* Set pseudo header. */
	pshead=(PSEUDO_HEADER*)head;
	pshead->dstip=((struct sockaddr_in*)to)->sin_addr.s_addr;
	pshead->srcip=getSrcip(pshead->dstip);
	pshead->tmp=0;
	pshead->prot=IPPROTO_UDP;
	pshead->len=swapWord(len+sizeof(UDP_HEADER));

	/* Set UDP head. */
	udp=(UDP_HEADER*)(head+sizeof(PSEUDO_HEADER));
	udp->srcport=sc->srcport;
	udp->dstport=((struct sockaddr_in*)to)->sin_port;
	udp->len=swapWord(len+sizeof(UDP_HEADER));
	udp->chksum=0;
	udp->chksum=calcSumM((uint*)head,(uint*)msg,sizeof(PSEUDO_HEADER)+sizeof(UDP_HEADER),len);

	/* Хåեơ֥ */
	tbi.data[2]=(char*)msg;
	tbi.size[2]=len;
	tbi.data[1]=(char*)udp;
	tbi.size[1]=sizeof(UDP_HEADER);
	tbi.ipType=IPPROTO_UDP;
/********************************************************************************************
{
	UDP_HEADER *head=(UDP_HEADER*)msg;
	printk("TRANS UDP srcport=%x,dstport=%x,length=%x\n",udp->srcport,udp->dstport,udp->len);
}
*********************************************************************************************/
	transIp(&tbi,pshead->dstip,flags,0);

	return len;
}


/*
 * return : copy data size or error number
 */
static int recv(SOCKET *sc,void *buf,size_t len,int flags,uint32_t *srcip)
{
	return getRecvBuf(buf,len,flags,sc,srcip);
}


static int connect(SOCKET *a)
{
	return -EAFNOSUPPORT;
}


static int shutdown(SOCKET *sc,int flag)
{
	return -EOPNOTSUPP;
}


static int listen(SOCKET *sc)
{
	return -EOPNOTSUPP;
}


static int accept(SOCKET *sc,SOCKET *newsc,uint32_t *srcip)
{
	return -EOPNOTSUPP;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


static SOCKET_INFO sockInfo={send,recv,connect,shutdown,listen,accept};


/*
 * GLOBAL
 * Init UDP.
 */
int initUdp()
{
	registSocket(&sockInfo,IPPROTO_UDP);
	waitSocket.next=waitSocket.prev=&waitSocket;

	return 0;
}
