/*
 * net.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥåȥ̥롼
 */


#include<types.h>
#include<errno.h>
#include<lib.h>
#include<mm.h>
#include<proc.h>
#include<lock.h>
#include<fs.h>
#include<net/arp.h>
#include<net/icmp.h>
#include<net/udp.h>
#include<net/tcp.h>
#include<net/net.h>
#include<share/socket.h>


/************************************************************************************
 *
 * Misc
 *
 ************************************************************************************/


typedef struct RECV_BUF{
	struct RECV_BUF *next;
}RECV_BUF;


/*
 * GLOBAL
 * åη׻
 * parameters : data1 address,data2 address,byte size1,byte size2
 * return : פ
 */
ushort calcSum(uint *data,int size)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	}sum;
	uint tmp;


	sum.u64=0;
	for(;size>=sizeof(uint);size-=sizeof(uint))
		sum.u64+=*data++;
	if(size>0)sum.u64+=*data&((1<<(size*8))-1);

	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u64+=tmp;
	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u32[0]+=tmp;

	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u32[0]+=tmp;
	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u16[0]+=tmp;

	return ~sum.u16[0];
}

/*
 * Note!
 *  size1uintǳڤˤƤ롣
 */
ushort calcSumM(uint *data1,uint *data2,int size1,int size2)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	}sum;
	uint tmp;


	sum.u64=0;
	for(;size1>=sizeof(uint);size1-=sizeof(uint))
		sum.u64+=*data1++;
	for(;size2>=sizeof(uint);size2-=sizeof(uint))
		sum.u64+=*data2++;
	if(size2>0)sum.u64+=*data2&((1<<(size2*8))-1);

	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u64+=tmp;
	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u32[0]+=tmp;

	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u32[0]+=tmp;
	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u16[0]+=tmp;

	return ~sum.u16[0];
}


/*
 * GLOBAL
 * Close socket.
 * parameters : socket address
 * return : 0 or error number
 */
void closeSocket(SOCKET *sc)
{
	/* åȤγ */
	if(sc->sockType==SOCK_STREAM)
		releaseSckFromConect(sc);
	else kfree(sc);
}


/************************************************************************************
 *
 * Systemcall interface
 *
 ************************************************************************************/


enum{
	IP_PROTNUM_MAX=17,		/* IP ̥ץȥʥС͡ */
	SOCKET_MAX=10,			/* ץλĥåȤκ */
};


static SOCKET_INFO *sockInfo[IP_PROTNUM_MAX+1];
static FS *fs;


int sys_socket(int domain, int type, int protocol)
{
	int num;
	int fd;
	int rest;
	SOCKET *sc;


	/* ե륪ץå */
	if((rest=checkFileOpen())<0)return rest;

	switch(domain)
	{
		case AF_INET:
			switch(type)
			{
				case SOCK_DGRAM:
					if((protocol==0)||(protocol==IPPROTO_UDP))num=IPPROTO_UDP;
					else return -EPROTONOSUPPORT;
					break;
				case SOCK_STREAM:
					if((protocol==0)||(protocol==IPPROTO_TCP))num=IPPROTO_TCP;
					else return -EPROTONOSUPPORT;
					break;
				case SOCK_RAW:
					if((protocol==0)||(protocol==IPPROTO_ICMP))num=IPPROTO_ICMP;
					else return -EPROTONOSUPPORT;
					break;
				default:
					return -EPROTONOSUPPORT;
			}
			break;
		default:
			return -EPROTONOSUPPORT;
	}

	if((sc=kmalloc(sizeof(SOCKET)))==NULL)return -ENOMEM;
	sc->fs=fs;
	sc->sc=sc;
	if((fd=setFd((VENTRY*)&sc->fs,FD_FORM_NETSOKET,O_RDWR,0,(F_DSC*)sc))<0)
	{
		kfree(sc);
		return fd;
	}
	sc->sockType=type;
	sc->stat=0;
	sc->update=0;
	sc->sinf=sockInfo[num];
	sc->buf=NULL;
	sc->wait.flag=0;

	/* ץϿ */
	return fd;
}


int sys_send(int sd,const void *msg,size_t len,int flags,struct sockaddr *to)
{
	SOCKET *sc;


	if((sc=(SOCKET*)getFd(sd))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;
	if((to!=NULL)&&(checkMem(to)==-1))return -EFAULT;

	return ((SOCKET_INFO*)sc->sinf)->send(sc,msg,len,flags,to);
}


int sys_recv(int sd,void *buf,size_t len,int flags,struct sockaddr *from,socklen_t *fromlen)
{
	int rest;
	uint32_t srcip;
	SOCKET *sc;


	if((sc=(SOCKET*)getFd(sd))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;
	if(checkMem(buf)==-1)return -EFAULT;
	if(from!=NULL)
	{
		if((checkMem(from)==-1)||(checkMem(fromlen)==-1))return -EFAULT;
		rest=((SOCKET_INFO*)sc->sinf)->recv(sc,buf,len,flags,&srcip);
		if(*fromlen>=sizeof(struct sockaddr)+sizeof(uint32_t))
		{
			*(uint32_t*)from->sa_data=srcip;
			*fromlen=sizeof(struct sockaddr)+sizeof(uint32_t);
		}

		return rest;
	}
	else
		return ((SOCKET_INFO*)sc->sinf)->recv(sc,buf,len,flags,&srcip);
}


int sys_connect(int sockfd, const struct sockaddr *serv_addr)
{
	SOCKET *sc;


	if((sc=(SOCKET*)getFd(sockfd))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;
	if(checkMem((void*)serv_addr)==-1)return -EFAULT;

	sc->dstip=((struct sockaddr_in*)serv_addr)->sin_addr.s_addr;
	sc->dstport=((struct sockaddr_in*)serv_addr)->sin_port;

	return ((SOCKET_INFO*)sc->sinf)->connect(sc);
}


int sys_shutdown(int s, int how)
{
	SOCKET *sc;


	if((sc=(SOCKET*)getFd(s))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;

	return ((SOCKET_INFO*)sc->sinf)->shutdown(sc,how);
}


int sys_bind(int sockfd, struct sockaddr *my_addr)
{
	SOCKET *sc;


	if((sc=(SOCKET*)getFd(sockfd))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;
	if(checkMem((void*)my_addr)==-1)return -EFAULT;

	sc->srcip=((struct sockaddr_in*)my_addr)->sin_addr.s_addr;
	sc->srcport=((struct sockaddr_in*)my_addr)->sin_port;

	return 0;
}


int sys_listen(int s, int backlog)
{
	SOCKET *sc;


	if((sc=(SOCKET*)getFd(s))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;

	return ((SOCKET_INFO*)sc->sinf)->listen(sc);
}


int sys_accept(int s, struct sockaddr *addr, socklen_t *addrlen)
{
	int fd;
	int rest;
	SOCKET *sc,*newsc;
	uint32_t srcip;


	if((sc=(SOCKET*)getFd(s))==NULL)return -EBADF;
	if(sc->fd.form!=FD_FORM_NETSOKET)return -ENOTSOCK;
	if((sc->sockType!=SOCK_STREAM)&&(sc->sockType!=SOCK_DGRAM))return -EOPNOTSUPP;

	if(addr!=NULL)
	{
		if((checkMem(addr)==-1)||(checkMem(addrlen)==-1))return -EFAULT;
	}

	/* åȤγơ */
	/* ե륪ץå */
	if((rest=checkFileOpen())<0)return rest;
	if((newsc=kmalloc(sizeof(SOCKET)))==NULL)return -ENOMEM;
	newsc->fs=fs;
	newsc->sc=newsc;
	if((fd=setFd((VENTRY*)&sc->fs,FD_FORM_NETSOKET,O_RDWR,0,(F_DSC*)newsc))<0)
	{
		kfree(newsc);
		return fd;
	}

	/* ³׵Ԥ */
	if((rest=((SOCKET_INFO*)sc->sinf)->accept(sc,newsc,&srcip))<0)
	{
		sys_close(fd);
		return rest;
	}

	if(addr!=NULL)
		if(*addrlen>=sizeof(struct sockaddr)+sizeof(uint32_t))
		{
			*(uint32_t*)addr->sa_data=srcip;
			*addrlen=sizeof(struct sockaddr)+sizeof(uint32_t);
		}

	return fd;
}


/************************************************************************************
 *
 * File system interface
 *
 ************************************************************************************/


static uint mount(int din)
{
	return -ENOTSUP;
}

static int umount(int din)
{
	return -ENOTSUP;
}

static int open(const char *path,int din,uint dir_inode,int flag,uint *inode)
{
	return -ENOTSUP;
}

static int close(int din,uint inode)
{
	return 0;
}

static int read(int din,uint inode,void *buf,size_t size,size_t begin)
{
	uint32_t srcip;


	return ((SOCKET_INFO*)((SOCKET*)inode)->sinf)->recv((SOCKET*)inode,buf,size,0,&srcip);
}

static int write(int din,uint inode,void *buf,size_t size,size_t begin)
{
	return ((SOCKET_INFO*)((SOCKET*)inode)->sinf)->send((SOCKET*)inode,buf,size,0,NULL);
}

static int ioctl(int din,uint inode,int prm_num,int cmd,...)
{
	return -ENOTSUP;
}

static int rename(int din,uint old_dinode,const char *old_path,uint new_dinode,const char *new_path)
{
	return -ENOTSUP;
}

static int creat(const char *path,int din,uint dir_inode,int mode)
{
	return -ENOTSUP;
}

static int opendir(const char *path,int din,uint dir_inode,uint *inode,uint *block)
{
	return -ENOTSUP;
}

static int mkdir(const char *path,int din,uint dir_inode,int mode)
{
	return -ENOTSUP;
}

static int stat(int din,uint inode,FSTAT *fstat)
{
	return -ENOTSUP;
}

static int delete(const char *path,int din,uint dir_inode,int type)
{
	return -ENOTSUP;
}

static int readdir(int din,uint inode,uint *block,uint *index,char *name)
{
	return -ENOTSUP;
}

static int chattr(int din,uint inode,uint mode,uint uid,uint gid,uint atime,uint mtime)
{
	return -ENOTSUP;
}

static int mklink(int din,uint oldinode,uint newind,const char *newpath)
{
	return -ENOTSUP;
}


/************************************************************************************
 *
 * 
 *
 ************************************************************************************/


static FS netfs={
	"net",mount,umount,open,close,read,write,ioctl,rename,creat,opendir,mkdir,stat,delete,readdir,chattr,
	mklink,NULL
};


/*
 * GLOBAL
 * Regist socket information.
 * parameters : SOCKET_INFO address,protocol number
 * return : 0
 */
int registSocket(SOCKET_INFO *sinf,int prot)
{
	sockInfo[prot]=sinf;

	return 0;
}


/*
 * GLOBAL
 * Init network.
 */
int initNet()
{
	initArp();
	initIcmp();
	initUdp();
	initTcp();
	fs=&netfs;

	return 0;
}
