/*
 * icmp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Internet controlMessage Protocl.
 */


#include<types.h>
#include<lib.h>
#include<errno.h>
#include<mm.h>
#include<proc.h>
#include<time.h>
#include<net/net.h>
#include<net/ip.h>
#include<net/icmp.h>
#include<test.h>


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/*
 * PUBLIC
 * Transmit ICMP frame.
 * parameters : destination IP,type,code,ICMP head address,ICMP data size
 */
static void transIcmp(uint dstip,uchar type,uchar code,ICMP_HEADER *head,int size)
{
	TRANS_BUF_INFO tbi;


	/* إåꡣ */
	head->type=type;
	head->code=code;
	head->chksum=0;
	head->chksum=calcSum((uint*)head,size);

	/* Хåեơ֥ */
	tbi.data[2]=NULL;
	tbi.size[2]=0;
	tbi.data[1]=(char*)head;
	tbi.size[1]=size;
	tbi.ipType=IPPROTO_ICMP;
/****************************************************************************
printk("TRANS ICMP type=%d,code=%d\n",head->type,head->code);
****************************************************************************/
	transIp(&tbi,dstip,0,0);
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/*
 * Note! nextǤƬ˻äƤ롣
 */
typedef struct RECV_BUF{
	struct RECV_BUF *next;
	uint             time;		/* Recieve time. */
	int              count;		/* Ԥץȡ */
	char             data[0];
}RECV_BUF;

typedef struct REPLY_WAIT{
	WAIT_INTR          wait;
	struct REPLY_WAIT *next;
}REPLY_WAIT;


/* PRIVATE */
static RECV_BUF *recvBuf=NULL;
static REPLY_WAIT *repWait=NULL;


/*
 * PRIVATE
 * Save receive data.
 * parameters : IP data,data size
 * return : 0 or task switch=1
 */
static int saveRecv(IP_HEADER *head,int size)
{
	enum{DEL_BUF_TIME=4};	/* оݤˤʤХåեηвá */

	uint ctime;
	RECV_BUF *recv;
	RECV_BUF *p,*q;
	REPLY_WAIT *r;


	ctime=sys_time();	/* Current time. */

	/* Save buffer. */
	if((recv=kmalloc(sizeof(RECV_BUF)+size))==NULL)return 0;
	memcpy(recv->data,head,size);
	recv->time=ctime;
	recv->count=0;
	recv->next=NULL;

	/* Add to buffer link. */
	recv->next=recvBuf;
	recvBuf=recv;

	/* ॢȥХåեκ */
	for(p=recv;p->next!=NULL;p=p->next)
		if(ctime-p->next->time>=DEL_BUF_TIME)
		{
			q=p->next;
			p->next=q->next;
			kfree(q);
		}

	/* READԤץε */
	for(r=repWait;r!=NULL;r=r->next)
	{
		++recv->count;
		wake_intr(&r->wait,TASK_SIGNAL_WAIT);
	}

	return 0;
}


/*
 * PUBLIC
 * Get reply from receive buffer.
 * parameters : buffer,buffer size,flags
 * return : copy data size of error number
 */
static int getRecvBuf(void *buf,size_t len,int flags)
{
	enum{REPLY_TIMEOUT=2000};	/* ॢȥߥá */

	int size;
	int wf,waitf;
	REPLY_WAIT *wait;
	RECV_BUF *p,*q;
	REPLY_WAIT *r;


	waitf=0;	/* 쥷ԤƤ뤫ɤΥե饰 */
	for(;;)
	{
		/* 쥷֥Хåե鸡 */
		if((p=recvBuf)!=NULL)
		{
			do
			{
				q=p;
			}while(q->next!=NULL);
			size=swapWord(((IP_HEADER*)q->data)->len);
			if(size>len)size=len;
			memcpy(buf,q->data,size);

			if(q->count-waitf<=0)
			{
				if(p==recvBuf)recvBuf=NULL;
				else p->next=NULL;
				kfree(q);
			}

			return size;
		}

		/* ǡ쥷Ԥ */
		if((wait=kmalloc(sizeof(REPLY_WAIT)))==NULL)return -ENOMEM;
		wait->wait.flag=0;
		wait->next=repWait;
		repWait=wait;
		waitf=1;
		wait_intr(&wait->wait,REPLY_TIMEOUT,TASK_SIGNAL_WAIT);

		/*  */
		wf=wait->wait.flag;
		if(repWait==wait)repWait=wait->next;
		else
			for(r=repWait;;r=r->next)
				if(r->next==wait)
				{
					r->next=wait->next;
					break;
				}
		kfree(wait);
		if(wf==1)return -EAGAIN;
	}
}


/*
 * GROBAL
 * Receive ICMP frame.
 * parameters : IP data
 * return : 0 or task switch=1
 */
int receiveIcmp(IP_HEADER *head)
{
	int icmp_size;
	ICMP_HEADER *icmp;


	icmp=(ICMP_HEADER*)head->data;
/**************************************************************************
printk("RECV ICMP type=%x,code=%x\n",icmp->type,icmp->code);
**************************************************************************/
	icmp_size=swapWord(head->len)-sizeof(IP_HEADER);

	/* åγǧ */
	if(calcSum((uint*)icmp,icmp_size))return 0;

	switch(icmp->type)
	{
		case ICMP_TYPE_ECHOREQ:
			transIcmp(head->srcip,ICMP_TYPE_ECHOREP,0,icmp,icmp_size);
			break;
		case ICMP_TYPE_ECHOREP:
			return saveRecv(head,icmp_size+sizeof(IP_HEADER));
	}

	return 0;
}


/**************************************************************************
 *
 * Socket interface.
 *
 **************************************************************************/


static int send(SOCKET *sc,const void *msg,size_t len,int flags,struct sockaddr *to)
{
	TRANS_BUF_INFO tbi;


	/* Хåեơ֥ */
	tbi.data[2]=NULL;
	tbi.size[2]=0;
	tbi.data[1]=(char*)msg;
	tbi.size[1]=len;
	tbi.ipType=IPPROTO_ICMP;
/****************************************************************************
{
	ICMP_HEADER *head=(ICMP_HEADER*)msg;
	printk("TRANS ICMP type=%d,code=%d\n",head->type,head->code);
}
****************************************************************************/
	transIp(&tbi,((struct sockaddr_in*)to)->sin_addr.s_addr,flags,0);

	return len;
}


/*
 * return : copy data size or error number
 */
static int recv(SOCKET *sc,void *buf,size_t len,int flags,uint32_t *srcip)
{
	int rest;


	if((rest=getRecvBuf(buf,len,flags))<0)return rest;
	*srcip=((IP_HEADER*)buf)->srcip;

	return rest;
}


static int connect(SOCKET *a)
{
	return -EOPNOTSUPP;
}

static int shutdown(SOCKET *sc,int flag)
{
	return -EOPNOTSUPP;
}

static int listen(SOCKET *a)
{
	return -EOPNOTSUPP;
}

static int accept(SOCKET *sc,SOCKET *newsc,uint32_t *srcip)
{
	return -EOPNOTSUPP;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


static SOCKET_INFO sockInfo={send,recv,connect,shutdown,listen,accept};


/*
 * GLOBAL
 * Init ICMP.
 */
int initIcmp()
{
	registSocket(&sockInfo,IPPROTO_ICMP);

	return 0;
}
