/*
 * ether.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef ethernet_h
#define ethernet_h


#include<device.h>


#ifndef ASM_FILE


enum{
	ETHER_FRAME_SIZE_MAX=1536,		/* Maximam ethernet frame size. */
	ETHER_FRAME_SIZE_MIN=60,		/* Minimam ethernet frame size. */

	/* DIXѥե졼Υե졼ॿס */
	DIX_TYPE_IP= 0x0800,	/* IPץȥե졼ࡣ */
	DIX_TYPE_ARP=0x0806,	/* ARPץȥե졼ࡣ */

	/* ETHER_DEVICE¤γǼ¿ */
	ETHER_DEVICE_MAX=2,
};


/* Ethernet device infomation. */
typedef struct{
	DEV_INFO *dev;
	uint      ip;		/* IP address. */
	uint      netmask;	/* ֥ͥåȥޥ */
	uint      subnet;	/* ֥ͥåȡ */
	int       mtu;		/* MTU size. */
	char      mac[6];	/* MAC address. */
}ETHER_DEVICE;

typedef struct{
	uchar  dstmac[6];	/* Destination MAC ID. */
	uchar  srcmac[6];	/* Source MAC ID. */
	ushort type;		/* Frame type(DIX) or frame length(IEEE). */
	char   data[0];
}ETHER_FRAME;


extern ETHER_DEVICE ethDev[];


extern int searchDevnum(uint,uint*);
extern uint32_t getSrcip(uint32_t);
extern int receiveEther(int num,ETHER_FRAME *frame);
extern int setEtherDevice(int ethnum,DEV_INFO *devinf,char *mac);
extern int initEther();


#endif


#endif
