/*
 * utime.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<unistd.h>
#include<utime.h>


int utime(const char *filename, struct utimbuf *buf)
{
	int rest;


	if((rest=syscall4(SYS_CHATTR,(int)filename,CHATTR_UTIME,(int)buf))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}
