/*
 * socket.h
 */


#ifndef sys_socket_h
#define sys_socket_h


#include<sys/uio.h>
#include<share/socket.h>


struct sockaddr_storage{
	sa_family_t   ss_family;
};

struct msghdr{
	void          *msg_name;		/* Optional address. */
	socklen_t      msg_namelen;		/* Size of address. */
	struct iovec  *msg_iov;			/* Scatter/gather array. */
	int            msg_iovlen;		/* Members in msg_iov. */
	void          *msg_control;		/* Ancillary data; see below. */
	socklen_t      msg_controllen;	/* Ancillary data buffer len. */
	int            msg_flags;		/* Flags on received message. */
};

struct cmsghdr{
	socklen_t  cmsg_len;	/* Data byte count, including the cmsghdr. */
	int        cmsg_level;	/* Originating protocol. */
	int        cmsg_type;	/* Protocol-specific type. */
};

struct linger{
	int  l_onoff;	/* Indicates whether linger option is enabled. */
	int  l_linger;	/* Linger time, in seconds. */
};


extern int     accept(int, struct sockaddr *, socklen_t *);
extern int     bind(int, const struct sockaddr *, socklen_t);
extern int     connect(int, const struct sockaddr *, socklen_t);
extern int     listen(int, int);
extern ssize_t recvfrom(int, void *, size_t, int,struct sockaddr *, socklen_t *);
extern ssize_t recv(int, void *, size_t, int);
extern ssize_t sendto(int, const void *, size_t, int, const struct sockaddr *,socklen_t);
extern ssize_t send(int, const void *, size_t, int);
extern int     shutdown(int, int);
extern int     socket(int, int, int);
extern ushort calcSum(uint*,int);

extern inline ssize_t recv(int s, void *buf, size_t len, int flags)
{
	return recvfrom(s,buf,len,flags,NULL,NULL);
}

/* ̤ */
extern int     getpeername(int, struct sockaddr *, socklen_t *);
extern int     getsockname(int, struct sockaddr *, socklen_t *);
extern int     getsockopt(int, int, int, void *, socklen_t *);
extern ssize_t recvmsg(int, struct msghdr *, int);
extern ssize_t sendmsg(int, const struct msghdr *, int);
extern int     setsockopt(int, int, int, const void *, socklen_t);
extern int     sockatmark(int);
extern int     socketpair(int, int, int, int[2]);


#endif
